/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.read;

import java.io.EOFException;
import java.io.IOException;
import org.mariadb.jdbc.internal.stream.MariaDbInputStream;
import org.mariadb.jdbc.internal.util.buffer.Buffer;

public class ReadPacketFetcher {
    public static final int AVOID_CREATE_BUFFER_LENGTH = 4096;
    private final MariaDbInputStream inputStream;
    private byte[] headerBuffer = new byte[4];
    private byte[] reusableBuffer = new byte[4096];
    private int lastPacketSeq;

    public ReadPacketFetcher(MariaDbInputStream is) {
        this.inputStream = is;
    }

    public int getPacketLength() throws IOException {
        return this.inputStream.readHeader();
    }

    public Buffer getPacket() throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.headerBuffer, off, remaining)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (4 - remaining) + " bytes from " + 4);
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        this.lastPacketSeq = this.headerBuffer[3];
        int length = (this.headerBuffer[0] & 0xFF) + ((this.headerBuffer[1] & 0xFF) << 8) + ((this.headerBuffer[2] & 0xFF) << 16);
        byte[] rawBytes = new byte[length];
        remaining = length;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (length - remaining) + " bytes from " + length);
            }
            off += count;
        } while ((remaining -= count) > 0);
        return new Buffer(rawBytes, length);
    }

    public Buffer getReusableBuffer(int length, byte[] lastReusableArray) throws IOException {
        int count;
        byte[] rawBytes = length < 4096 ? this.reusableBuffer : (lastReusableArray != null && lastReusableArray.length > length ? lastReusableArray : new byte[length]);
        int reads = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, reads, length - reads)) >= 0) continue;
            throw new EOFException("unexpected end of stream, read " + reads + " bytes from " + length);
        } while ((reads += count) < length);
        return new Buffer(rawBytes, length);
    }

    public Buffer getReusableBuffer() throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.headerBuffer, off, remaining)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (4 - remaining) + " bytes from " + 4);
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        this.lastPacketSeq = this.headerBuffer[3];
        int length = (this.headerBuffer[0] & 0xFF) + ((this.headerBuffer[1] & 0xFF) << 8) + ((this.headerBuffer[2] & 0xFF) << 16);
        byte[] rawBytes = length < 4096 ? this.reusableBuffer : new byte[length];
        remaining = length;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (length - remaining) + " bytes from " + length);
            }
            off += count;
        } while ((remaining -= count) > 0);
        return new Buffer(rawBytes, length);
    }

    public int getLastPacketSeq() {
        return this.lastPacketSeq;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public MariaDbInputStream getInputStream() {
        return this.inputStream;
    }

    public byte[] readLength(int length) throws IOException {
        int count;
        byte[] valueBuffer = new byte[length];
        int remainingToRead = length;
        int off = 0;
        do {
            if ((count = this.inputStream.read(valueBuffer, off, remainingToRead)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (length - remainingToRead) + " bytes from " + length);
            }
            off += count;
        } while ((remainingToRead -= count) > 0);
        return valueBuffer;
    }
}

