/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public class FailoverProxy
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(FailoverProxy.class);
    public static final String METHOD_IS_EXPLICIT_CLOSED = "isExplicitClosed";
    public static final String METHOD_GET_OPTIONS = "getOptions";
    public static final String METHOD_GET_PROXY = "getProxy";
    public static final String METHOD_EXECUTE_QUERY = "executeQuery";
    public static final String METHOD_SET_READ_ONLY = "setReadonly";
    public static final String METHOD_IS_READ_ONLY = "isReadOnly";
    public static final String METHOD_CLOSED_EXPLICIT = "closeExplicit";
    public static final String METHOD_IS_CLOSED = "isClosed";
    public static final String METHOD_EXECUTE_PREPARED_QUERY = "executePreparedQuery";
    public static final String METHOD_COM_MULTI_PREPARE_EXECUTES = "prepareAndExecutesComMulti";
    public static final String METHOD_PROLOG_PROXY = "prologProxy";
    public final ReentrantLock lock;
    private Listener listener;

    public FailoverProxy(Listener listener, ReentrantLock lock) throws QueryException {
        this.lock = lock;
        this.listener = listener;
        this.listener.setProxy(this);
        this.listener.initializeConnection();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "isExplicitClosed": {
                return this.listener.isExplicitClosed();
            }
            case "getOptions": {
                return this.listener.getUrlParser().getOptions();
            }
            case "getProxy": {
                return this;
            }
            case "isClosed": {
                return this.listener.isClosed();
            }
            case "executeQuery": {
                try {
                    this.listener.preExecute();
                    break;
                }
                catch (QueryException e) {
                    if (!this.hasToHandleFailover(e)) break;
                    return this.handleFailOver(e, method, args, this.listener.getCurrentProtocol());
                }
            }
            case "setReadonly": {
                this.listener.switchReadOnlyConnection((Boolean)args[0]);
                return null;
            }
            case "isReadOnly": {
                return this.listener.isReadOnly();
            }
            case "closeExplicit": {
                this.listener.preClose();
                return null;
            }
            case "prepareAndExecutesComMulti": 
            case "executePreparedQuery": {
                boolean mustBeOnMaster = (Boolean)args[0];
                ServerPrepareResult serverPrepareResult = (ServerPrepareResult)args[1];
                if (serverPrepareResult == null) break;
                if (!mustBeOnMaster && serverPrepareResult.getUnProxiedProtocol().isMasterConnection() && !this.listener.hasHostFail()) {
                    try {
                        logger.trace("re-prepare query \"" + serverPrepareResult.getSql() + "\" on slave (was " + "temporary on master since failover)");
                        this.listener.rePrepareOnSlave(serverPrepareResult, mustBeOnMaster);
                    }
                    catch (QueryException queryException) {
                        // empty catch block
                    }
                }
                try {
                    return this.listener.invoke(method, args, serverPrepareResult.getUnProxiedProtocol());
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null) {
                        if (e.getTargetException() instanceof QueryException && this.hasToHandleFailover((QueryException)e.getTargetException())) {
                            return this.handleFailOver((QueryException)e.getTargetException(), method, args, serverPrepareResult.getUnProxiedProtocol());
                        }
                        throw e.getTargetException();
                    }
                    throw e;
                }
            }
            case "prologProxy": {
                try {
                    if (args[0] != null) {
                        return this.listener.invoke(method, args, ((ServerPrepareResult)args[0]).getUnProxiedProtocol());
                    }
                    break;
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null) {
                        if (e.getTargetException() instanceof QueryException && this.hasToHandleFailover((QueryException)e.getTargetException())) {
                            return this.handleFailOver((QueryException)e.getTargetException(), method, args, ((ServerPrepareResult)args[0]).getUnProxiedProtocol());
                        }
                        throw e.getTargetException();
                    }
                    throw e;
                }
            }
        }
        try {
            return this.listener.invoke(method, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof QueryException && this.hasToHandleFailover((QueryException)e.getTargetException())) {
                    return this.handleFailOver((QueryException)e.getTargetException(), method, args, this.listener.getCurrentProtocol());
                }
                throw e.getTargetException();
            }
            throw e;
        }
    }

    private Object handleFailOver(QueryException qe, Method method, Object[] args, Protocol protocol) throws Throwable {
        HostAddress failHostAddress = null;
        boolean failIsMaster = true;
        if (protocol != null) {
            failHostAddress = protocol.getHostAddress();
            failIsMaster = protocol.isMasterConnection();
        }
        HandleErrorResult handleErrorResult = this.listener.handleFailover(qe, method, args, protocol);
        if (handleErrorResult.mustThrowError) {
            this.listener.throwFailoverMessage(failHostAddress, failIsMaster, qe, handleErrorResult.isReconnected);
        }
        return handleErrorResult.resultObject;
    }

    public boolean hasToHandleFailover(QueryException exception) {
        return exception.getSqlState() != null && exception.getSqlState().startsWith("08");
    }

    public void reconnect() throws SQLException {
        try {
            this.listener.reconnect();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, null, null);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

