/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;

public class ResultSetPacket
extends AbstractResultPacket {
    private final long fieldCount;

    public ResultSetPacket(ByteBuffer byteBuffer) throws IOException {
        this.fieldCount = ResultSetPacket.getLengthEncodedBinary(byteBuffer);
        if (this.fieldCount == -1L) {
            throw new AssertionError((Object)"field count is -1 in ResultSetPacket.");
        }
        if (byteBuffer.remaining() != 0) {
            throw new IOException("invalid stream contents ,expected result set stream, actual stream hexdump = " + MasterProtocol.hexdump(byteBuffer, 0));
        }
    }

    @Override
    public AbstractResultPacket.ResultType getResultType() {
        return AbstractResultPacket.ResultType.RESULTSET;
    }

    public long getFieldCount() {
        return this.fieldCount;
    }
}

