/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Deque;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbParameterMetaData;
import org.mariadb.jdbc.MariaDbResultSetMetaData;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbServerPreparedStatement
extends AbstractMariaDbPrepareStatement
implements Cloneable {
    String sql;
    PrepareResult prepareResult;
    boolean returnTableAlias = false;
    int parameterCount;
    MariaDbResultSetMetaData metadata;
    MariaDbParameterMetaData parameterMetaData;
    ParameterHolder[] currentParameterHolder;
    Deque<ParameterHolder[]> queryParameters = new ArrayDeque<ParameterHolder[]>();

    public MariaDbServerPreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType) throws SQLException {
        super(connection, resultSetScrollType);
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        this.sql = sql;
        this.prepare(sql);
    }

    @Override
    public MariaDbServerPreparedStatement clone() throws CloneNotSupportedException {
        MariaDbServerPreparedStatement clone = (MariaDbServerPreparedStatement)super.clone();
        clone.metadata = this.metadata;
        clone.parameterMetaData = this.parameterMetaData;
        clone.currentParameterHolder = new ParameterHolder[this.prepareResult.getParameters().length];
        clone.queryParameters = new ArrayDeque<ParameterHolder[]>();
        try {
            clone.prepare(this.sql);
        }
        catch (SQLException e) {
            throw new CloneNotSupportedException("PrepareStatement not ");
        }
        return clone;
    }

    private void prepare(String sql) throws SQLException {
        this.checkClose();
        try {
            this.connection.lock.lock();
            try {
                if (this.protocol.hasUnreadData()) {
                    ExceptionMapper.throwException(new QueryException("There is an open result set on the current connection, which must be closed prior to executing a query"), this.connection, this);
                }
                this.prepareResult = this.protocol.prepare(sql);
            }
            finally {
                this.connection.lock.unlock();
            }
            this.parameterCount = this.prepareResult.getParameters().length;
            this.currentParameterHolder = new ParameterHolder[this.prepareResult.getParameters().length];
            this.returnTableAlias = this.protocol.getOptions().useOldAliasMetadataBehavior;
            this.metadata = new MariaDbResultSetMetaData(this.prepareResult.getColumns(), this.protocol.getDataTypeMappingFlags(), this.returnTableAlias);
            this.parameterMetaData = new MariaDbParameterMetaData(this.prepareResult.getParameters());
        }
        catch (QueryException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 0 || parameterIndex > this.currentParameterHolder.length) {
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + ", parameter length is " + this.parameterCount);
        }
        this.currentParameterHolder[parameterIndex - 1] = holder;
    }

    protected ParameterHolder getCurrentParameterHolder(int parameterIndex) {
        return this.currentParameterHolder[parameterIndex];
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        this.queryParameters.add((ParameterHolder[])this.currentParameterHolder.clone());
    }

    protected void setCurrentParameterHolder(ParameterHolder[] currentParameterHolder) throws SQLException {
        this.currentParameterHolder = currentParameterHolder;
    }

    @Override
    public void clearBatch() {
        this.queryParameters.clear();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        if (this.parameterCount > 0 && this.queryParameters.size() == 0) {
            throw ExceptionMapper.getSqlException("No Parameters set. The command addBatch() must have been set");
        }
        MariaDbType[] parameterTypeHeader = new MariaDbType[this.parameterCount];
        this.connection.lock.lock();
        this.executing = true;
        QueryException exception = null;
        MultiIntExecutionResult internalExecutionResult = null;
        try {
            this.executeQueryProlog();
            try {
                ParameterHolder[] parameters;
                int queryParameterSize = this.queryParameters.size();
                internalExecutionResult = new MultiIntExecutionResult((Statement)this, queryParameterSize, 0, false);
                while ((parameters = this.queryParameters.poll()) != null) {
                    try {
                        this.protocol.executePreparedQuery(this.sql, internalExecutionResult, parameters, this.prepareResult, parameterTypeHeader, this.resultSetScrollType);
                        if (internalExecutionResult.getFailureObject() != null) {
                            this.prepareResult = internalExecutionResult.getFailureObject();
                        }
                        this.cacheMoreResults(internalExecutionResult, 0, false);
                    }
                    catch (QueryException queryException) {
                        if (this.protocol.getOptions().continueBatchOnError) {
                            if (exception != null) continue;
                            exception = queryException;
                            continue;
                        }
                        throw queryException;
                    }
                }
                this.executionResult = internalExecutionResult;
            }
            catch (QueryException queryException) {
                exception = queryException;
            }
            finally {
                this.executing = false;
                this.executeQueryEpilog(exception);
            }
            int[] queryException = internalExecutionResult.getAffectedRows();
            return queryException;
        }
        catch (SQLException sqle) {
            this.clearBatch();
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), internalExecutionResult.getAffectedRows(), (Throwable)sqle);
        }
        finally {
            this.connection.lock.unlock();
            this.clearBatch();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.executionResult.getResult();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.currentParameterHolder = new ParameterHolder[this.prepareResult.getParameters().length];
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(this.getFetchSize(), false);
    }

    protected void validParameters() throws SQLException {
        for (int i = 0; i < this.parameterCount; ++i) {
            if (this.currentParameterHolder[i] != null) continue;
            ExceptionMapper.throwException(new QueryException("Parameter at position " + (i + 1) + " is not set", -1, "07004"), this.connection, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal(int fetchSize, boolean canHaveCallableResultset) throws SQLException {
        this.isClosed();
        this.validParameters();
        this.connection.lock.lock();
        try {
            this.executing = true;
            QueryException exception = null;
            this.executeQueryProlog();
            try {
                SingleExecutionResult internalExecutionResult = new SingleExecutionResult(this, fetchSize, true, canHaveCallableResultset);
                this.protocol.executePreparedQuery(this.sql, internalExecutionResult, this.currentParameterHolder, this.prepareResult, new MariaDbType[this.parameterCount], this.resultSetScrollType);
                if (internalExecutionResult.getFailureObject() != null) {
                    this.prepareResult = internalExecutionResult.getFailureObject();
                }
                this.cacheMoreResults(internalExecutionResult, fetchSize, canHaveCallableResultset);
                this.executionResult = internalExecutionResult;
                boolean bl = this.executionResult.getResult() != null;
                this.executing = false;
            }
            catch (QueryException e) {
                try {
                    exception = e;
                    boolean bl = false;
                    this.executing = false;
                }
                catch (Throwable throwable) {
                    try {
                        this.executing = false;
                        this.executeQueryEpilog(exception);
                        boolean bl = true;
                        this.connection.lock.unlock();
                        this.clearBatch();
                        return bl;
                    }
                    catch (SQLException sqle) {
                        throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), new int[]{0}, (Throwable)sqle);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                this.executeQueryEpilog(exception);
                boolean bl = true;
                this.connection.lock.unlock();
                this.clearBatch();
                return bl;
            }
            this.executeQueryEpilog(exception);
            boolean bl = true;
            return bl;
        }
        finally {
            this.connection.lock.unlock();
            this.clearBatch();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.protocol != null && this.protocol.isConnected()) {
            try {
                this.protocol.releasePrepareStatement(this.sql, this.prepareResult.getStatementId());
            }
            catch (QueryException queryException) {
                // empty catch block
            }
        }
        super.close();
        this.isClosed = true;
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
        this.connection.pooledConnection.fireStatementClosed(this);
        this.connection = null;
        this.protocol = null;
    }

    protected int getParameterCount() {
        return this.parameterCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sql + "'");
        if (this.parameterCount > 0) {
            sb.append(", parameters : [");
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.currentParameterHolder[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.currentParameterHolder[i].toString());
                }
                if (i == this.parameterCount - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected ExecutionResult getExecutionResult() {
        return this.executionResult;
    }
}

