/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.read;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class ReadInitialConnectPacket {
    static final String MARIADB_RPL_HACK_PREFIX = "5.5.5-";
    private final byte protocolVersion;
    private final long serverThreadId;
    private final int serverCapabilities;
    private final byte serverLanguage;
    private final short serverStatus;
    private final byte[] seed;
    private String serverVersion;

    public ReadInitialConnectPacket(Buffer buffer) throws IOException, QueryException {
        if (buffer.getByteAt(0) == -1) {
            ErrorPacket errorPacket = new ErrorPacket(buffer);
            throw new QueryException(errorPacket.getMessage());
        }
        this.protocolVersion = buffer.readByte();
        this.serverVersion = buffer.readString(StandardCharsets.US_ASCII);
        this.serverThreadId = buffer.readInt();
        byte[] seed1 = buffer.readRawBytes(8);
        buffer.skipByte();
        this.serverCapabilities = buffer.readShort();
        this.serverLanguage = buffer.readByte();
        this.serverStatus = buffer.readShort();
        buffer.skipBytes(13);
        byte[] seed2 = buffer.readRawBytes(12);
        this.seed = Utils.copyWithLength(seed1, seed1.length + seed2.length);
        System.arraycopy(seed2, 0, this.seed, seed1.length, seed2.length);
        buffer.readByte();
        if ((this.serverCapabilities & 0x80000) != 0 && this.serverVersion.startsWith(MARIADB_RPL_HACK_PREFIX)) {
            this.serverVersion = this.serverVersion.substring(MARIADB_RPL_HACK_PREFIX.length());
        }
    }

    public String toString() {
        return this.protocolVersion + ":" + this.serverVersion + ":" + this.serverThreadId + ":" + new String(this.seed) + ":" + this.serverCapabilities + ":" + this.serverLanguage + ":" + this.serverStatus;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getServerThreadId() {
        return this.serverThreadId;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public byte getServerLanguage() {
        return this.serverLanguage;
    }

    public short getServerStatus() {
        return this.serverStatus;
    }
}

