/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class StringParameter
extends NotLongDataParameterHolder {
    private String string;
    private boolean noBackslashEscapes;

    public StringParameter(String string, boolean noBackslashEscapes) {
        this.string = string;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.write(os, this.string, this.noBackslashEscapes);
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return this.string.getBytes().length * 2 + 2;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeStringLength(this.string);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.VARCHAR;
    }

    @Override
    public String toString() {
        return "'" + this.string + "'";
    }
}

