/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.AbstractQueryProtocol;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MasterProtocol
extends AbstractQueryProtocol {
    public MasterProtocol(UrlParser urlParser, ReentrantLock lock) {
        super(urlParser, lock);
    }

    public static MasterProtocol getNewProtocol(FailoverProxy proxy, UrlParser urlParser) {
        MasterProtocol newProtocol = new MasterProtocol(urlParser, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    public static void loop(Listener listener, List<HostAddress> addresses, SearchFilter searchFilter) throws QueryException {
        ArrayDeque<HostAddress> loopAddresses = new ArrayDeque<HostAddress>(!addresses.isEmpty() ? addresses : listener.getBlacklistKeys());
        if (loopAddresses.isEmpty()) {
            loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
        }
        QueryException lastQueryException = null;
        for (int maxConnectionTry = listener.getRetriesAllDown(); !loopAddresses.isEmpty() || !searchFilter.isFailoverLoop() && maxConnectionTry > 0; --maxConnectionTry) {
            MasterProtocol protocol = MasterProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            if (listener.isExplicitClosed()) {
                return;
            }
            try {
                HostAddress host = loopAddresses.pollFirst();
                if (host == null) {
                    loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                    host = loopAddresses.pollFirst();
                }
                protocol.setHostAddress(host);
                protocol.connect();
                if (listener.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                listener.removeFromBlacklist(protocol.getHostAddress());
                listener.foundActiveMaster(protocol);
                return;
            }
            catch (QueryException e) {
                listener.addToBlacklist(protocol.getHostAddress());
                lastQueryException = e;
                if (!loopAddresses.isEmpty() || searchFilter.isFailoverLoop() || maxConnectionTry <= 0) continue;
                loopAddresses = new ArrayDeque<HostAddress>(listener.getBlacklistKeys());
                continue;
            }
        }
        if (lastQueryException != null) {
            throw new QueryException("No active connection found for master : " + lastQueryException.getMessage(), lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
        }
        throw new QueryException("No active connection found for master");
    }
}

