/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.MyX509TrustManager;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.RawPacket;
import org.mariadb.jdbc.internal.packet.read.ReadInitialConnectPacket;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.read.ReadResultPacketFactory;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.packet.result.EndOfFilePacket;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.result.OkPacket;
import org.mariadb.jdbc.internal.packet.result.ResultSetPacket;
import org.mariadb.jdbc.internal.packet.send.SendClosePacket;
import org.mariadb.jdbc.internal.packet.send.SendHandshakeResponsePacket;
import org.mariadb.jdbc.internal.packet.send.SendOldPasswordAuthPacket;
import org.mariadb.jdbc.internal.packet.send.SendSslConnectionRequestPacket;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.query.MariaDbQuery;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.stream.DecompressInputStream;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.PrepareStatementCache;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.buffer.ReadUtil;
import org.mariadb.jdbc.internal.util.constant.HaMode;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public abstract class AbstractConnectProtocol
implements Protocol {
    private final String username;
    private final String password;
    private boolean hostFailed;
    private String version;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private Map<String, String> serverData;
    private Calendar cal;
    protected final ReentrantLock lock;
    protected final UrlParser urlParser;
    protected Socket socket;
    protected PacketOutputStream writer;
    protected boolean readOnly = false;
    protected ReadPacketFetcher packetFetcher;
    protected HostAddress currentHost;
    protected FailoverProxy proxy;
    protected volatile boolean connected = false;
    protected boolean explicitClosed = false;
    protected String database;
    protected long serverThreadId;
    protected PrepareStatementCache prepareStatementCache;
    public boolean moreResults = false;
    public boolean hasWarnings = false;
    public StreamingSelectResult activeResult = null;
    public int dataTypeMappingFlags;
    public short serverStatus;

    public AbstractConnectProtocol(UrlParser urlParser, ReentrantLock lock) {
        this.lock = lock;
        this.urlParser = urlParser;
        this.database = urlParser.getDatabase() == null ? "" : urlParser.getDatabase();
        this.username = urlParser.getUsername() == null ? "" : urlParser.getUsername();
        String string = this.password = urlParser.getPassword() == null ? "" : urlParser.getPassword();
        if (urlParser.getOptions().cachePrepStmts) {
            this.prepareStatementCache = PrepareStatementCache.newInstance(urlParser.getOptions().prepStmtCacheSize);
        }
        this.setDataTypeMappingFlags();
    }

    private void skip() throws IOException, QueryException {
        if (this.activeResult != null) {
            this.activeResult.close();
        }
        while (this.moreResults) {
            this.getMoreResults(true);
        }
    }

    @Override
    public abstract AbstractQueryResult getMoreResults(boolean var1) throws QueryException;

    @Override
    public void close() {
        if (this.lock != null) {
            this.lock.lock();
        }
        this.connected = false;
        try {
            this.skip();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.urlParser.getOptions().cachePrepStmts) {
                this.prepareStatementCache.clear();
            }
            AbstractConnectProtocol.close(this.packetFetcher, this.writer, this.socket);
        }
        catch (Exception exception) {
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    protected static void close(ReadPacketFetcher fetcher, PacketOutputStream packetOutputStream, Socket socket) throws QueryException {
        SendClosePacket closePacket = new SendClosePacket();
        try {
            try {
                closePacket.send(packetOutputStream);
                socket.shutdownOutput();
                socket.setSoTimeout(3);
                InputStream is = socket.getInputStream();
                while (is.read() != -1) {
                }
            }
            catch (Throwable is) {
                // empty catch block
            }
            packetOutputStream.close();
            fetcher.close();
        }
        catch (IOException e) {
            throw new QueryException("Could not close connection: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private SSLSocketFactory getSslSocketFactory() throws QueryException {
        if (!this.urlParser.getOptions().trustServerCertificate && this.urlParser.getOptions().serverSslCert == null && this.urlParser.getOptions().trustCertificateKeyStoreUrl == null && this.urlParser.getOptions().clientCertificateKeyStoreUrl == null) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManager = null;
            if (this.urlParser.getOptions().trustServerCertificate || this.urlParser.getOptions().serverSslCert != null || this.urlParser.getOptions().trustCertificateKeyStoreUrl != null) {
                trustManager = new X509TrustManager[]{new MyX509TrustManager(this.urlParser.getOptions())};
            }
            KeyManager[] keyManager = null;
            String clientCertKeystoreUrl = this.urlParser.getOptions().clientCertificateKeyStoreUrl;
            if (clientCertKeystoreUrl != null && !clientCertKeystoreUrl.isEmpty()) {
                keyManager = this.loadClientCerts(clientCertKeystoreUrl, this.urlParser.getOptions().clientCertificateKeyStorePassword);
            }
            sslContext.init(keyManager, trustManager, null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new QueryException(e.getMessage(), 0, "HY000", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] loadClientCerts(String keystoreUrl, String keystorePassword) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        try (InputStream inStream = null;){
            char[] certKeystorePassword = keystorePassword == null ? null : keystorePassword.toCharArray();
            inStream = new URL(keystoreUrl).openStream();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(inStream, certKeystorePassword);
            keyManagerFactory.init(ks, certKeystorePassword);
        }
        return keyManagerFactory.getKeyManagers();
    }

    private void initializeSocketOption() {
        try {
            if (this.urlParser.getOptions().tcpNoDelay) {
                this.socket.setTcpNoDelay(this.urlParser.getOptions().tcpNoDelay);
            } else {
                this.socket.setTcpNoDelay(true);
            }
            if (this.urlParser.getOptions().tcpKeepAlive) {
                this.socket.setKeepAlive(true);
            }
            if (this.urlParser.getOptions().tcpRcvBuf != null) {
                this.socket.setReceiveBufferSize(this.urlParser.getOptions().tcpRcvBuf);
            }
            if (this.urlParser.getOptions().tcpSndBuf != null) {
                this.socket.setSendBufferSize(this.urlParser.getOptions().tcpSndBuf);
            }
            if (this.urlParser.getOptions().tcpAbortiveClose) {
                this.socket.setSoLinger(true, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void connect() throws QueryException {
        if (!this.isClosed()) {
            this.close();
        }
        try {
            this.connect(this.currentHost.host, this.currentHost.port);
            return;
        }
        catch (IOException e) {
            throw new QueryException("Could not connect to " + this.currentHost + "." + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    private void connect(String host, int port) throws QueryException, IOException {
        this.socket = Utils.createSocket(this.urlParser, host);
        this.initializeSocketOption();
        if (this.urlParser.getOptions().localSocketAddress != null) {
            InetSocketAddress localAddress = new InetSocketAddress(this.urlParser.getOptions().localSocketAddress, 0);
            this.socket.bind(localAddress);
        }
        if (!this.socket.isConnected()) {
            InetSocketAddress sockAddr = new InetSocketAddress(host, port);
            if (this.urlParser.getOptions().connectTimeout != null) {
                this.socket.connect(sockAddr, this.urlParser.getOptions().connectTimeout);
            } else {
                this.socket.connect(sockAddr);
            }
        }
        if (this.urlParser.getOptions().socketTimeout != null) {
            this.socket.setSoTimeout(this.urlParser.getOptions().socketTimeout);
        }
        this.handleConnectionPhases();
        if (this.urlParser.getOptions().useCompression) {
            this.writer.setUseCompression(true);
            this.packetFetcher = new ReadPacketFetcher(new DecompressInputStream(this.socket.getInputStream()));
        }
        this.connected = true;
        this.setSessionOptions();
        this.loadServerData();
        this.writer.setMaxAllowedPacket(Integer.parseInt(this.serverData.get("max_allowed_packet")));
        this.createDatabaseIfNotExist();
        this.loadCalendar();
        this.activeResult = null;
        this.moreResults = false;
        this.hasWarnings = false;
        this.hostFailed = false;
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private void setSessionOptions() throws QueryException {
        if ((this.serverStatus & ServerStatus.AUTOCOMMIT) == 0) {
            this.executeQuery(new MariaDbQuery("set autocommit=1"));
        }
        if (this.urlParser.getOptions().sessionVariables != null) {
            this.executeQuery(new MariaDbQuery("set session " + this.urlParser.getOptions().sessionVariables));
        }
    }

    private void handleConnectionPhases() throws QueryException {
        InputStream reader = null;
        try {
            reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
            this.packetFetcher = new ReadPacketFetcher(reader);
            this.writer = new PacketOutputStream(this.socket.getOutputStream());
            ReadInitialConnectPacket greetingPacket = new ReadInitialConnectPacket(this.packetFetcher);
            this.serverThreadId = greetingPacket.getServerThreadId();
            this.version = greetingPacket.getServerVersion();
            this.parseVersion();
            int clientCapabilities = this.initializeClientCapabilities();
            byte packetSeq = 1;
            if (this.urlParser.getOptions().useSsl && (greetingPacket.getServerCapabilities() & 0x800) != 0) {
                SendSslConnectionRequestPacket amcap = new SendSslConnectionRequestPacket(clientCapabilities |= 0x800);
                amcap.send(this.writer);
                SSLSocketFactory sslSocketFactory = this.getSslSocketFactory();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
                sslSocket.setEnabledProtocols(new String[]{"TLSv1"});
                sslSocket.setUseClientMode(true);
                sslSocket.startHandshake();
                this.socket = sslSocket;
                this.writer = new PacketOutputStream(this.socket.getOutputStream());
                reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
                this.packetFetcher = new ReadPacketFetcher(reader);
                packetSeq = (byte)(packetSeq + 1);
            } else if (this.urlParser.getOptions().useSsl) {
                throw new QueryException("Trying to connect with ssl, but ssl not enabled in the server");
            }
            this.authentication(greetingPacket.getServerLanguage(), clientCapabilities, greetingPacket.getSeed(), packetSeq);
        }
        catch (IOException e) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new QueryException("Could not connect to " + this.currentHost.host + ":" + this.currentHost.port + ": " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    private void authentication(byte serverLanguage, int clientCapabilities, byte[] seed, byte packetSeq) throws QueryException, IOException {
        AbstractResultPacket resultPacket;
        SendHandshakeResponsePacket cap = new SendHandshakeResponsePacket(this.username, this.password, this.database, clientCapabilities, this.decideLanguage(serverLanguage), seed, packetSeq);
        cap.send(this.writer);
        RawPacket rp = this.packetFetcher.getRawPacket();
        if ((rp.getByteBuffer().get(0) & 0xFF) == 254) {
            SendOldPasswordAuthPacket oldPassPacket = new SendOldPasswordAuthPacket(this.password, Utils.copyWithLength(seed, 8), rp.getPacketSeq() + 1);
            oldPassPacket.send(this.writer);
            rp = this.packetFetcher.getRawPacket();
        }
        if ((resultPacket = ReadResultPacketFactory.createResultPacket(rp.getByteBuffer())).getResultType() == AbstractResultPacket.ResultType.ERROR) {
            ErrorPacket errorPacket = (ErrorPacket)resultPacket;
            throw new QueryException("Could not connect: " + errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
        }
        this.serverStatus = ((OkPacket)resultPacket).getServerStatus();
    }

    private int initializeClientCapabilities() {
        int capabilities = 172931;
        if (this.urlParser.getOptions().allowMultiQueries || this.urlParser.getOptions().rewriteBatchedStatements) {
            capabilities |= 0x10000;
        }
        if (this.urlParser.getOptions().useCompression) {
            capabilities |= 0x20;
        }
        if (this.urlParser.getOptions().interactiveClient) {
            capabilities |= 0x400;
        }
        if (this.database != null && !this.urlParser.getOptions().createDatabaseIfNotExist) {
            capabilities |= 8;
        }
        return capabilities;
    }

    private void createDatabaseIfNotExist() throws QueryException {
        if (this.checkIfMaster() && this.urlParser.getOptions().createDatabaseIfNotExist) {
            String quotedDb = MariaDbConnection.quoteIdentifier(this.database);
            this.executeQuery(new MariaDbQuery("CREATE DATABASE IF NOT EXISTS " + quotedDb));
            this.executeQuery(new MariaDbQuery("USE " + quotedDb));
        }
    }

    private void loadCalendar() throws QueryException {
        block6: {
            String timeZone = null;
            if (this.urlParser.getOptions().serverTimezone != null) {
                timeZone = this.urlParser.getOptions().serverTimezone;
            }
            if (timeZone == null && "SYSTEM".equals(timeZone = this.getServerData("time_zone"))) {
                timeZone = this.getServerData("system_time_zone");
            }
            if (timeZone != null && timeZone.length() >= 2 && (timeZone.startsWith("+") || timeZone.startsWith("-")) && Character.isDigit(timeZone.charAt(1))) {
                timeZone = "GMT" + timeZone;
            }
            try {
                TimeZone tz = Utils.getTimeZone(timeZone);
                this.cal = Calendar.getInstance(tz);
            }
            catch (SQLException e) {
                this.cal = null;
                if (this.urlParser.getOptions().useLegacyDatetimeCode) break block6;
                if (this.urlParser.getOptions().serverTimezone != null) {
                    throw new QueryException("The server time_zone '" + timeZone + "' defined in the 'serverTimezone' parameter cannot be parsed " + "by java TimeZone implementation. See java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your " + "JRE implementation.", 0, "01S00");
                }
                throw new QueryException("The server time_zone '" + timeZone + "' cannot be parsed. The server time zone must defined in the " + "jdbc url string with the 'serverTimezone' parameter (or server time zone must be defined explicitly).  See " + "java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your JRE implementation.", 0, "01S00");
            }
        }
    }

    private void loadServerData() throws QueryException, IOException {
        this.serverData = new TreeMap<String, String>();
        try (AbstractQueryResult qr = null;){
            qr = this.executeSingleInternalQuery(new MariaDbQuery("SELECT @@max_allowed_packet, @@system_time_zone, @@time_zone"));
            if (((SelectQueryResult)qr).next()) {
                this.serverData.put("max_allowed_packet", ((SelectQueryResult)qr).getValueObject(0).getString());
                this.serverData.put("system_time_zone", ((SelectQueryResult)qr).getValueObject(1).getString());
                this.serverData.put("time_zone", ((SelectQueryResult)qr).getValueObject(2).getString());
            }
        }
    }

    @Override
    public String getServerData(String code) {
        return this.serverData.get(code);
    }

    @Override
    public boolean checkIfMaster() throws QueryException {
        return this.isMasterConnection();
    }

    private boolean isServerLanguageUtf8mb4(byte serverLanguage) {
        Byte[] utf8mb4Languages = new Byte[]{(byte)45, (byte)46, (byte)-32, (byte)-31, (byte)-30, (byte)-29, (byte)-28, (byte)-27, (byte)-26, (byte)-25, (byte)-24, (byte)-23, (byte)-22, (byte)-21, (byte)-20, (byte)-19, (byte)-18, (byte)-17, (byte)-16, (byte)-15, (byte)-14, (byte)-13, (byte)-11};
        return Arrays.asList(utf8mb4Languages).contains(serverLanguage);
    }

    private byte decideLanguage(byte serverLanguage) {
        byte result = this.isServerLanguageUtf8mb4(serverLanguage) ? serverLanguage : (byte)(this.versionGreaterOrEqual(5, 5, 3) ? 45 : 33);
        return result;
    }

    public void readEofPacket() throws QueryException, IOException {
        AbstractResultPacket resultPacket = ReadResultPacketFactory.createResultPacket(this.packetFetcher);
        switch (resultPacket.getResultType()) {
            case EOF: {
                EndOfFilePacket eof = (EndOfFilePacket)resultPacket;
                this.hasWarnings = eof.getWarningCount() > 0;
                this.serverStatus = eof.getStatusFlags();
                break;
            }
            case ERROR: {
                ErrorPacket ep = (ErrorPacket)resultPacket;
                throw new QueryException("Could not connect: " + ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            default: {
                throw new QueryException("Unexpected stream type " + (Object)((Object)resultPacket.getResultType()) + "insted of EOF");
            }
        }
    }

    @Override
    public void setHostFailedWithoutProxy() {
        this.hostFailed = true;
        this.close();
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public boolean isMasterConnection() {
        return "master".equals(this.currentHost.type);
    }

    @Override
    public boolean mustBeMasterConnection() {
        return true;
    }

    @Override
    public boolean noBackslashEscapes() {
        return (this.serverStatus & ServerStatus.NO_BACKSLASH_ESCAPES) != 0;
    }

    @Override
    public void connectWithoutProxy() throws QueryException {
        if (!this.isClosed()) {
            this.close();
        }
        Random rand = new Random();
        List<HostAddress> addrs = this.urlParser.getHostAddresses();
        LinkedList<HostAddress> hosts = new LinkedList<HostAddress>(addrs);
        while (!hosts.isEmpty()) {
            this.currentHost = this.urlParser.getHaMode().equals((Object)HaMode.LOADBALANCE) ? (HostAddress)hosts.get(rand.nextInt(hosts.size())) : (HostAddress)hosts.get(0);
            hosts.remove(this.currentHost);
            try {
                this.connect(this.currentHost.host, this.currentHost.port);
                return;
            }
            catch (IOException e) {
                if (!hosts.isEmpty()) continue;
                throw new QueryException("Could not connect to " + HostAddress.toString(addrs) + " : " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
    }

    @Override
    public boolean shouldReconnectWithoutProxy() {
        return (this.serverStatus & ServerStatus.IN_TRANSACTION) == 0 && this.hostFailed && this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public String getServerVersion() {
        return this.version;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.currentHost;
    }

    @Override
    public void setHostAddress(HostAddress host) {
        this.currentHost = host;
        this.readOnly = "slave".equals(this.currentHost.type);
    }

    @Override
    public String getHost() {
        return this.currentHost.host;
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public int getPort() {
        return this.currentHost.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    private SelectQueryResult executeSingleInternalQuery(Query query) throws QueryException {
        try {
            this.writer.startPacket(0);
            this.writer.write(3);
            query.writeTo(this.writer);
            this.writer.finishPacket();
            ResultSetPacket resultSetPacket = (ResultSetPacket)ReadResultPacketFactory.createResultPacket(this.packetFetcher);
            try {
                long fieldCount = resultSetPacket.getFieldCount();
                ColumnInformation[] ci = new ColumnInformation[(int)fieldCount];
                int i = 0;
                while ((long)i < fieldCount) {
                    this.packetFetcher.skipNextPacket();
                    ci[i] = new ColumnInformation(MariaDbType.STRING);
                    ++i;
                }
                ByteBuffer bufferEof = this.packetFetcher.getReusableBuffer();
                if (!ReadUtil.eofIsNext(bufferEof)) {
                    throw new QueryException("Packets out of order when reading field packets, expected was EOF stream. Packet contents (hex) = " + MasterProtocol.hexdump(bufferEof, 0));
                }
                return new StreamingSelectResult(ci, this, this.packetFetcher, false);
            }
            catch (IOException e) {
                throw new QueryException("Could not read result set: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    private void parseVersion() {
        String[] versionArray = this.version.split("[^0-9]");
        if (versionArray.length > 0) {
            this.majorVersion = Integer.parseInt(versionArray[0]);
        }
        if (versionArray.length > 1) {
            this.minorVersion = Integer.parseInt(versionArray[1]);
        }
        if (versionArray.length > 2) {
            this.patchVersion = Integer.parseInt(versionArray[2]);
        }
    }

    @Override
    public int getMajorServerVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorServerVersion() {
        return this.minorVersion;
    }

    @Override
    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        if (this.majorVersion > major) {
            return true;
        }
        if (this.majorVersion < major) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        if (this.patchVersion > patch) {
            return true;
        }
        return this.patchVersion >= patch;
    }

    @Override
    public boolean getPinGlobalTxToPhysicalConnection() {
        return this.urlParser.getOptions().pinGlobalTxToPhysicalConnection;
    }

    @Override
    public boolean hasWarnings() {
        this.lock.lock();
        try {
            boolean bl = this.hasWarnings;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.lock.lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setDataTypeMappingFlags() {
        this.dataTypeMappingFlags = 0;
        if (this.urlParser.getOptions().tinyInt1isBit) {
            this.dataTypeMappingFlags |= 1;
        }
        if (this.urlParser.getOptions().yearIsDateType) {
            this.dataTypeMappingFlags |= 2;
        }
    }

    @Override
    public long getServerThreadId() {
        return this.serverThreadId;
    }

    @Override
    public int getDataTypeMappingFlags() {
        return this.dataTypeMappingFlags;
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed;
    }

    @Override
    public Calendar getCalendar() {
        return this.cal;
    }

    @Override
    public Options getOptions() {
        return this.urlParser.getOptions();
    }

    @Override
    public abstract AbstractQueryResult executeQuery(Query var1) throws QueryException;
}

