/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.read.ReadResultPacketFactory;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.buffer.ReadUtil;
import org.mariadb.jdbc.internal.util.buffer.Reader;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class ReadInitialConnectPacket {
    static final String MARIADB_RPL_HACK_PREFIX = "5.5.5-";
    private final byte protocolVersion;
    private final long serverThreadId;
    private final int serverCapabilities;
    private final byte serverLanguage;
    private final short serverStatus;
    private final byte[] seed;
    private String serverVersion;

    public ReadInitialConnectPacket(ReadPacketFetcher packetFetcher) throws IOException, QueryException {
        ByteBuffer byteBuffer = packetFetcher.getReusableBuffer();
        if (ReadUtil.isErrorPacket(byteBuffer)) {
            ErrorPacket errorPacket = (ErrorPacket)ReadResultPacketFactory.createResultPacket(byteBuffer);
            throw new QueryException(errorPacket.getMessage());
        }
        Reader reader = new Reader(byteBuffer);
        this.protocolVersion = reader.readByte();
        this.serverVersion = reader.readString(StandardCharsets.US_ASCII);
        this.serverThreadId = reader.readInt();
        byte[] seed1 = reader.readRawBytes(8);
        reader.skipByte();
        this.serverCapabilities = reader.readShort();
        this.serverLanguage = reader.readByte();
        this.serverStatus = reader.readShort();
        reader.skipBytes(13);
        byte[] seed2 = reader.readRawBytes(12);
        this.seed = Utils.copyWithLength(seed1, seed1.length + seed2.length);
        System.arraycopy(seed2, 0, this.seed, seed1.length, seed2.length);
        reader.readByte();
        if ((this.serverCapabilities & 0x80000) != 0 && this.serverVersion.startsWith(MARIADB_RPL_HACK_PREFIX)) {
            this.serverVersion = this.serverVersion.substring(MARIADB_RPL_HACK_PREFIX.length());
        }
    }

    public String toString() {
        return this.protocolVersion + ":" + this.serverVersion + ":" + this.serverThreadId + ":" + new String(this.seed) + ":" + this.serverCapabilities + ":" + this.serverLanguage + ":" + this.serverStatus;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getServerThreadId() {
        return this.serverThreadId;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public byte getServerLanguage() {
        return this.serverLanguage;
    }

    public short getServerStatus() {
        return this.serverStatus;
    }
}

