/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.AbstractMastersSlavesListener;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MastersSlavesListener
extends AbstractMastersSlavesListener {
    protected Protocol masterProtocol = null;
    protected Protocol secondaryProtocol = null;
    protected long lastQueryTime = System.currentTimeMillis();
    protected ScheduledFuture scheduledPing = null;

    public MastersSlavesListener(UrlParser urlParser) {
        super(urlParser);
    }

    @Override
    public void initializeConnection() throws QueryException {
        if (this.urlParser.getOptions().validConnectionTimeout != 0) {
            this.scheduledPing = this.executorService.scheduleWithFixedDelay(new PingLoop(this), this.urlParser.getOptions().validConnectionTimeout, this.urlParser.getOptions().validConnectionTimeout, TimeUnit.SECONDS);
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true, true));
        }
        catch (QueryException e) {
            this.checkInitialConnection();
            this.throwFailoverMessage(e, false);
        }
    }

    protected void checkInitialConnection() {
        if (this.masterProtocol != null && !this.masterProtocol.isConnected()) {
            this.setMasterHostFail();
        }
        if (this.secondaryProtocol != null && !this.secondaryProtocol.isConnected()) {
            this.setSecondaryHostFail();
        }
        this.launchFailLoopIfNotlaunched(false);
    }

    @Override
    public void preClose() throws SQLException {
        if (!this.isExplicitClosed()) {
            this.proxy.lock.lock();
            try {
                this.setExplicitClosed(true);
                if (this.scheduledPing != null) {
                    this.scheduledPing.cancel(true);
                }
                if (this.scheduledFailover != null) {
                    this.scheduledFailover.cancel(true);
                    this.isLooping.set(false);
                }
                this.executorService.shutdownNow();
                try {
                    this.executorService.awaitTermination(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.masterProtocol != null && this.masterProtocol.isConnected()) {
                    this.masterProtocol.close();
                }
                if (this.secondaryProtocol != null && this.secondaryProtocol.isConnected()) {
                    this.secondaryProtocol.close();
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void preExecute() throws QueryException {
        if (this.currentProtocol != null && (this.currentProtocol.isClosed() || !this.currentReadOnlyAsked.get() && !this.currentProtocol.isMasterConnection())) {
            this.queriesSinceFailover.incrementAndGet();
            if (!this.isExplicitClosed() && this.urlParser.getOptions().autoReconnect) {
                try {
                    this.reconnectFailedConnection(new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail(), !this.currentReadOnlyAsked.get(), this.currentReadOnlyAsked.get()));
                }
                catch (QueryException queryException) {}
            } else {
                throw new QueryException("Connection is closed", -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState());
            }
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            this.queriesSinceFailover.incrementAndGet();
        }
        if (this.urlParser.getOptions().validConnectionTimeout != 0) {
            this.lastQueryTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean shouldReconnect() {
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            if (this.currentConnectionAttempts.get() > this.urlParser.getOptions().retriesAllDown) {
                return false;
            }
            long now = System.currentTimeMillis();
            if (this.isMasterHostFail()) {
                if (this.urlParser.getOptions().queriesBeforeRetryMaster > 0 && this.queriesSinceFailover.get() >= this.urlParser.getOptions().queriesBeforeRetryMaster) {
                    return true;
                }
                if (this.urlParser.getOptions().secondsBeforeRetryMaster > 0 && now - this.getMasterHostFailTimestamp() >= (long)(this.urlParser.getOptions().secondsBeforeRetryMaster * 1000)) {
                    return true;
                }
            }
            if (this.isSecondaryHostFail() && now - this.getSecondaryHostFailTimestamp() >= 2000L) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
        loopAddress.removeAll(blacklist.keySet());
        Collections.shuffle(loopAddress);
        LinkedList blacklistShuffle = new LinkedList(blacklist.keySet());
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
        }
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            loopAddress.remove(this.secondaryProtocol.getHostAddress());
        }
        if (searchFilter.isSearchForMaster() && this.isMasterHostFail() || searchFilter.isSearchForSlave() && this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            MastersSlavesProtocol.loop(this, loopAddress, (Map<HostAddress, Long>)blacklist, searchFilter);
        }
    }

    @Override
    public void foundActiveMaster(Protocol newMasterProtocol) {
        if (this.isExplicitClosed()) {
            newMasterProtocol.close();
            return;
        }
        this.proxy.lock.lock();
        try {
            if (this.masterProtocol != null && !this.masterProtocol.isClosed()) {
                this.masterProtocol.close();
            }
            this.masterProtocol = (MastersSlavesProtocol)newMasterProtocol;
            if (!this.currentReadOnlyAsked.get() || this.isSecondaryHostFail()) {
                try {
                    this.syncConnection(this.currentProtocol, this.masterProtocol);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currentProtocol = this.masterProtocol;
            }
            this.resetMasterFailoverData();
            if (!this.isSecondaryHostFail()) {
                this.stopFailover();
            }
        }
        finally {
            this.proxy.lock.unlock();
        }
    }

    @Override
    public void foundActiveSecondary(Protocol newSecondaryProtocol) throws QueryException {
        if (this.isExplicitClosed()) {
            newSecondaryProtocol.close();
            return;
        }
        this.proxy.lock.lock();
        try {
            if (this.secondaryProtocol != null && !this.secondaryProtocol.isClosed()) {
                this.secondaryProtocol.close();
            }
            this.secondaryProtocol = newSecondaryProtocol;
            if (this.currentReadOnlyAsked.get() || this.urlParser.getOptions().failOnReadOnly && !this.currentReadOnlyAsked.get() && this.isMasterHostFail()) {
                try {
                    this.syncConnection(this.currentProtocol, this.secondaryProtocol);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currentProtocol = this.secondaryProtocol;
            }
            if (this.urlParser.getOptions().assureReadOnly) {
                this.setSessionReadOnly(true, this.secondaryProtocol);
            }
            this.resetSecondaryFailoverData();
            if (!this.isMasterHostFail()) {
                this.stopFailover();
            }
        }
        finally {
            this.proxy.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws QueryException {
        if (mustBeReadOnly.booleanValue() != this.currentReadOnlyAsked.get() && this.currentProtocol.inTransaction()) {
            throw new QueryException("Trying to set to read-only mode during a transaction");
        }
        if (this.currentReadOnlyAsked.compareAndSet(mustBeReadOnly == false, mustBeReadOnly)) {
            if (this.currentReadOnlyAsked.get()) {
                if (this.currentProtocol.isMasterConnection()) {
                    if (!this.isSecondaryHostFail()) {
                        this.proxy.lock.lock();
                        try {
                            this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                            this.currentProtocol = this.secondaryProtocol;
                            return;
                        }
                        catch (QueryException e) {
                            if (this.setSecondaryHostFail()) {
                                this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                            }
                        }
                        finally {
                            this.proxy.lock.unlock();
                        }
                    }
                    this.launchFailLoopIfNotlaunched(false);
                    this.throwFailoverMessage(new QueryException("master " + this.masterProtocol.getHostAddress() + " connection failed"), false);
                }
            } else if (!this.currentProtocol.isMasterConnection()) {
                if (!this.isMasterHostFail()) {
                    this.proxy.lock.lock();
                    try {
                        this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                        return;
                    }
                    catch (QueryException e) {
                        if (this.setMasterHostFail()) {
                            this.addToBlacklist(this.masterProtocol.getHostAddress());
                        }
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                }
                if (this.urlParser.getOptions().autoReconnect) {
                    this.reconnectFailedConnection(new SearchFilter(false, true, false, true));
                    this.proxy.lock.lock();
                    try {
                        this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    return;
                }
                this.launchFailLoopIfNotlaunched(false);
                this.throwFailoverMessage(new QueryException("master " + this.masterProtocol.getHostAddress() + " connection failed"), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args) throws Throwable {
        boolean alreadyClosed;
        block17: {
            boolean bl = alreadyClosed = !this.masterProtocol.isConnected();
            if (this.tryPingOnMaster()) {
                return new HandleErrorResult(true);
            }
            if (this.urlParser.getOptions().failOnReadOnly && !this.isSecondaryHostFail()) {
                try {
                    if (this.secondaryProtocol == null || !this.secondaryProtocol.ping()) break block17;
                    this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                    this.proxy.lock.lock();
                    try {
                        this.currentProtocol = this.secondaryProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    this.launchFailLoopIfNotlaunched(false);
                    try {
                        return this.relaunchOperation(method, args);
                    }
                    catch (Exception exception) {
                        return new HandleErrorResult();
                    }
                }
                catch (Exception e) {
                    if (this.setSecondaryHostFail()) {
                        this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                    }
                    if (!this.secondaryProtocol.isConnected()) break block17;
                    this.proxy.lock.lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, this.urlParser.getOptions().failOnReadOnly, true, this.urlParser.getOptions().failOnReadOnly));
            if (this.isMasterHostFail()) {
                this.launchFailLoopIfNotlaunched(true);
            }
            if (alreadyClosed) {
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            this.launchFailLoopIfNotlaunched(true);
            return new HandleErrorResult();
        }
    }

    @Override
    public void reconnect() throws QueryException {
        SearchFilter filter = this.currentReadOnlyAsked.get() ? new SearchFilter(true, true, true, true) : new SearchFilter(true, this.urlParser.getOptions().failOnReadOnly, true, this.urlParser.getOptions().failOnReadOnly);
        this.reconnectFailedConnection(filter);
    }

    private boolean tryPingOnMaster() {
        block8: {
            try {
                if (this.masterProtocol != null && this.masterProtocol.isConnected() && this.masterProtocol.ping()) {
                    if (this.masterProtocol.inTransaction()) {
                        this.masterProtocol.rollback();
                    }
                    return true;
                }
            }
            catch (QueryException e) {
                this.proxy.lock.lock();
                try {
                    this.masterProtocol.close();
                }
                finally {
                    this.proxy.lock.unlock();
                }
                if (!this.setMasterHostFail()) break block8;
                this.addToBlacklist(this.masterProtocol.getHostAddress());
            }
        }
        return false;
    }

    private boolean tryPingOnSecondary() {
        block7: {
            try {
                if (this.secondaryProtocol != null && this.secondaryProtocol.isConnected() && this.secondaryProtocol.ping()) {
                    return true;
                }
            }
            catch (Exception e) {
                this.proxy.lock.lock();
                try {
                    this.secondaryProtocol.close();
                }
                finally {
                    this.proxy.lock.unlock();
                }
                if (!this.setSecondaryHostFail()) break block7;
                this.addToBlacklist(this.secondaryProtocol.getHostAddress());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult secondaryFail(Method method, Object[] args) throws Throwable {
        block16: {
            if (this.tryPingOnSecondary()) {
                return this.relaunchOperation(method, args);
            }
            if (!this.isMasterHostFail()) {
                try {
                    if (this.masterProtocol == null) break block16;
                    this.masterProtocol.ping();
                    this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                    this.proxy.lock.lock();
                    try {
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    this.launchFailLoopIfNotlaunched(true);
                    return this.relaunchOperation(method, args);
                }
                catch (Exception e) {
                    if (!this.setMasterHostFail()) break block16;
                    this.addToBlacklist(this.masterProtocol.getHostAddress());
                    if (!this.masterProtocol.isConnected()) break block16;
                    this.proxy.lock.lock();
                    try {
                        this.masterProtocol.close();
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true, true, true));
            if (this.isSecondaryHostFail()) {
                this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                this.proxy.lock.lock();
                try {
                    this.currentProtocol = this.masterProtocol;
                }
                finally {
                    this.proxy.lock.unlock();
                }
            }
            return this.relaunchOperation(method, args);
        }
        catch (Exception ee) {
            this.launchFailLoopIfNotlaunched(false);
            return new HandleErrorResult();
        }
    }

    public void checkMasterStatus(SearchFilter searchFilter) throws QueryException {
        if (this.masterProtocol != null) {
            this.masterProtocol.ping();
        }
    }

    @Override
    public void throwFailoverMessage(QueryException queryException, boolean reconnected) throws QueryException {
        HostAddress hostAddress;
        boolean connectionTypeMaster = true;
        HostAddress hostAddress2 = hostAddress = this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null;
        if (this.currentReadOnlyAsked.get()) {
            connectionTypeMaster = false;
            hostAddress = this.secondaryProtocol != null ? this.secondaryProtocol.getHostAddress() : null;
        }
        String firstPart = "Communications link failure with " + (connectionTypeMaster ? "primary" : "secondary") + (hostAddress != null ? " host " + hostAddress.host + ":" + hostAddress.port : "") + ". ";
        String error = "";
        error = this.urlParser.getOptions().autoReconnect || !this.isMasterHostFail() && !this.isSecondaryHostFail() ? (connectionTypeMaster && this.isMasterHostFail() || !connectionTypeMaster && this.isSecondaryHostFail() ? error + "  Driver will reconnect automatically in a few millisecond or during next query if append before" : error + " Driver as successfully reconnect connection") : (reconnected ? error + " Driver as reconnect connection" : (this.currentConnectionAttempts.get() > this.urlParser.getOptions().retriesAllDown ? error + " Driver will not try to reconnect (too much failure > " + this.urlParser.getOptions().retriesAllDown + ")" : (this.shouldReconnect() ? error + " Driver will try to reconnect automatically in a few millisecond or during next query if append before" : error + this.addErrorMessageNotReconnected(connectionTypeMaster))));
        if (queryException == null) {
            throw new QueryException(firstPart + error, -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState());
        }
        error = queryException.getMessage() + ". " + error;
        queryException.setMessage(firstPart + error);
        throw queryException;
    }

    private String addErrorMessageNotReconnected(boolean connectionTypeMaster) {
        long longestFail = this.isMasterHostFail() ? (this.isSecondaryHostFail() ? Math.min(this.getMasterHostFailTimestamp(), this.getSecondaryHostFailTimestamp()) : this.getMasterHostFailTimestamp()) : this.getSecondaryHostFailTimestamp();
        long nextReconnectionTime = (long)(this.urlParser.getOptions().secondsBeforeRetryMaster * 1000) - (System.currentTimeMillis() - longestFail);
        if (this.urlParser.getOptions().secondsBeforeRetryMaster > 0) {
            if (this.urlParser.getOptions().queriesBeforeRetryMaster > 0) {
                return " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + nextReconnectionTime + " milliseconds or after " + (this.urlParser.getOptions().queriesBeforeRetryMaster - this.queriesSinceFailover.get()) + " query(s)";
            }
            return " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + nextReconnectionTime + " milliseconds";
        }
        if (this.urlParser.getOptions().queriesBeforeRetryMaster > 0) {
            return " Driver will try to reconnect " + (connectionTypeMaster ? "primary" : "secondary") + " after " + (this.urlParser.getOptions().queriesBeforeRetryMaster - this.queriesSinceFailover.get()) + " query(s)";
        }
        return " Driver will not try to reconnect automatically";
    }

    protected class PingLoop
    implements Runnable {
        MastersSlavesListener listener;

        public PingLoop(MastersSlavesListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            if (MastersSlavesListener.this.explicitClosed) {
                if (MastersSlavesListener.this.scheduledPing != null) {
                    MastersSlavesListener.this.scheduledPing.cancel(false);
                }
            } else if (MastersSlavesListener.this.lastQueryTime + (long)(MastersSlavesListener.this.urlParser.getOptions().validConnectionTimeout * 1000) < System.currentTimeMillis() && !MastersSlavesListener.this.isMasterHostFail()) {
                boolean masterFail = false;
                try {
                    if (MastersSlavesListener.this.masterProtocol != null && MastersSlavesListener.this.masterProtocol.isConnected()) {
                        MastersSlavesListener.this.checkMasterStatus(null);
                    } else {
                        masterFail = true;
                    }
                }
                catch (QueryException e) {
                    masterFail = true;
                }
                if (masterFail && MastersSlavesListener.this.setMasterHostFail()) {
                    try {
                        this.listener.primaryFail(null, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

