/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbQuery
implements Query {
    private final byte[] queryToSend;

    public MariaDbQuery(String query) {
        try {
            this.queryToSend = query.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.queryToSend, 0, this.queryToSend.length);
    }

    public void writeTo(OutputStream ostream, int offset, int packLength) throws IOException {
        ostream.write(this.queryToSend, offset, packLength);
    }

    @Override
    public void writeFirstRewritePart(OutputStream os) throws IOException {
        this.writeTo(os);
    }

    @Override
    public void writeLastRewritePart(OutputStream os) throws IOException {
    }

    @Override
    public int writeLastRewritePartLength() {
        return 0;
    }

    @Override
    public void writeToRewritablePart(OutputStream os, int rewriteOffset) throws IOException {
        try {
            os.write(44);
            os.write(this.queryToSend, rewriteOffset, this.queryToSend.length - rewriteOffset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    @Override
    public int writeToRewritablePartLength(int rewriteOffset) {
        return 1 + this.queryToSend.length - rewriteOffset;
    }

    @Override
    public int getQuerySize() {
        return this.queryToSend.length;
    }

    public boolean equals(Object otherObj) {
        return otherObj instanceof MariaDbQuery && ((MariaDbQuery)otherObj).queryToSend.equals(this.queryToSend);
    }

    @Override
    public void validate() throws QueryException {
    }

    public String toString() {
        return new String(this.queryToSend);
    }
}

