/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.queryresults.ValueObject;
import org.mariadb.jdbc.internal.util.Options;

public class MariaDbValueObject
implements ValueObject {
    private final byte[] rawBytes;
    private final MariaDbType dataType;
    private final boolean isBinaryEncoded;
    private final ColumnInformation columnInfo;
    private final Options options;

    public MariaDbValueObject(byte[] rawBytes, ColumnInformation columnInfo, Options options) {
        this.dataType = columnInfo.getType();
        this.rawBytes = rawBytes;
        this.isBinaryEncoded = false;
        this.columnInfo = columnInfo;
        this.options = options;
    }

    public MariaDbValueObject(byte[] rawBytes, ColumnInformation columnInfo, boolean isBinaryEncoded, Options options) {
        this.dataType = columnInfo.getType();
        this.rawBytes = rawBytes;
        this.isBinaryEncoded = isBinaryEncoded;
        this.columnInfo = columnInfo;
        this.options = options;
    }

    @Override
    public String getString() {
        return this.getString(null);
    }

    @Override
    public String getString(Calendar cal) {
        if (this.rawBytes == null) {
            return null;
        }
        switch (this.columnInfo.getType()) {
            case BIT: {
                if (this.columnInfo.getLength() != 1L) break;
                return this.rawBytes[0] == 0 ? "0" : "1";
            }
            case TIME: {
                return this.getTimeString();
            }
            case DATE: {
                if (!this.isBinaryEncoded) break;
                try {
                    return this.getDate(cal).toString();
                }
                catch (ParseException parseException) {
                    break;
                }
            }
            case TIMESTAMP: 
            case DATETIME: {
                if (!this.isBinaryEncoded) break;
                try {
                    return this.getTimestamp(cal).toString();
                }
                catch (ParseException parseException) {
                    break;
                }
            }
        }
        return new String(this.rawBytes, StandardCharsets.UTF_8);
    }

    private String getTimeString() {
        if (this.rawBytes == null || this.rawBytes.length == 0) {
            return null;
        }
        String rawValue = new String(this.rawBytes, StandardCharsets.UTF_8);
        if ("0000-00-00".equals(rawValue)) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            if (!this.options.useLegacyDatetimeCode && rawValue.indexOf(".") > 0) {
                return rawValue.substring(0, rawValue.indexOf("."));
            }
            return rawValue;
        }
        byte hour = this.rawBytes[5];
        int day = this.rawBytes[1] & 0xFF | (this.rawBytes[2] & 0xFF) << 8 | (this.rawBytes[3] & 0xFF) << 16 | (this.rawBytes[4] & 0xFF) << 24;
        int timeHour = hour + day * 24;
        String hourString = timeHour < 10 ? "0" + timeHour : Integer.toString(timeHour);
        byte minutes = this.rawBytes[6];
        String minuteString = minutes < 10 ? "0" + minutes : Integer.toString(minutes);
        byte seconds = this.rawBytes[7];
        String secondString = seconds < 10 ? "0" + seconds : Integer.toString(seconds);
        int microseconds = 0;
        if (this.rawBytes.length > 8) {
            microseconds = this.rawBytes[8] & 0xFF | (this.rawBytes[9] & 0xFF) << 8 | (this.rawBytes[10] & 0xFF) << 16 | (this.rawBytes[11] & 0xFF) << 24;
        }
        String microsecondString = Integer.toString(microseconds);
        while (microsecondString.length() < 6) {
            microsecondString = "0" + microsecondString;
        }
        boolean negative = this.rawBytes[0] == 1;
        return (negative ? "-" : "") + hourString + ":" + minuteString + ":" + secondString;
    }

    @Override
    public byte getByte() {
        if (this.rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            if (this.dataType == MariaDbType.BIT) {
                return this.rawBytes[0];
            }
            try {
                return Byte.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
            }
            catch (NumberFormatException nfe) {
                BigDecimal value = new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
                if (value.compareTo(BigDecimal.valueOf(-128L)) < 0) {
                    return -128;
                }
                if (value.compareTo(BigDecimal.valueOf(127L)) > 0) {
                    return 127;
                }
                return value.byteValue();
            }
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                if (this.columnInfo.isSigned()) {
                    return this.rawBytes[0];
                }
                return (byte)(this.rawBytes[0] & 0xFF);
            }
            case SMALLINT: 
            case YEAR: {
                return (byte)this.getShort();
            }
            case INTEGER: 
            case MEDIUMINT: {
                return (byte)this.getInt();
            }
            case BIGINT: {
                return (byte)this.getLong();
            }
            case FLOAT: {
                return (byte)this.getFloat();
            }
            case DOUBLE: {
                return (byte)this.getDouble();
            }
        }
        try {
            return Byte.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            BigDecimal value = new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
            if (value.compareTo(BigDecimal.valueOf(-128L)) < 0) {
                return -128;
            }
            if (value.compareTo(BigDecimal.valueOf(127L)) > 0) {
                return 127;
            }
            return value.byteValue();
        }
    }

    @Override
    public short getShort() {
        if (this.rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            try {
                return Short.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
            }
            catch (NumberFormatException nfe) {
                BigDecimal value = new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
                if (value.compareTo(BigDecimal.valueOf(-32768L)) < 0) {
                    return Short.MIN_VALUE;
                }
                if (value.compareTo(BigDecimal.valueOf(32767L)) > 0) {
                    return Short.MAX_VALUE;
                }
                return value.shortValue();
            }
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                return this.getByte();
            }
            case SMALLINT: 
            case YEAR: {
                short value = (short)(this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8);
                if (this.columnInfo.isSigned()) {
                    return value;
                }
                return (short)(value & 0xFFFF);
            }
            case INTEGER: 
            case MEDIUMINT: {
                return (short)this.getInt();
            }
            case BIGINT: {
                return (short)this.getLong();
            }
            case FLOAT: {
                return (short)this.getFloat();
            }
            case DOUBLE: {
                return (short)this.getDouble();
            }
        }
        try {
            return Short.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            BigDecimal bigdecimal = new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
            if (bigdecimal.compareTo(BigDecimal.valueOf(-32768L)) < 0) {
                return Short.MIN_VALUE;
            }
            if (bigdecimal.compareTo(BigDecimal.valueOf(32767L)) > 0) {
                return Short.MAX_VALUE;
            }
            return bigdecimal.shortValue();
        }
    }

    @Override
    public int getInt() {
        if (this.rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            try {
                return Integer.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
            }
            catch (NumberFormatException nfe) {
                BigDecimal value = new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
                if (value.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) < 0) {
                    return Integer.MIN_VALUE;
                }
                if (value.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0) {
                    return Integer.MAX_VALUE;
                }
                return value.intValue();
            }
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                return this.getByte();
            }
            case SMALLINT: 
            case YEAR: {
                return this.getShort();
            }
            case INTEGER: 
            case MEDIUMINT: {
                int value = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8 | (this.rawBytes[2] & 0xFF) << 16 | (this.rawBytes[3] & 0xFF) << 24;
                if (this.columnInfo.isSigned()) {
                    return value;
                }
                return value & 0xFFFFFFFF;
            }
            case BIGINT: {
                return (int)this.getLong();
            }
            case FLOAT: {
                return (int)this.getFloat();
            }
            case DOUBLE: {
                return (int)this.getDouble();
            }
        }
        try {
            return Integer.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            BigDecimal bigdecimal = new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
            if (bigdecimal.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) < 0) {
                return Integer.MIN_VALUE;
            }
            if (bigdecimal.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0) {
                return Integer.MAX_VALUE;
            }
            return bigdecimal.intValue();
        }
    }

    @Override
    public long getLong() {
        if (this.rawBytes == null) {
            return 0L;
        }
        if (!this.isBinaryEncoded) {
            try {
                return Long.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
            }
            catch (NumberFormatException nfe) {
                BigDecimal bigdecimal = new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
                if (bigdecimal.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
                    return Long.MIN_VALUE;
                }
                if (bigdecimal.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0) {
                    return Long.MAX_VALUE;
                }
                return bigdecimal.longValue();
            }
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                return this.getByte();
            }
            case SMALLINT: 
            case YEAR: {
                return this.getShort();
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInt();
            }
            case BIGINT: {
                long value = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                if (this.columnInfo.isSigned()) {
                    return value;
                }
                return new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)}).longValue();
            }
            case FLOAT: {
                return (long)this.getFloat();
            }
            case DOUBLE: {
                return (long)this.getDouble();
            }
        }
        try {
            return Long.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            BigDecimal bigdecimal = new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
            if (bigdecimal.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
                return Long.MIN_VALUE;
            }
            if (bigdecimal.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0) {
                return Long.MAX_VALUE;
            }
            return bigdecimal.longValue();
        }
    }

    @Override
    public float getFloat() {
        if (this.rawBytes == null) {
            return 0.0f;
        }
        if (!this.isBinaryEncoded) {
            return Float.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8)).floatValue();
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                return this.getByte();
            }
            case SMALLINT: 
            case YEAR: {
                return this.getShort();
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInt();
            }
            case BIGINT: {
                return this.getLong();
            }
            case FLOAT: {
                int value = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8 | (this.rawBytes[2] & 0xFF) << 16 | (this.rawBytes[3] & 0xFF) << 24;
                return Float.intBitsToFloat(value);
            }
            case DOUBLE: {
                return (float)this.getDouble();
            }
        }
        return Float.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8)).floatValue();
    }

    @Override
    public double getDouble() {
        if (this.rawBytes == null) {
            return 0.0;
        }
        if (!this.isBinaryEncoded) {
            return Double.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        switch (this.dataType) {
            case BIT: {
                return this.rawBytes[0];
            }
            case TINYINT: {
                return this.getByte();
            }
            case SMALLINT: 
            case YEAR: {
                return this.getShort();
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInt();
            }
            case BIGINT: {
                return this.getLong();
            }
            case FLOAT: {
                return this.getFloat();
            }
            case DOUBLE: {
                long value = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                return Double.longBitsToDouble(value);
            }
        }
        return Double.valueOf(new String(this.rawBytes, StandardCharsets.UTF_8));
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            return new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        switch (this.dataType) {
            case BIT: {
                return BigDecimal.valueOf(this.rawBytes[0]);
            }
            case TINYINT: {
                return BigDecimal.valueOf(this.getByte());
            }
            case SMALLINT: 
            case YEAR: {
                return BigDecimal.valueOf(this.getShort());
            }
            case INTEGER: 
            case MEDIUMINT: {
                return BigDecimal.valueOf(this.getInt());
            }
            case BIGINT: {
                long value = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                if (this.columnInfo.isSigned()) {
                    return new BigDecimal(String.valueOf(BigInteger.valueOf(value))).setScale(this.columnInfo.getDecimals());
                }
                return new BigDecimal(String.valueOf(new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)}))).setScale(this.columnInfo.getDecimals());
            }
            case FLOAT: {
                return BigDecimal.valueOf((long)this.getFloat());
            }
            case DOUBLE: {
                return BigDecimal.valueOf((long)this.getDouble());
            }
        }
        return new BigDecimal(new String(this.rawBytes, StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getBytes() {
        return this.rawBytes;
    }

    @Override
    public BigInteger getBigInteger() {
        if (this.rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            return new BigInteger(new String(this.rawBytes, StandardCharsets.UTF_8));
        }
        switch (this.dataType) {
            case BIT: {
                return BigInteger.valueOf(this.rawBytes[0]);
            }
            case TINYINT: {
                return BigInteger.valueOf(this.getByte());
            }
            case SMALLINT: 
            case YEAR: {
                return BigInteger.valueOf(this.getShort());
            }
            case INTEGER: 
            case MEDIUMINT: {
                return BigInteger.valueOf(this.getInt());
            }
            case BIGINT: {
                long value = (long)(this.rawBytes[0] & 0xFF) | (long)(this.rawBytes[1] & 0xFF) << 8 | (long)(this.rawBytes[2] & 0xFF) << 16 | (long)(this.rawBytes[3] & 0xFF) << 24 | (long)(this.rawBytes[4] & 0xFF) << 32 | (long)(this.rawBytes[5] & 0xFF) << 40 | (long)(this.rawBytes[6] & 0xFF) << 48 | (long)(this.rawBytes[7] & 0xFF) << 56;
                if (this.columnInfo.isSigned()) {
                    return BigInteger.valueOf(value);
                }
                return new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)});
            }
            case FLOAT: {
                return BigInteger.valueOf((long)this.getFloat());
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.getDouble());
            }
        }
        return new BigInteger(new String(this.rawBytes, StandardCharsets.UTF_8));
    }

    @Override
    public Date getDate(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String rawValue = new String(this.rawBytes, StandardCharsets.UTF_8);
            String zeroDate = "0000-00-00";
            if (rawValue.equals(zeroDate)) {
                return null;
            }
            switch (this.dataType) {
                case TIMESTAMP: 
                case DATETIME: {
                    return new Date(this.getTimestamp(cal).getTime());
                }
                case TIME: {
                    return new Date(this.getTime(cal).getTime());
                }
                case DATE: {
                    return new Date(Integer.parseInt(rawValue.substring(0, 4)) - 1900, Integer.parseInt(rawValue.substring(5, 7)) - 1, Integer.parseInt(rawValue.substring(8, 10)));
                }
                case YEAR: {
                    int year = Integer.parseInt(rawValue);
                    if (this.rawBytes.length == 2 && this.columnInfo.getLength() == 2L) {
                        year = year <= 69 ? (year += 2000) : (year += 1900);
                    }
                    return new Date(year - 1900, 0, 1);
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (cal != null) {
                sdf.setCalendar(cal);
            }
            java.util.Date utilDate = sdf.parse(rawValue);
            return new Date(utilDate.getTime());
        }
        return this.binaryDate();
    }

    @Override
    public Time getTime(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String raw = new String(this.rawBytes, StandardCharsets.UTF_8);
        String zeroDate = "0000-00-00";
        if (raw.equals(zeroDate)) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String[] rawPart;
            if (this.dataType == MariaDbType.TIMESTAMP || this.dataType == MariaDbType.DATETIME) {
                return new Time(this.getTimestamp(cal).getTime());
            }
            if (!this.options.useLegacyDatetimeCode && (raw.startsWith("-") || raw.split(":").length != 3 || raw.indexOf(":") > 3)) {
                throw new ParseException("Time format \"" + raw + "\" incorrect, must be HH:mm:ss", 0);
            }
            boolean negate = raw.startsWith("-");
            if (negate) {
                raw = raw.substring(1);
            }
            if ((rawPart = raw.split(":")).length == 3) {
                int hour = Integer.parseInt(rawPart[0]);
                int minutes = Integer.parseInt(rawPart[1]);
                int seconds = Integer.parseInt(rawPart[2].substring(0, 2));
                Calendar calendar = Calendar.getInstance();
                if (this.options.useLegacyDatetimeCode) {
                    calendar.setLenient(true);
                }
                calendar.clear();
                calendar.set(1970, 0, 1, (negate ? -1 : 1) * hour, minutes, seconds);
                int nanoseconds = this.extractNanos(raw);
                calendar.set(14, nanoseconds / 1000000);
                return new Time(calendar.getTimeInMillis());
            }
            throw new ParseException(raw + " cannot be parse as time. time must have \"99:99:99\" format", 0);
        }
        return this.binaryTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date binaryDate() throws ParseException {
        Date dt;
        Calendar calendar;
        if (this.rawBytes.length == 0) {
            return null;
        }
        int year = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8;
        byte month = this.rawBytes[2];
        byte day = this.rawBytes[3];
        Calendar calendar2 = calendar = Calendar.getInstance();
        synchronized (calendar2) {
            calendar.clear();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dt = new Date(calendar.getTimeInMillis());
        }
        return dt;
    }

    private Time binaryTime() {
        if (this.rawBytes.length == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (this.options.useLegacyDatetimeCode) {
            calendar.setLenient(false);
        }
        byte hour = this.rawBytes[5];
        byte minutes = this.rawBytes[6];
        byte seconds = this.rawBytes[7];
        calendar.set(1970, 0, 1, hour, minutes, seconds);
        int nanoseconds = 0;
        if (this.rawBytes.length > 8) {
            nanoseconds = this.rawBytes[8] & 0xFF | (this.rawBytes[9] & 0xFF) << 8 | (this.rawBytes[10] & 0xFF) << 16 | (this.rawBytes[11] & 0xFF) << 24;
        }
        calendar.set(14, nanoseconds / 1000);
        return new Time(calendar.getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp binaryTimestamp(Calendar cal) throws ParseException {
        Timestamp tt;
        if (this.rawBytes.length == 0) {
            return null;
        }
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        int microseconds = 0;
        if (this.dataType == MariaDbType.TIME) {
            return new Timestamp(this.getTime(cal).getTime());
        }
        int year = this.rawBytes[0] & 0xFF | (this.rawBytes[1] & 0xFF) << 8;
        byte month = this.rawBytes[2];
        byte day = this.rawBytes[3];
        if (this.rawBytes.length > 4) {
            hour = this.rawBytes[4];
            minutes = this.rawBytes[5];
            seconds = this.rawBytes[6];
            if (this.rawBytes.length > 7) {
                microseconds = this.rawBytes[7] & 0xFF | (this.rawBytes[8] & 0xFF) << 8 | (this.rawBytes[9] & 0xFF) << 16 | (this.rawBytes[10] & 0xFF) << 24;
            }
        }
        Calendar calendar = Calendar.getInstance();
        if (!this.options.useLegacyDatetimeCode) {
            calendar = cal;
        }
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.set(year, month - 1, day, hour, minutes, seconds);
            tt = new Timestamp(calendar.getTimeInMillis());
        }
        tt.setNanos(microseconds * 1000);
        return tt;
    }

    private int extractNanos(String timestring) throws ParseException {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        for (int i = index + 1; i < index + 10; ++i) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char value = timestring.charAt(i);
                if (value < '0' || value > '9') {
                    throw new ParseException("cannot parse subsecond part in timestamp string '" + timestring + "'", i);
                }
                digit = value - 48;
            }
            nanos = nanos * 10 + digit;
        }
        return nanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String rawValue = new String(this.rawBytes, StandardCharsets.UTF_8);
            String zeroTimestamp = "0000-00-00 00:00:00";
            if (rawValue.equals(zeroTimestamp)) {
                return null;
            }
            switch (this.dataType) {
                case TIME: {
                    Timestamp tt = new Timestamp(this.getTime(cal).getTime());
                    tt.setNanos(this.extractNanos(rawValue));
                    return tt;
                }
            }
            try {
                Timestamp timestamp;
                int year = Integer.parseInt(rawValue.substring(0, 4));
                int month = Integer.parseInt(rawValue.substring(5, 7));
                int day = Integer.parseInt(rawValue.substring(8, 10));
                int hour = Integer.parseInt(rawValue.substring(11, 13));
                int minutes = Integer.parseInt(rawValue.substring(14, 16));
                int seconds = Integer.parseInt(rawValue.substring(17, 19));
                int nanoseconds = this.extractNanos(rawValue);
                Calendar calendar = cal;
                if (this.options.useLegacyDatetimeCode) {
                    calendar = Calendar.getInstance();
                }
                Calendar calendar2 = calendar;
                synchronized (calendar2) {
                    calendar.set(1, year);
                    calendar.set(2, month - 1);
                    calendar.set(5, day);
                    calendar.set(11, hour);
                    calendar.set(12, minutes);
                    calendar.set(13, seconds);
                    calendar.set(14, nanoseconds / 1000000);
                    timestamp = new Timestamp(calendar.getTime().getTime());
                }
                timestamp.setNanos(nanoseconds);
                return timestamp;
            }
            catch (NumberFormatException n) {
                throw new ParseException("Value \"" + rawValue + "\" cannot be parse as Timestamp", 0);
            }
            catch (StringIndexOutOfBoundsException s) {
                throw new ParseException("Value \"" + rawValue + "\" cannot be parse as Timestamp", 0);
            }
        }
        return this.binaryTimestamp(cal);
    }

    @Override
    public InputStream getInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(new String(this.rawBytes, StandardCharsets.UTF_8).getBytes());
    }

    @Override
    public InputStream getBinaryInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.rawBytes);
    }

    @Override
    public boolean getBoolean() {
        if (this.rawBytes == null) {
            return false;
        }
        String rawVal = new String(this.rawBytes, StandardCharsets.UTF_8);
        return rawVal.equalsIgnoreCase("true") || rawVal.equalsIgnoreCase("1") || (this.rawBytes[0] & 1) == 1;
    }

    @Override
    public boolean isNull() {
        String zeroTimestamp = "0000-00-00 00:00:00";
        String zeroDate = "0000-00-00";
        return this.rawBytes == null || this.isBinaryEncoded && (this.dataType == MariaDbType.DATE || this.dataType == MariaDbType.TIMESTAMP || this.dataType == MariaDbType.DATETIME) && this.rawBytes.length == 0 || !this.isBinaryEncoded && (this.dataType == MariaDbType.TIMESTAMP || this.dataType == MariaDbType.DATETIME) && zeroTimestamp.equals(new String(this.rawBytes, StandardCharsets.UTF_8)) || !this.isBinaryEncoded && this.dataType == MariaDbType.DATE && zeroDate.equals(new String(this.rawBytes, StandardCharsets.UTF_8));
    }

    public int getDisplayLength() {
        if (this.rawBytes != null) {
            return this.rawBytes.length;
        }
        return 4;
    }

    @Override
    public Blob getBlob() {
        if (this.rawBytes == null) {
            return null;
        }
        return new MariaDbBlob(this.rawBytes);
    }

    public Clob getClob() {
        if (this.rawBytes == null) {
            return null;
        }
        return new MariaDbClob(this.rawBytes);
    }

    @Override
    public Object getObject(int datatypeMappingFlags, Calendar cal) throws ParseException {
        if (this.getBytes() == null) {
            return null;
        }
        switch (this.dataType) {
            case BIT: {
                if (this.columnInfo.getLength() == 1L) {
                    return this.getBytes()[0] != 0;
                }
                return this.getBytes();
            }
            case TINYINT: {
                if ((datatypeMappingFlags & 1) != 0 && this.columnInfo.getLength() == 1L) {
                    return this.getBytes()[0] != 48;
                }
                return this.getInt();
            }
            case INTEGER: {
                if (!this.columnInfo.isSigned()) {
                    return this.getLong();
                }
                return this.getInt();
            }
            case BIGINT: {
                if (!this.columnInfo.isSigned()) {
                    return this.getBigInteger();
                }
                return this.getLong();
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case TIMESTAMP: {
                return this.getTimestamp(cal);
            }
            case DATETIME: {
                return this.getTimestamp(cal);
            }
            case DATE: {
                return this.getDate(cal);
            }
            case VARCHAR: {
                if (this.columnInfo.isBinary()) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case DECIMAL: {
                return this.getBigDecimal();
            }
            case BLOB: {
                return this.getBytes();
            }
            case LONGBLOB: {
                return this.getBytes();
            }
            case MEDIUMBLOB: {
                return this.getBytes();
            }
            case TINYBLOB: {
                return this.getBytes();
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if ((datatypeMappingFlags & 2) != 0) {
                    return this.getDate(cal);
                }
                return this.getShort();
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInt();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case TIME: {
                return this.getTime(cal);
            }
            case VARSTRING: 
            case STRING: {
                if (this.columnInfo.isBinary()) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case OLDDECIMAL: {
                return this.getString();
            }
            case GEOMETRY: {
                return this.getBytes();
            }
            case ENUM: {
                break;
            }
            case NEWDATE: {
                break;
            }
            case SET: {
                break;
            }
        }
        throw new RuntimeException(this.dataType.toString());
    }
}

