/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;

public class MariaDbParameterMetaData
implements ParameterMetaData {
    private final ColumnInformation[] columnInformations;

    public MariaDbParameterMetaData(ColumnInformation[] columnInformations) {
        this.columnInformations = columnInformations;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.columnInformations.length;
    }

    private ColumnInformation getColumnInformation(int column) throws SQLException {
        if (column >= 1 && column <= this.columnInformations.length) {
            return this.columnInformations[column - 1];
        }
        throw new SQLException("Parameter metadata out of range : param was " + column + " and must be 1 <= param <=" + this.columnInformations.length, "22003");
    }

    @Override
    public int isNullable(int param) throws SQLException {
        if ((this.getColumnInformation(param).getFlags() & 1) == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getColumnInformation(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        long length = this.getColumnInformation(param).getLength();
        return length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (MariaDbType.isNumeric(this.getColumnInformation(param).getType())) {
            return this.getColumnInformation(param).getDecimals();
        }
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getColumnInformation(param).getType().getSqlType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getColumnInformation(param).getType().getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getColumnInformation(param).getType().getClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

