/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.common.packet.CommandPacket;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.query.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.NullParameter;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.common.queryresults.PrepareResult;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class SendExecutePrepareStatementPacket
implements CommandPacket {
    private final int parameterCount;
    private final ParameterHolder[] parameters;
    private final int statementId;
    private MySQLType[] parameterTypeHeader;

    public SendExecutePrepareStatementPacket(PrepareResult prepareResult, ParameterHolder[] parameters, int parameterCount, MySQLType[] parameterTypeHeader) {
        this.parameterCount = parameterCount;
        this.parameters = parameters;
        this.statementId = prepareResult.statementId;
        this.parameterTypeHeader = parameterTypeHeader;
    }

    @Override
    public int send(OutputStream os) throws IOException {
        PacketOutputStream buffer = (PacketOutputStream)os;
        buffer.startPacket(0);
        buffer.assureBufferCapacity(1000);
        buffer.writeByte((byte)23);
        buffer.writeInt(this.statementId);
        buffer.writeByte((byte)0);
        buffer.writeInt(1);
        if (this.parameterCount > 0) {
            int i;
            int nullCount = (this.parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i2 = 0; i2 < this.parameterCount; ++i2) {
                if (!(this.parameters[i2] instanceof NullParameter)) continue;
                int n = i2 / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i2 % 8);
            }
            buffer.writeByteArray(nullBitsBuffer);
            boolean mustSendHeaderType = false;
            if (this.parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i = 0; i < this.parameterCount; ++i) {
                    if (this.parameterTypeHeader[i].equals((Object)this.parameters[i].getMySQLType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            if (mustSendHeaderType) {
                buffer.writeByte((byte)1);
                for (i = 0; i < this.parameterCount; ++i) {
                    this.parameterTypeHeader[i] = this.parameters[i].getMySQLType();
                    this.parameters[i].writeBufferType(buffer);
                }
            } else {
                buffer.writeByte((byte)0);
            }
        }
        for (int i = 0; i < this.parameterCount; ++i) {
            if (!(this.parameters[i] instanceof NotLongDataParameterHolder)) continue;
            ((NotLongDataParameterHolder)this.parameters[i]).writeBinary(buffer);
        }
        buffer.finishPacket();
        return 0;
    }
}

