/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.packet.CommandPacket;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;

public class MySQLClientAuthPacket
implements CommandPacket {
    private final byte packetSeq;
    private final String username;
    private final String password;
    private final byte[] seed;
    private final int serverCapabilities;
    private final byte serverLanguage;
    private final String database;

    public MySQLClientAuthPacket(String username, String password, String database, int serverCapabilities, byte serverLanguage, byte[] seed, byte packetSeq) {
        this.packetSeq = packetSeq;
        this.username = username;
        this.password = password;
        this.seed = seed;
        this.serverCapabilities = serverCapabilities;
        this.serverLanguage = serverLanguage;
        this.database = database;
    }

    @Override
    public int send(OutputStream os) throws IOException {
        byte[] scrambledPassword;
        PacketOutputStream writeBuffer = (PacketOutputStream)os;
        writeBuffer.startPacket(this.packetSeq);
        try {
            scrambledPassword = Utils.encryptPassword(this.password, this.seed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
        writeBuffer.writeInt(this.serverCapabilities).writeInt(0x40000000).writeByte(this.serverLanguage).writeBytes((byte)0, 23).writeString(this.username).writeByte((byte)0).writeByte((byte)scrambledPassword.length).writeByteArray(scrambledPassword);
        if ((this.serverCapabilities & 8) != 0) {
            writeBuffer.writeString(this.database).writeByte((byte)0);
        }
        writeBuffer.finishPacket();
        return 1;
    }
}

