/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.common.packet.RawPacket;

public class Reader {
    private final byte packetSeq;
    private ByteBuffer byteBuffer;

    public Reader(RawPacket rawPacket) {
        this.packetSeq = 0;
        this.byteBuffer = rawPacket.getByteBuffer();
    }

    public String readString(Charset charset) {
        byte ch;
        int cnt = 0;
        byte[] byteArrBuff = new byte[this.byteBuffer.remaining()];
        while (this.byteBuffer.remaining() > 0 && (ch = this.byteBuffer.get()) != 0) {
            byteArrBuff[cnt++] = ch;
        }
        return new String(byteArrBuff, 0, cnt, charset);
    }

    public short readShort() {
        return this.byteBuffer.getShort();
    }

    public int readInt() {
        return this.byteBuffer.getInt();
    }

    public long readLong() {
        return this.byteBuffer.getLong();
    }

    public byte readByte() {
        return this.byteBuffer.get();
    }

    public byte[] readRawBytes(int numberOfBytes) {
        byte[] tmpArr = new byte[numberOfBytes];
        this.byteBuffer.get(tmpArr, 0, numberOfBytes);
        return tmpArr;
    }

    public void skipByte() throws IOException {
        this.byteBuffer.get();
    }

    public long skipBytes(int bytesToSkip) {
        this.byteBuffer.position(this.byteBuffer.position() + bytesToSkip);
        return bytesToSkip;
    }

    public Reader skipLengthEncodedBytes() {
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        this.skipBytes((int)encLength);
        return this;
    }

    public int read24bitword() {
        byte[] tmpArr = new byte[3];
        for (int i = 0; i < 3; ++i) {
            tmpArr[i] = this.byteBuffer.get();
        }
        return (tmpArr[0] & 0xFF) + ((tmpArr[1] & 0xFF) << 8) + ((tmpArr[2] & 0xFF) << 16);
    }

    public long getLengthEncodedBinary() {
        if (this.byteBuffer.remaining() == 0) {
            return 0L;
        }
        byte type = this.byteBuffer.get();
        if ((type & 0xFF) == 251) {
            return -1L;
        }
        if ((type & 0xFF) == 252) {
            return 0xFFFFL & (long)this.readShort();
        }
        if ((type & 0xFF) == 253) {
            return 0xFFFFFF & this.read24bitword();
        }
        if ((type & 0xFF) == 254) {
            return this.readLong();
        }
        if ((type & 0xFF) <= 250) {
            return 0xFFL & (long)type;
        }
        return 0L;
    }

    public String getLengthEncodedString() {
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        byte[] tmpBuf = new byte[(int)encLength];
        this.byteBuffer.get(tmpBuf);
        return new String(tmpBuf, StandardCharsets.UTF_8);
    }

    public byte[] getLengthEncodedBytes() throws IOException {
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        byte[] tmpBuf = new byte[(int)encLength];
        this.byteBuffer.get(tmpBuf);
        return tmpBuf;
    }

    public byte[] getLengthEncodedBytesWithLength(long length) {
        byte[] tmpBuf = new byte[(int)length];
        this.byteBuffer.get(tmpBuf);
        return tmpBuf;
    }

    public byte getByteAt(int i) throws IOException {
        return this.byteBuffer.get(i);
    }

    public byte getPacketSeq() {
        return this.packetSeq;
    }

    public int getRemainingSize() {
        return this.byteBuffer.remaining();
    }

    public void appendPacket(RawPacket rawPacket) {
        ByteBuffer newBuffer = ByteBuffer.allocate(this.byteBuffer.capacity() + rawPacket.getByteBuffer().capacity()).order(ByteOrder.LITTLE_ENDIAN);
        int pos = this.byteBuffer.position();
        this.byteBuffer.rewind();
        newBuffer.put(this.byteBuffer);
        newBuffer.put(rawPacket.getByteBuffer());
        newBuffer.position(pos);
        this.byteBuffer = newBuffer;
    }

    public long getSilentLengthEncodedBinary() {
        if (this.byteBuffer.remaining() == 0) {
            return 0L;
        }
        int pos1 = this.byteBuffer.position();
        this.byteBuffer.mark();
        long valueLen = this.getLengthEncodedBinary();
        int pos2 = this.byteBuffer.position();
        this.byteBuffer.reset();
        return valueLen + (long)(pos2 - pos1);
    }
}

