/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.query.parameters.LongDataParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class ReaderParameter
extends LongDataParameterHolder {
    Reader reader;
    long length;
    boolean noBackslashEscapes;

    public ReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.reader = reader;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public ReaderParameter(Reader reader, boolean noBackslashEscapes) {
        this(reader, Long.MAX_VALUE, noBackslashEscapes);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            ParameterWriter.write(os, this.reader, this.noBackslashEscapes);
        } else {
            ParameterWriter.write(os, this.reader, this.length, this.noBackslashEscapes);
        }
    }

    @Override
    public void writeBinary(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            os.sendStream(this.reader, this.mySQLServerCharset);
        } else {
            os.sendStream(this.reader, this.length, this.mySQLServerCharset);
        }
    }

    @Override
    public MySQLType getMySQLType() {
        return MySQLType.BLOB;
    }

    @Override
    public String toString() {
        return "<Reader> " + this.reader;
    }

    @Override
    public boolean isLongData() {
        return true;
    }
}

