/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.internal.common.Utils;

class CallableParameterMetaData
implements ParameterMetaData {
    static Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?([\\w\\d]+)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    static Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    CallParameter[] params;
    MySQLConnection con;
    String name;
    boolean valid;
    boolean isFunction;
    boolean noAccessToMetadata;

    public CallableParameterMetaData(CallParameter[] params, MySQLConnection con, String name, boolean isFunction) {
        this.params = params;
        this.con = con;
        this.name = name;
        this.isFunction = isFunction;
    }

    public void readMetadataFromDBIfRequired() throws SQLException {
        if (this.noAccessToMetadata || this.valid) {
            return;
        }
        try {
            this.readMetadata();
            this.valid = true;
        }
        catch (SQLException e) {
            this.noAccessToMetadata = true;
            throw e;
        }
    }

    int mapMySQLTypeToJDBC(String t) {
        if ((t = t.toUpperCase()).equals("BIT")) {
            return -7;
        }
        if (t.equals("TINYINT")) {
            return -6;
        }
        if (t.equals("SMALLINT")) {
            return 5;
        }
        if (t.equals("MEDIUMINT")) {
            return 4;
        }
        if (t.equals("INT")) {
            return 4;
        }
        if (t.equals("INTEGER")) {
            return 4;
        }
        if (t.equals("LONG")) {
            return 4;
        }
        if (t.equals("BIGINT")) {
            return -5;
        }
        if (t.equals("INT24")) {
            return 4;
        }
        if (t.equals("REAL")) {
            return 8;
        }
        if (t.equals("FLOAT")) {
            return 6;
        }
        if (t.equals("DECIMAL")) {
            return 3;
        }
        if (t.equals("NUMERIC")) {
            return 2;
        }
        if (t.equals("DOUBLE")) {
            return 8;
        }
        if (t.equals("CHAR")) {
            return 1;
        }
        if (t.equals("VARCHAR")) {
            return 12;
        }
        if (t.equals("DATE")) {
            return 91;
        }
        if (t.equals("TIME")) {
            return 92;
        }
        if (t.equals("YEAR")) {
            return 5;
        }
        if (t.equals("TIMESTAMP")) {
            return 93;
        }
        if (t.equals("DATETIME")) {
            return 93;
        }
        if (t.equals("TINYBLOB")) {
            return -2;
        }
        if (t.equals("BLOB")) {
            return -4;
        }
        if (t.equals("MEDIUMBLOB")) {
            return -4;
        }
        if (t.equals("LONGBLOB")) {
            return -4;
        }
        if (t.equals("TINYTEXT")) {
            return 12;
        }
        if (t.equals("TEXT")) {
            return -1;
        }
        if (t.equals("MEDIUMTEXT")) {
            return -1;
        }
        if (t.equals("LONGTEXT")) {
            return -1;
        }
        if (t.equals("ENUM")) {
            return 12;
        }
        if (t.equals("SET")) {
            return 12;
        }
        if (t.equals("GEOMETRY")) {
            return -4;
        }
        if (t.equals("VARBINARY")) {
            return -3;
        }
        return 1111;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMetadata() throws SQLException {
        int paramIndex;
        String functionReturn;
        String paramList;
        if (this.noAccessToMetadata || this.valid) {
            return;
        }
        boolean noBackslashEscapes = false;
        if (this.con instanceof MySQLConnection) {
            noBackslashEscapes = this.con.noBackslashEscapes;
        }
        String dbname = "database()";
        String procedureNameNoDb = this.name;
        int dotIndex = this.name.indexOf(46);
        if (dotIndex > 0) {
            dbname = this.name.substring(0, dotIndex);
            dbname = dbname.replace("`", "");
            dbname = "'" + Utils.escapeString(dbname, noBackslashEscapes) + "'";
            procedureNameNoDb = this.name.substring(dotIndex + 1);
        }
        procedureNameNoDb = procedureNameNoDb.replace("`", "");
        procedureNameNoDb = "'" + Utils.escapeString(procedureNameNoDb, noBackslashEscapes) + "'";
        Statement st = this.con.createStatement();
        ResultSet rs = null;
        try {
            String q = "select param_list,returns from mysql.proc where db=" + dbname + " and name=" + procedureNameNoDb;
            rs = st.executeQuery(q);
            if (!rs.next()) {
                throw new SQLException("procedure or function " + this.name + "does not exist");
            }
            paramList = rs.getString(1);
            functionReturn = rs.getString(2);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        if (this.isFunction) {
            if (functionReturn == null || functionReturn.length() == 0) {
                throw new SQLException(this.name + "is not a function returning value");
            }
            Matcher m = RETURN_PATTERN.matcher(functionReturn);
            if (!m.matches()) {
                throw new SQLException("can not parse return value definition :" + functionReturn);
            }
            CallParameter p = this.params[1];
            p.isOutput = true;
            p.isSigned = m.group(1) == null;
            p.typeName = m.group(2).trim();
            p.sqlType = this.mapMySQLTypeToJDBC(p.typeName);
            String scale = m.group(3);
            if (scale != null) {
                scale = scale.replace("(", "").replace(")", "").replace(" ", "");
                p.scale = Integer.valueOf(scale);
            }
        }
        String splitter = ",";
        StringTokenizer tokenizer = new StringTokenizer(paramList, splitter, false);
        int n = paramIndex = this.isFunction ? 2 : 1;
        while (tokenizer.hasMoreTokens()) {
            if (paramIndex >= this.params.length) {
                throw new SQLException("Invalid placeholder count in CallableStatement");
            }
            String paramDef = tokenizer.nextToken();
            Pattern pattern = Pattern.compile(".*\\([^)]*");
            Matcher matcher = pattern.matcher(paramDef);
            while (matcher.matches()) {
                paramDef = paramDef + splitter + tokenizer.nextToken();
                matcher = pattern.matcher(paramDef);
            }
            Matcher m = PARAMETER_PATTERN.matcher(paramDef);
            if (!m.matches()) {
                throw new SQLException("cannot parse parameter definition :" + paramDef);
            }
            String direction = m.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            String paramName = m.group(2);
            paramName = paramName.trim();
            boolean isSigned = m.group(3) == null;
            String dataType = m.group(4);
            dataType = dataType.trim();
            String scale = m.group(5);
            if (scale != null) {
                scale = scale.trim();
            }
            CallParameter p = this.params[paramIndex];
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                p.isInput = true;
            } else if (direction.equalsIgnoreCase("OUT")) {
                p.isOutput = true;
            } else if (direction.equalsIgnoreCase("INOUT")) {
                p.isOutput = true;
                p.isInput = true;
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + paramName);
            }
            p.name = paramName;
            p.typeName = dataType.toUpperCase();
            p.sqlType = this.mapMySQLTypeToJDBC(p.typeName);
            p.isSigned = isSigned;
            if (scale != null) {
                if ((scale = scale.replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                    scale = scale.substring(0, scale.indexOf(","));
                }
                p.scale = Integer.valueOf(scale);
            }
            ++paramIndex;
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.params.length - 1;
    }

    CallParameter getParam(int index) throws SQLException {
        if (index < 1 || index >= this.params.length) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.readMetadataFromDBIfRequired();
        return this.params[index];
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParam((int)param).isNullable;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParam((int)param).isSigned;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParam((int)param).precision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParam((int)param).scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParam((int)param).sqlType;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParam((int)param).typeName;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParam((int)param).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        CallParameter p = this.getParam(param);
        if (p.isInput && p.isOutput) {
            return 2;
        }
        if (p.isInput) {
            return 1;
        }
        if (p.isOutput) {
            return 4;
        }
        return 0;
    }

    public String getName(int param) throws SQLException {
        return this.getParam((int)param).name;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

