/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.mysql.FailoverProxy;
import org.mariadb.jdbc.internal.mysql.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.mysql.listener.impl.AuroraListener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;

public class AuroraProtocol
extends MastersSlavesProtocol {
    private static final Logger log = Logger.getLogger(AuroraProtocol.class.getName());

    public AuroraProtocol(JDBCUrl url, ReentrantReadWriteLock lock) {
        super(url, lock);
    }

    @Override
    public boolean isMasterConnection() {
        return this.masterConnection;
    }

    @Override
    public boolean checkIfMaster() throws QueryException {
        this.proxy.lock.writeLock().lock();
        try {
            SelectQueryResult queryResult = (SelectQueryResult)this.executeQuery(new MySQLQuery("show global variables like 'innodb_read_only'"));
            if (queryResult != null) {
                queryResult.next();
                this.masterConnection = "OFF".equals(queryResult.getValueObject(1).getString());
            } else {
                this.masterConnection = false;
            }
            this.readOnly = !this.masterConnection;
            boolean bl = this.masterConnection;
            return bl;
        }
        catch (IOException ioe) {
            log.log(Level.FINEST, "exception during checking if master", ioe);
            throw new QueryException("could not check the 'innodb_read_only' variable status on " + this.getHostAddress() + " : " + ioe.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), ioe);
        }
        finally {
            this.proxy.lock.writeLock().unlock();
        }
    }

    public static void searchProbableMaster(AuroraListener listener, HostAddress probableMaster, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        block10: {
            if (log.isLoggable(Level.FINE)) {
                log.fine("searching for master:" + searchFilter.isSearchForMaster() + " replica:" + searchFilter.isSearchForSlave() + " address:" + probableMaster + " blacklist:" + blacklist.keySet());
            }
            AuroraProtocol protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
            try {
                protocol.setHostAddress(probableMaster);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("trying to connect to " + protocol.getHostAddress());
                }
                protocol.connect();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("connected to " + protocol.getHostAddress());
                }
                if (searchFilter.isSearchForMaster() && protocol.isMasterConnection()) {
                    searchFilter.setSearchForMaster(false);
                    protocol.setMustBeMasterConnection(true);
                    listener.foundActiveMaster(protocol);
                } else if (searchFilter.isSearchForSlave() && !protocol.isMasterConnection()) {
                    searchFilter.setSearchForSlave(false);
                    protocol.setMustBeMasterConnection(false);
                    listener.foundActiveSecondary(protocol);
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("close connection because unused : " + protocol.getHostAddress());
                    }
                    protocol.close();
                    protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
                }
            }
            catch (QueryException e) {
                blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
                if (!log.isLoggable(Level.FINE)) break block10;
                log.fine("Could not connect to " + protocol.currentHost + " searching for master : " + searchFilter.isSearchForMaster() + " for replica :" + searchFilter.isSearchForSlave() + " error:" + e.getMessage());
            }
        }
    }

    public static void loop(AuroraListener listener, List<HostAddress> addresses, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("searching for master:" + searchFilter.isSearchForMaster() + " replica:" + searchFilter.isSearchForSlave() + " addresses:" + addresses);
        }
        LinkedList<HostAddress> loopAddresses = new LinkedList<HostAddress>(addresses);
        int maxConnectionTry = listener.getRetriesAllDown();
        QueryException lastQueryException = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isUniqueLoop() && maxConnectionTry > 0) {
            block19: {
                AuroraProtocol protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
                if (listener.isExplicitClosed() || !listener.isSecondaryHostFail() && !listener.isMasterHostFail()) {
                    return;
                }
                --maxConnectionTry;
                try {
                    protocol.setHostAddress((HostAddress)loopAddresses.get(0));
                    loopAddresses.remove(0);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("trying to connect to " + protocol.getHostAddress());
                    }
                    protocol.connect();
                    blacklist.remove(protocol.getHostAddress());
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("connected to " + (protocol.isMasterConnection() ? "primary " : "replica ") + protocol.getHostAddress());
                    }
                    if (searchFilter.isSearchForMaster() && protocol.isMasterConnection()) {
                        log.finest("locks -0 : " + protocol.getProxy().lock.getReadHoldCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                        if (AuroraProtocol.foundMaster(listener, protocol, searchFilter)) {
                            return;
                        }
                        log.finest("locks -1: " + protocol.getProxy().lock.getReadHoldCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                    } else if (searchFilter.isSearchForSlave() && !protocol.isMasterConnection()) {
                        log.finest("locks -2: " + protocol.getProxy().lock.getReadHoldCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                        if (AuroraProtocol.foundSecondary(listener, protocol, searchFilter)) {
                            return;
                        }
                        log.finest("locks -3: " + protocol.getProxy().lock.getReadHoldCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                        HostAddress probableMasterHost = listener.searchByStartName(protocol, listener.getJdbcUrl().getHostAddresses());
                        if (probableMasterHost != null) {
                            loopAddresses.remove(probableMasterHost);
                            AuroraProtocol.searchProbableMaster(listener, probableMasterHost, blacklist, searchFilter);
                            log.finest("locks -4: " + protocol.getProxy().lock.getReadHoldCount() + " " + protocol.getProxy().lock.getWriteHoldCount());
                            if (!searchFilter.isSearchForMaster()) {
                                return;
                            }
                        }
                    } else {
                        protocol.close();
                    }
                }
                catch (QueryException e) {
                    lastQueryException = e;
                    blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
                    if (!log.isLoggable(Level.FINE)) break block19;
                    log.fine("Could not connect to " + protocol.getHostAddress() + " searching: " + searchFilter + " error: " + e.getMessage());
                }
            }
            if (!searchFilter.isSearchForMaster() && !searchFilter.isSearchForSlave()) {
                return;
            }
            if (!loopAddresses.isEmpty() || searchFilter.isUniqueLoop() || maxConnectionTry <= 0) continue;
            loopAddresses = new LinkedList<HostAddress>(addresses);
            listener.checkIfTypeHaveChanged(searchFilter);
        }
        if (searchFilter.isSearchForMaster() || searchFilter.isSearchForSlave()) {
            String error = "No active connection found for replica";
            if (searchFilter.isSearchForMaster()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new QueryException(error, lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
            }
            throw new QueryException(error);
        }
    }

    private static boolean foundMaster(AuroraListener listener, AuroraProtocol protocol, SearchFilter searchFilter) {
        protocol.setMustBeMasterConnection(true);
        searchFilter.setSearchForMaster(false);
        listener.foundActiveMaster(protocol);
        if (!searchFilter.isSearchForSlave()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() || !listener.isSecondaryHostFail();
    }

    private static boolean foundSecondary(AuroraListener listener, AuroraProtocol protocol, SearchFilter searchFilter) {
        searchFilter.setSearchForSlave(false);
        protocol.setMustBeMasterConnection(false);
        listener.foundActiveSecondary(protocol);
        if (!searchFilter.isSearchForMaster()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlySlave() || !listener.isMasterHostFail();
    }

    public static AuroraProtocol getNewProtocol(FailoverProxy proxy, JDBCUrl jdbcUrl) {
        AuroraProtocol newProtocol = new AuroraProtocol(jdbcUrl, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }
}

