/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLParameterMetaData;
import org.mariadb.jdbc.MySQLServerSidePreparedStatement;
import org.mariadb.jdbc.MySQLStatement;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.query.IllegalParameterException;
import org.mariadb.jdbc.internal.common.query.MySQLParameterizedQuery;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.query.parameters.BigDecimalParameter;
import org.mariadb.jdbc.internal.common.query.parameters.ByteArrayParameter;
import org.mariadb.jdbc.internal.common.query.parameters.DateParameter;
import org.mariadb.jdbc.internal.common.query.parameters.DoubleParameter;
import org.mariadb.jdbc.internal.common.query.parameters.IntParameter;
import org.mariadb.jdbc.internal.common.query.parameters.LongParameter;
import org.mariadb.jdbc.internal.common.query.parameters.NullParameter;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.ReaderParameter;
import org.mariadb.jdbc.internal.common.query.parameters.SerializableParameter;
import org.mariadb.jdbc.internal.common.query.parameters.StreamParameter;
import org.mariadb.jdbc.internal.common.query.parameters.StringParameter;
import org.mariadb.jdbc.internal.common.query.parameters.TimeParameter;
import org.mariadb.jdbc.internal.common.query.parameters.TimestampParameter;

public class MySQLPreparedStatement
extends MySQLStatement
implements PreparedStatement {
    private static final Logger log = Logger.getLogger(MySQLPreparedStatement.class.getName());
    private MySQLParameterizedQuery dQuery;
    private String sql;
    private boolean useFractionalSeconds;
    boolean parametersCleared;

    public MySQLPreparedStatement(MySQLConnection connection, String sql) throws SQLException {
        super(connection);
        this.sql = sql;
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Creating prepared statement for " + sql);
        }
        this.dQuery = new MySQLParameterizedQuery(Utils.nativeSQL(sql, connection.noBackslashEscapes), connection.noBackslashEscapes);
        this.parametersCleared = true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.dQuery);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.dQuery);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.dQuery);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkBatchFields();
        this.batchQueries.add(this.dQuery.cloneQuery());
        this.isInsertRewriteable(this.dQuery.getQuery());
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkBatchFields();
        this.isInsertRewriteable(sql);
        this.batchQueries.add(new MySQLQuery(sql));
    }

    private void checkBatchFields() {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList();
        }
    }

    @Override
    public void clearBatch() {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
        this.firstRewrite = null;
        this.isRewriteable = true;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.connection.noBackslashEscapes));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("REF not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x.getBinaryStream(), this.connection.noBackslashEscapes));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2005);
            return;
        }
        StreamParameter stream = new StreamParameter(x.getAsciiStream(), this.connection.noBackslashEscapes);
        stream.setText(true);
        this.setParameter(parameterIndex, stream);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Arrays not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        MySQLServerSidePreparedStatement ssps = new MySQLServerSidePreparedStatement(this.connection, this.sql);
        ssps.close();
        return ssps.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        if (date == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        this.setParameter(parameterIndex, new DateParameter(date, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        if (time == null) {
            this.setNull(parameterIndex, 92);
            return;
        }
        this.setParameter(parameterIndex, new TimeParameter(time, cal, this.useFractionalSeconds));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        if (timestamp == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        TimestampParameter t = new TimestampParameter(timestamp, cal, this.useFractionalSeconds);
        this.setParameter(parameterIndex, t);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    private void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        try {
            this.dQuery.setParameter(parameterIndex - 1, holder);
            this.parametersCleared = false;
        }
        catch (IllegalParameterException e) {
            throw SQLExceptionMapper.getSQLException("Could not set parameter", e);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, new StringParameter(x.toString(), this.connection.noBackslashEscapes));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new MySQLParameterMetaData(this.dQuery);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NStrings not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NCharstreams not supported");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NClobs not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Clobs not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(inputStream, length, this.connection.noBackslashEscapes));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NClobs not supported");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("SQlXML not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2002: 
            case 2003: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw SQLExceptionMapper.getFeatureNotSupportedException("Datatype not supported");
            }
            case 4: {
                if (x instanceof Number) {
                    this.setNumber(parameterIndex, (Number)x);
                    break;
                }
                this.setInt(parameterIndex, Integer.valueOf((String)x));
            }
        }
        throw SQLExceptionMapper.getFeatureNotSupportedException("Method not yet implemented");
    }

    private void setNumber(int parameterIndex, Number number) throws SQLException {
        if (number instanceof Integer) {
            this.setInt(parameterIndex, (Integer)number);
        } else if (number instanceof Short) {
            this.setShort(parameterIndex, (Short)number);
        } else {
            this.setLong(parameterIndex, number.longValue());
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.connection.noBackslashEscapes));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.connection.noBackslashEscapes));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.connection.noBackslashEscapes));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, this.connection.noBackslashEscapes));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, this.connection.noBackslashEscapes));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, this.connection.noBackslashEscapes));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(inputStream, this.connection.noBackslashEscapes));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setBoolean(int column, boolean value) throws SQLException {
        if (value) {
            this.setByte(column, (byte)1);
        } else {
            this.setByte(column, (byte)0);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, new IntParameter(x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, new IntParameter(x));
    }

    @Override
    public void setString(int column, String s) throws SQLException {
        if (s == null) {
            this.setNull(column, 12);
            return;
        }
        this.setParameter(column, new StringParameter(s, this.connection.noBackslashEscapes));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new ByteArrayParameter(x, this.connection.noBackslashEscapes));
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.setDate(parameterIndex, date, this.connection.cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, this.connection.cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        this.setTimestamp(parameterIndex, timestamp, this.connection.cal);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.connection.noBackslashEscapes));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.connection.noBackslashEscapes));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.connection.noBackslashEscapes));
    }

    @Override
    public void clearParameters() {
        this.dQuery.clearParameters();
        this.parametersCleared = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw SQLExceptionMapper.getFeatureNotSupportedException("Type not supported");
            }
        }
        if (x == null) {
            this.setNull(parameterIndex, 4);
            return;
        } else if (x instanceof String) {
            if (targetSqlType == 2004) {
                throw SQLExceptionMapper.getSQLException("Cannot convert a String to a Blob");
            }
            String s = (String)x;
            switch (targetSqlType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    try {
                        this.setLong(parameterIndex, Long.valueOf(s));
                        return;
                    }
                    catch (NumberFormatException e) {
                        throw SQLExceptionMapper.getSQLException("Could not convert [" + s + "] to " + targetSqlType, e);
                    }
                }
                case 8: {
                    try {
                        this.setDouble(parameterIndex, Double.valueOf(s));
                        return;
                    }
                    catch (NumberFormatException e) {
                        throw SQLExceptionMapper.getSQLException("Could not convert [" + s + "] to " + targetSqlType, e);
                    }
                }
                case 6: 
                case 7: {
                    try {
                        this.setFloat(parameterIndex, Float.valueOf(s).floatValue());
                        return;
                    }
                    catch (NumberFormatException e) {
                        throw SQLExceptionMapper.getSQLException("Could not convert [" + s + "] to " + targetSqlType, e);
                    }
                }
                case 2: 
                case 3: {
                    try {
                        this.setBigDecimal(parameterIndex, new BigDecimal(s));
                        return;
                    }
                    catch (NumberFormatException e) {
                        throw SQLExceptionMapper.getSQLException("Could not convert [" + s + "] to " + targetSqlType, e);
                    }
                }
                case -7: {
                    this.setBoolean(parameterIndex, Boolean.valueOf(s));
                    return;
                }
                case -1: 
                case 1: 
                case 12: 
                case 92: 
                case 93: {
                    this.setString(parameterIndex, s);
                    return;
                }
                default: {
                    throw SQLExceptionMapper.getSQLException("Could not convert [" + s + "] to " + targetSqlType);
                }
            }
        } else if (x instanceof Number) {
            this.testNumbers(targetSqlType);
            Number bd = (Number)x;
            switch (targetSqlType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case 8: {
                    this.setDouble(parameterIndex, bd.doubleValue());
                    return;
                }
                case 6: 
                case 7: {
                    this.setFloat(parameterIndex, bd.floatValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (x instanceof BigDecimal) {
                        this.setBigDecimal(parameterIndex, (BigDecimal)x);
                        return;
                    }
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case -7: {
                    this.setBoolean(parameterIndex, bd.shortValue() != 0);
                    return;
                }
                case 1: 
                case 12: {
                    this.setString(parameterIndex, bd.toString());
                    return;
                }
                default: {
                    throw SQLExceptionMapper.getSQLException("Could not convert [" + bd + "] to " + targetSqlType);
                }
            }
        } else if (x instanceof byte[]) {
            if (targetSqlType != -2 && targetSqlType != -3 && targetSqlType != -4) throw SQLExceptionMapper.getSQLException("Can only convert a byte[] to BINARY, VARBINARY or LONGVARBINARY");
            this.setBytes(parameterIndex, (byte[])x);
            return;
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
            return;
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
            return;
        } else if (x instanceof java.util.Date) {
            long t = ((java.util.Date)x).getTime();
            if (targetSqlType == 91) {
                this.setDate(parameterIndex, new Date(t));
                return;
            } else if (targetSqlType == 92) {
                this.setTime(parameterIndex, new Time(t));
                return;
            } else {
                if (targetSqlType != 93) return;
                this.setTimestamp(parameterIndex, new Timestamp(t));
            }
            return;
        } else if (x instanceof Boolean) {
            this.testNumbers(targetSqlType);
            this.setBoolean(parameterIndex, (Boolean)x);
            return;
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
            return;
        } else {
            if (!(x instanceof BigInteger)) throw SQLExceptionMapper.getSQLException("Could not set parameter in setObject, could not convert: " + x.getClass() + " to " + targetSqlType);
            this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)x));
        }
    }

    private void testNumbers(int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: {
                throw SQLExceptionMapper.getSQLException("Cannot convert to " + targetSqlType);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 4);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof java.util.Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)x).getTime()));
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof BigInteger) {
            this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)x));
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else {
            try {
                this.setParameter(parameterIndex, new SerializableParameter(x, this.connection.noBackslashEscapes));
            }
            catch (IOException e) {
                throw SQLExceptionMapper.getSQLException("Could not set serializable parameter in setObject: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void setInt(int column, int i) throws SQLException {
        this.setParameter(column, new IntParameter(i));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, new LongParameter(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, new DoubleParameter(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, new DoubleParameter(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -5);
            return;
        }
        this.setParameter(parameterIndex, new BigDecimalParameter(x));
    }

    @Override
    public void close() throws SQLException {
        this.connection.lock.writeLock().lock();
        try {
            super.close();
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.isClosed = false;
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.connection.lock.writeLock().unlock();
        }
    }

    public String toString() {
        return this.dQuery.toString();
    }
}

