/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.packet.CommandPacket;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.query.Query;

public class StreamedQueryPacket
implements CommandPacket {
    private List<Query> queries;
    private boolean isRewritable;
    private int rewriteOffset;

    public StreamedQueryPacket(List<Query> queries, boolean isRewritable, int rewriteOffset) {
        this.queries = queries;
        this.isRewritable = isRewritable;
        this.rewriteOffset = rewriteOffset;
    }

    @Override
    public int send(OutputStream ostream) throws IOException, QueryException {
        if (this.queries.size() == 1) {
            PacketOutputStream pos = (PacketOutputStream)ostream;
            pos.startPacket(0);
            pos.write(3);
            this.queries.get(0).writeTo(ostream);
            pos.finishPacket();
        } else {
            PacketOutputStream pos = (PacketOutputStream)ostream;
            pos.startPacket(0);
            pos.write(3);
            this.queries.get(0).writeTo(ostream);
            for (int i = 1; i < this.queries.size(); ++i) {
                if (this.isRewritable) {
                    this.queries.get(i).writeToRewritablePart(ostream, this.rewriteOffset);
                    continue;
                }
                pos.write(59);
                this.queries.get(i).writeTo(ostream);
            }
            pos.finishPacket();
        }
        return 0;
    }
}

