/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.gem.ConditionGem;
import org.mapstruct.ap.internal.gem.ConditionStrategyGem;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class ConditionOptions {
    private final Set<ConditionStrategyGem> conditionStrategies;

    private ConditionOptions(Set<ConditionStrategyGem> conditionStrategies) {
        this.conditionStrategies = conditionStrategies;
    }

    public Collection<ConditionStrategyGem> getConditionStrategies() {
        return this.conditionStrategies;
    }

    public static ConditionOptions getInstanceOn(ConditionGem condition, ExecutableElement method, List<Parameter> parameters, FormattingMessager messager) {
        Set strategies;
        if (condition == null) {
            return null;
        }
        TypeMirror returnType = method.getReturnType();
        TypeKind returnTypeKind = returnType.getKind();
        if (returnTypeKind != TypeKind.BOOLEAN) {
            if (returnTypeKind != TypeKind.DECLARED) {
                return null;
            }
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement returnTypeElement = (TypeElement)declaredType.asElement();
            if (!returnTypeElement.getQualifiedName().contentEquals(Boolean.class.getCanonicalName())) {
                return null;
            }
        }
        if ((strategies = (Set)condition.appliesTo().get().stream().map(ConditionStrategyGem::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(ConditionStrategyGem.class)))).isEmpty()) {
            messager.printMessage((Element)method, condition.mirror(), condition.appliesTo().getAnnotationValue(), Message.CONDITION_MISSING_APPLIES_TO_STRATEGY, new Object[0]);
            return null;
        }
        boolean allStrategiesValid = true;
        for (ConditionStrategyGem strategy : strategies) {
            boolean isStrategyValid = ConditionOptions.isValid(strategy, condition, method, parameters, messager);
            allStrategiesValid &= isStrategyValid;
        }
        return allStrategiesValid ? new ConditionOptions(strategies) : null;
    }

    protected static boolean isValid(ConditionStrategyGem strategy, ConditionGem condition, ExecutableElement method, List<Parameter> parameters, FormattingMessager messager) {
        if (strategy == ConditionStrategyGem.SOURCE_PARAMETERS) {
            return ConditionOptions.hasValidStrategyForSourceProperties(condition, method, parameters, messager);
        }
        if (strategy == ConditionStrategyGem.PROPERTIES) {
            return ConditionOptions.hasValidStrategyForProperties(condition, method, parameters, messager);
        }
        throw new IllegalStateException("Invalid condition strategy: " + (Object)((Object)strategy));
    }

    protected static boolean hasValidStrategyForSourceProperties(ConditionGem condition, ExecutableElement method, List<Parameter> parameters, FormattingMessager messager) {
        for (Parameter parameter : parameters) {
            if (parameter.isSourceParameter() || parameter.isMappingContext()) continue;
            messager.printMessage((Element)method, condition.mirror(), Message.CONDITION_SOURCE_PARAMETERS_INVALID_PARAMETER, parameter.describe());
            return false;
        }
        return true;
    }

    protected static boolean hasValidStrategyForProperties(ConditionGem condition, ExecutableElement method, List<Parameter> parameters, FormattingMessager messager) {
        for (Parameter parameter : parameters) {
            if (parameter.isSourceParameter() || parameter.isMappingContext() || parameter.isTargetType() || parameter.isMappingTarget() || parameter.isSourcePropertyName() || parameter.isTargetPropertyName()) continue;
            messager.printMessage((Element)method, condition.mirror(), Message.CONDITION_PROPERTIES_INVALID_PARAMETER, parameter);
            return false;
        }
        return true;
    }
}

