/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.common.BuilderType;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelectors;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionContext;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;

public class ObjectFactoryMethodResolver {
    private ObjectFactoryMethodResolver() {
    }

    public static MethodReference getFactoryMethod(Method method, SelectionParameters selectionParameters, MappingBuilderContext ctx) {
        return ObjectFactoryMethodResolver.getFactoryMethod(method, method.getResultType(), selectionParameters, ctx);
    }

    public static MethodReference getFactoryMethod(Method method, Type alternativeTarget, SelectionParameters selectionParameters, MappingBuilderContext ctx) {
        List<SelectedMethod<SourceMethod>> matchingFactoryMethods = ObjectFactoryMethodResolver.getMatchingFactoryMethods(method, alternativeTarget, selectionParameters, ctx);
        if (matchingFactoryMethods.isEmpty()) {
            return null;
        }
        if (matchingFactoryMethods.size() > 1) {
            ctx.getMessager().printMessage((Element)method.getExecutable(), Message.GENERAL_AMBIGUOUS_FACTORY_METHOD, alternativeTarget.describe(), matchingFactoryMethods.stream().map(SelectedMethod::getMethod).map(Method::describe).collect(Collectors.joining(", ")));
            return null;
        }
        SelectedMethod<SourceMethod> matchingFactoryMethod = Collections.first(matchingFactoryMethods);
        return ObjectFactoryMethodResolver.getFactoryMethodReference(method, matchingFactoryMethod, ctx);
    }

    public static MethodReference getFactoryMethodReference(Method method, SelectedMethod<SourceMethod> matchingFactoryMethod, MappingBuilderContext ctx) {
        Parameter providingParameter = method.getContextProvidedMethods().getParameterForProvidedMethod(matchingFactoryMethod.getMethod());
        if (providingParameter != null) {
            return MethodReference.forParameterProvidedMethod(matchingFactoryMethod.getMethod(), providingParameter, matchingFactoryMethod.getParameterBindings());
        }
        MapperReference ref = MapperReference.findMapperReference(ctx.getMapperReferences(), matchingFactoryMethod.getMethod());
        return MethodReference.forMapperReference(matchingFactoryMethod.getMethod(), ref, matchingFactoryMethod.getParameterBindings());
    }

    public static List<SelectedMethod<SourceMethod>> getMatchingFactoryMethods(Method method, Type alternativeTarget, SelectionParameters selectionParameters, MappingBuilderContext ctx) {
        MethodSelectors selectors = new MethodSelectors(ctx.getTypeUtils(), ctx.getElementUtils(), ctx.getMessager());
        return selectors.getMatchingMethods(ObjectFactoryMethodResolver.getAllAvailableMethods(method, ctx.getSourceModel()), SelectionContext.forFactoryMethods(method, alternativeTarget, selectionParameters, ctx.getTypeFactory()));
    }

    public static MethodReference getBuilderFactoryMethod(Method method, BuilderType builder) {
        return ObjectFactoryMethodResolver.getBuilderFactoryMethod(method.getReturnType(), builder);
    }

    public static MethodReference getBuilderFactoryMethod(Type typeToBuild, BuilderType builder) {
        if (builder == null) {
            return null;
        }
        ExecutableElement builderCreationMethod = builder.getBuilderCreationMethod();
        if (builderCreationMethod.getKind() == ElementKind.CONSTRUCTOR) {
            return null;
        }
        if (!builder.getBuildingType().isAssignableTo(typeToBuild)) {
            return null;
        }
        return MethodReference.forStaticBuilder(builderCreationMethod.getSimpleName().toString(), builder.getOwningType());
    }

    private static List<SourceMethod> getAllAvailableMethods(Method method, List<SourceMethod> sourceModelMethods) {
        ParameterProvidedMethods contextProvidedMethods = method.getContextProvidedMethods();
        if (contextProvidedMethods.isEmpty()) {
            return sourceModelMethods;
        }
        List<SourceMethod> methodsProvidedByParams = contextProvidedMethods.getAllProvidedMethodsInParameterOrder(method.getContextParameters());
        ArrayList<SourceMethod> availableMethods = new ArrayList<SourceMethod>(methodsProvidedByParams.size() + sourceModelMethods.size());
        for (SourceMethod methodProvidedByParams : methodsProvidedByParams) {
            if (!methodProvidedByParams.hasObjectFactoryAnnotation()) continue;
            availableMethods.add(methodProvidedByParams);
        }
        availableMethods.addAll(sourceModelMethods);
        return availableMethods;
    }
}

