/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.spi;

import java.util.Collection;
import javax.lang.model.element.ExecutableElement;

public class BuilderInfo {
    private final ExecutableElement builderCreationMethod;
    private final Collection<ExecutableElement> buildMethods;

    private BuilderInfo(ExecutableElement builderCreationMethod, Collection<ExecutableElement> buildMethods) {
        this.builderCreationMethod = builderCreationMethod;
        this.buildMethods = buildMethods;
    }

    public ExecutableElement getBuilderCreationMethod() {
        return this.builderCreationMethod;
    }

    public Collection<ExecutableElement> getBuildMethods() {
        return this.buildMethods;
    }

    public static class Builder {
        private ExecutableElement builderCreationMethod;
        private Collection<ExecutableElement> buildMethods;

        public Builder builderCreationMethod(ExecutableElement method) {
            this.builderCreationMethod = method;
            return this;
        }

        public Builder buildMethod(Collection<ExecutableElement> methods) {
            this.buildMethods = methods;
            return this;
        }

        public BuilderInfo build() {
            if (this.builderCreationMethod == null) {
                throw new IllegalArgumentException("Builder creation method is mandatory");
            }
            if (this.buildMethods == null) {
                throw new IllegalArgumentException("Build methods are mandatory");
            }
            if (this.buildMethods.isEmpty()) {
                throw new IllegalArgumentException("Build methods must not be empty");
            }
            return new BuilderInfo(this.builderCreationMethod, this.buildMethods);
        }
    }
}

