/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.gem.DecoratedWithGem;
import org.mapstruct.ap.internal.model.DecoratorConstructor;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.GeneratedType;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.version.VersionInformation;

public class Decorator
extends GeneratedType {
    private final Type decoratorType;
    private final Type mapperType;

    private Decorator(TypeFactory typeFactory, String packageName, String name, Type decoratorType, Type mapperType, List<MappingMethod> methods, Options options, VersionInformation versionInformation, Accessibility accessibility, SortedSet<Type> extraImports, DecoratorConstructor decoratorConstructor) {
        super(typeFactory, packageName, name, decoratorType, methods, Arrays.asList(new Field(mapperType, "delegate", true)), options, versionInformation, accessibility, extraImports, decoratorConstructor);
        this.decoratorType = decoratorType;
        this.mapperType = mapperType;
    }

    @Override
    public SortedSet<Type> getImportTypes() {
        Set importTypes = super.getImportTypes();
        if (this.decoratorType.getPackageName().equalsIgnoreCase(this.getPackageName())) {
            if (this.decoratorType.getTypeElement() != null && this.decoratorType.getTypeElement().getNestingKind().isNested()) {
                importTypes.add(this.decoratorType);
            }
        } else {
            importTypes.add(this.decoratorType);
        }
        return importTypes;
    }

    @Override
    protected String getTemplateName() {
        return this.getTemplateNameForClass(GeneratedType.class);
    }

    public Type getMapperType() {
        return this.mapperType;
    }

    public static class Builder
    extends GeneratedType.GeneratedTypeBuilder<Builder> {
        private TypeElement mapperElement;
        private DecoratedWithGem decorator;
        private boolean hasDelegateConstructor;
        private String implName;
        private String implPackage;

        public Builder() {
            super(Builder.class);
        }

        public Builder mapperElement(TypeElement mapperElement) {
            this.mapperElement = mapperElement;
            return this;
        }

        public Builder decoratedWith(DecoratedWithGem decoratedGem) {
            this.decorator = decoratedGem;
            return this;
        }

        public Builder hasDelegateConstructor(boolean hasDelegateConstructor) {
            this.hasDelegateConstructor = hasDelegateConstructor;
            return this;
        }

        public Builder implName(String implName) {
            this.implName = "default".equals(implName) ? "<CLASS_NAME>Impl" : implName;
            return this;
        }

        public Builder implPackage(String implPackage) {
            this.implPackage = "default".equals(implPackage) ? "<PACKAGE_NAME>" : implPackage;
            return this;
        }

        public Decorator build() {
            String implementationName = this.implName.replace("<CLASS_NAME>", Mapper.getFlatName(this.mapperElement));
            Type decoratorType = this.typeFactory.getType(this.decorator.value().get());
            DecoratorConstructor decoratorConstructor = new DecoratorConstructor(implementationName, implementationName + "_", this.hasDelegateConstructor);
            Type mapperType = this.typeFactory.getType(this.mapperElement);
            String elementPackage = mapperType.getPackageName();
            String packageName = this.implPackage.replace("<PACKAGE_NAME>", elementPackage);
            return new Decorator(this.typeFactory, packageName, implementationName, decoratorType, mapperType, this.methods, this.options, this.versionInformation, Accessibility.fromModifiers(this.mapperElement.getModifiers()), this.extraImportedTypes, decoratorConstructor);
        }
    }
}

