/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Set;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.HelperMethod;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.SupportingConstructorFragment;
import org.mapstruct.ap.internal.model.SupportingField;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInFieldReference;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.internal.util.Strings;

public class SupportingMappingMethod
extends MappingMethod {
    private final String templateName;
    private final Set<Type> importTypes;
    private final Field supportingField;
    private final SupportingConstructorFragment supportingConstructorFragment;

    public SupportingMappingMethod(BuiltInMethod method, Set<Field> existingFields) {
        super(method);
        this.importTypes = method.getImportTypes();
        this.templateName = this.getTemplateNameForClass(method.getClass());
        this.supportingField = method.getFieldReference() != null ? this.getSafeField(method.getFieldReference(), existingFields) : null;
        this.supportingConstructorFragment = method.getConstructorFragment() != null ? new SupportingConstructorFragment(this, method.getConstructorFragment()) : null;
    }

    private Field getSafeField(BuiltInFieldReference ref, Set<Field> existingFields) {
        SupportingField result = null;
        String name = ref.getVariableName();
        for (Field existingField : existingFields) {
            if (!existingField.getType().equals(ref.getType())) continue;
            return existingField;
        }
        for (Field existingField : existingFields) {
            if (!existingField.getVariableName().equals(ref.getVariableName())) continue;
            name = Strings.getSafeVariableName(name, Field.getFieldNames(existingFields));
        }
        if (result == null) {
            result = new SupportingField(this, ref, name);
        }
        return result;
    }

    public SupportingMappingMethod(HelperMethod method) {
        super(method);
        this.importTypes = method.getImportTypes();
        this.templateName = this.getTemplateNameForClass(method.getClass());
        this.supportingField = null;
        this.supportingConstructorFragment = null;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public Set<Type> getImportTypes() {
        return this.importTypes;
    }

    public Type findType(String name) {
        for (Type type : this.importTypes) {
            if (type.getFullyQualifiedName().contentEquals(name)) {
                return type;
            }
            if (!type.getName().contentEquals(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("No type for given name '" + name + "' found in 'importTypes'.");
    }

    public Field getSupportingField() {
        return this.supportingField;
    }

    public SupportingConstructorFragment getSupportingConstructorFragment() {
        return this.supportingConstructorFragment;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.templateName == null ? 0 : this.templateName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportingMappingMethod other = (SupportingMappingMethod)obj;
        return !(this.templateName == null ? other.templateName != null : !this.templateName.equals(other.templateName));
    }
}

