/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import org.mapstruct.ap.spi.BuilderInfo;
import org.mapstruct.ap.spi.BuilderProvider;
import org.mapstruct.ap.spi.MoreThanOneBuilderCreationMethodException;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class DefaultBuilderProvider
implements BuilderProvider {
    private static final Pattern JAVA_JAVAX_PACKAGE = Pattern.compile("^javax?\\..*");

    @Override
    public BuilderInfo findBuilderInfo(TypeMirror type, Elements elements, Types types) {
        TypeElement typeElement = this.getTypeElement(type);
        if (typeElement == null) {
            return null;
        }
        return this.findBuilderInfo(typeElement, elements, types);
    }

    protected TypeElement getTypeElement(TypeMirror type) {
        if (type.getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(type);
        }
        DeclaredType declaredType = type.accept(new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        if (declaredType == null) {
            return null;
        }
        return declaredType.asElement().accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    protected BuilderInfo findBuilderInfo(TypeElement typeElement, Elements elements, Types types) {
        if (this.shouldIgnore(typeElement)) {
            return null;
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        ArrayList<BuilderInfo> builderInfo = new ArrayList<BuilderInfo>();
        for (ExecutableElement method : methods) {
            TypeElement builderElement;
            Collection<ExecutableElement> buildMethods;
            if (!this.isPossibleBuilderCreationMethod(method, typeElement, types) || (buildMethods = this.findBuildMethods(builderElement = this.getTypeElement(method.getReturnType()), typeElement, types)).isEmpty()) continue;
            builderInfo.add(new BuilderInfo.Builder().builderCreationMethod(method).buildMethod(buildMethods).build());
        }
        if (builderInfo.size() == 1) {
            return (BuilderInfo)builderInfo.get(0);
        }
        if (builderInfo.size() > 1) {
            throw new MoreThanOneBuilderCreationMethodException(typeElement.asType(), builderInfo);
        }
        return this.findBuilderInfo(typeElement.getSuperclass(), elements, types);
    }

    protected boolean isPossibleBuilderCreationMethod(ExecutableElement method, TypeElement typeElement, Types types) {
        return method.getParameters().isEmpty() && method.getModifiers().contains((Object)Modifier.PUBLIC) && method.getModifiers().contains((Object)Modifier.STATIC) && !types.isSameType(method.getReturnType(), typeElement.asType());
    }

    protected Collection<ExecutableElement> findBuildMethods(TypeElement builderElement, TypeElement typeElement, Types types) {
        if (this.shouldIgnore(builderElement)) {
            return Collections.emptyList();
        }
        List<ExecutableElement> builderMethods = ElementFilter.methodsIn(builderElement.getEnclosedElements());
        ArrayList<ExecutableElement> buildMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement buildMethod : builderMethods) {
            if (!this.isBuildMethod(buildMethod, typeElement, types)) continue;
            buildMethods.add(buildMethod);
        }
        if (buildMethods.isEmpty()) {
            return this.findBuildMethods(this.getTypeElement(builderElement.getSuperclass()), typeElement, types);
        }
        return buildMethods;
    }

    protected boolean isBuildMethod(ExecutableElement buildMethod, TypeElement typeElement, Types types) {
        return buildMethod.getParameters().isEmpty() && buildMethod.getModifiers().contains((Object)Modifier.PUBLIC) && types.isAssignable(buildMethod.getReturnType(), typeElement.asType());
    }

    protected boolean shouldIgnore(TypeElement typeElement) {
        return typeElement == null || JAVA_JAVAX_PACKAGE.matcher(typeElement.getQualifiedName()).matches();
    }
}

