/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.prism.BeanMappingPrism;
import org.mapstruct.ap.internal.prism.BuilderPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.ReportingPolicyPrism;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class BeanMapping {
    private final SelectionParameters selectionParameters;
    private final NullValueMappingStrategyPrism nullValueMappingStrategy;
    private final ReportingPolicyPrism reportingPolicy;
    private final boolean ignoreByDefault;
    private final List<String> ignoreUnmappedSourceProperties;
    private final BuilderPrism builder;

    public static BeanMapping forInheritance(BeanMapping map) {
        return new BeanMapping(map.selectionParameters, map.nullValueMappingStrategy, map.reportingPolicy, false, map.ignoreUnmappedSourceProperties, map.builder);
    }

    public static BeanMapping fromPrism(BeanMappingPrism beanMapping, ExecutableElement method, FormattingMessager messager, Types typeUtils) {
        if (beanMapping == null) {
            return null;
        }
        boolean resultTypeIsDefined = !TypeKind.VOID.equals((Object)beanMapping.resultType().getKind());
        NullValueMappingStrategyPrism nullValueMappingStrategy = null == beanMapping.values.nullValueMappingStrategy() ? null : NullValueMappingStrategyPrism.valueOf(beanMapping.nullValueMappingStrategy());
        boolean ignoreByDefault = beanMapping.ignoreByDefault();
        BuilderPrism builderMapping = null;
        if (beanMapping.values.builder() != null) {
            builderMapping = beanMapping.builder();
        }
        if (!resultTypeIsDefined && beanMapping.qualifiedBy().isEmpty() && beanMapping.qualifiedByName().isEmpty() && beanMapping.ignoreUnmappedSourceProperties().isEmpty() && nullValueMappingStrategy == null && !ignoreByDefault && builderMapping == null) {
            messager.printMessage((Element)method, Message.BEANMAPPING_NO_ELEMENTS, new Object[0]);
        }
        SelectionParameters cmp = new SelectionParameters(beanMapping.qualifiedBy(), beanMapping.qualifiedByName(), resultTypeIsDefined ? beanMapping.resultType() : null, typeUtils);
        return new BeanMapping(cmp, nullValueMappingStrategy, null, ignoreByDefault, beanMapping.ignoreUnmappedSourceProperties(), builderMapping);
    }

    public static BeanMapping forForgedMethods() {
        return new BeanMapping(null, null, ReportingPolicyPrism.IGNORE, false, Collections.<String>emptyList(), null);
    }

    private BeanMapping(SelectionParameters selectionParameters, NullValueMappingStrategyPrism nvms, ReportingPolicyPrism reportingPolicy, boolean ignoreByDefault, List<String> ignoreUnmappedSourceProperties, BuilderPrism builder) {
        this.selectionParameters = selectionParameters;
        this.nullValueMappingStrategy = nvms;
        this.reportingPolicy = reportingPolicy;
        this.ignoreByDefault = ignoreByDefault;
        this.ignoreUnmappedSourceProperties = ignoreUnmappedSourceProperties;
        this.builder = builder;
    }

    public SelectionParameters getSelectionParameters() {
        return this.selectionParameters;
    }

    public NullValueMappingStrategyPrism getNullValueMappingStrategy() {
        return this.nullValueMappingStrategy;
    }

    public ReportingPolicyPrism getReportingPolicy() {
        return this.reportingPolicy;
    }

    public boolean isignoreByDefault() {
        return this.ignoreByDefault;
    }

    public List<String> getIgnoreUnmappedSourceProperties() {
        return this.ignoreUnmappedSourceProperties;
    }

    public BuilderPrism getBuilder() {
        return this.builder;
    }
}

