/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import org.mapstruct.ap.internal.model.AbstractBaseBuilder;
import org.mapstruct.ap.internal.model.CollectionAssignmentBuilder;
import org.mapstruct.ap.internal.model.ContainerMappingMethod;
import org.mapstruct.ap.internal.model.ContainerMappingMethodBuilder;
import org.mapstruct.ap.internal.model.IterableMappingMethod;
import org.mapstruct.ap.internal.model.MapMappingMethod;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NestedPropertyMappingMethod;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.StreamMappingMethod;
import org.mapstruct.ap.internal.model.assignment.AdderWrapper;
import org.mapstruct.ap.internal.model.assignment.ArrayCopyWrapper;
import org.mapstruct.ap.internal.model.assignment.EnumConstantWrapper;
import org.mapstruct.ap.internal.model.assignment.GetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.SetterWrapper;
import org.mapstruct.ap.internal.model.assignment.UpdateWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.prism.NullValueCheckStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.ValueProvider;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class PropertyMapping
extends ModelElement {
    private final String name;
    private final String sourceBeanName;
    private final String targetWriteAccessorName;
    private final ValueProvider targetReadAccessorProvider;
    private final Type targetType;
    private final Assignment assignment;
    private final List<String> dependsOn;
    private final Assignment defaultValueAssignment;

    private PropertyMapping(String name, String targetWriteAccessorName, ValueProvider targetReadAccessorProvider, Type targetType, Assignment propertyAssignment, List<String> dependsOn, Assignment defaultValueAssignment) {
        this(name, null, targetWriteAccessorName, targetReadAccessorProvider, targetType, propertyAssignment, dependsOn, defaultValueAssignment);
    }

    private PropertyMapping(String name, String sourceBeanName, String targetWriteAccessorName, ValueProvider targetReadAccessorProvider, Type targetType, Assignment assignment, List<String> dependsOn, Assignment defaultValueAssignment) {
        this.name = name;
        this.sourceBeanName = sourceBeanName;
        this.targetWriteAccessorName = targetWriteAccessorName;
        this.targetReadAccessorProvider = targetReadAccessorProvider;
        this.targetType = targetType;
        this.assignment = assignment;
        this.dependsOn = dependsOn != null ? dependsOn : java.util.Collections.emptyList();
        this.defaultValueAssignment = defaultValueAssignment;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public String getTargetWriteAccessorName() {
        return this.targetWriteAccessorName;
    }

    public String getTargetReadAccessorName() {
        return this.targetReadAccessorProvider == null ? null : this.targetReadAccessorProvider.getValue();
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public Assignment getDefaultValueAssignment() {
        return this.defaultValueAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        if (this.defaultValueAssignment == null) {
            return this.assignment.getImportTypes();
        }
        return Collections.asSet(this.assignment.getImportTypes(), new Collection[]{this.defaultValueAssignment.getImportTypes()});
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 67 * hash + (this.targetType != null ? this.targetType.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyMapping other = (PropertyMapping)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.targetType == other.targetType || this.targetType != null && this.targetType.equals(other.targetType);
    }

    public String toString() {
        return "PropertyMapping {\n    name='" + this.name + "',\n    targetWriteAccessorName='" + this.targetWriteAccessorName + "',\n    targetReadAccessorName='" + this.getTargetReadAccessorName() + "',\n    targetType=" + this.targetType + ",\n    propertyAssignment=" + this.assignment + ",\n    defaultValueAssignment=" + this.defaultValueAssignment + ",\n    dependsOn=" + this.dependsOn + "\n}";
    }

    public static class JavaExpressionMappingBuilder
    extends MappingBuilderBase<JavaExpressionMappingBuilder> {
        private String javaExpression;

        JavaExpressionMappingBuilder() {
            super(JavaExpressionMappingBuilder.class);
        }

        public JavaExpressionMappingBuilder javaExpression(String javaExpression) {
            this.javaExpression = javaExpression;
            return this;
        }

        public PropertyMapping build() {
            ModelElement assignment = new SourceRHS(this.javaExpression, null, this.existingVariableNames, "");
            assignment = this.ctx.getAccessorNaming().isSetterMethod(this.targetWriteAccessor) || Executables.isFieldAccessor(this.targetWriteAccessor) ? new SetterWrapper((Assignment)((Object)assignment), this.method.getThrownTypes(), this.isFieldAssignment()) : new GetterWrapperForCollectionsAndMaps((Assignment)((Object)assignment), this.method.getThrownTypes(), this.targetType, this.isFieldAssignment());
            return new PropertyMapping(this.targetPropertyName, this.targetWriteAccessor.getSimpleName().toString(), ValueProvider.of(this.targetReadAccessor), this.targetType, (Assignment)((Object)assignment), this.dependsOn, null);
        }
    }

    public static class ConstantMappingBuilder
    extends MappingBuilderBase<ConstantMappingBuilder> {
        private String constantExpression;
        private FormattingParameters formattingParameters;
        private SelectionParameters selectionParameters;

        ConstantMappingBuilder() {
            super(ConstantMappingBuilder.class);
        }

        public ConstantMappingBuilder constantExpression(String constantExpression) {
            this.constantExpression = constantExpression;
            return this;
        }

        public ConstantMappingBuilder formattingParameters(FormattingParameters formattingParameters) {
            this.formattingParameters = formattingParameters;
            return this;
        }

        public ConstantMappingBuilder selectionParameters(SelectionParameters selectionParameters) {
            this.selectionParameters = selectionParameters;
            return this;
        }

        public PropertyMapping build() {
            String sourceErrorMessagePart = "constant '" + this.constantExpression + "'";
            String errorMessageDetails = null;
            Class<Object> baseForLiteral = null;
            try {
                baseForLiteral = NativeTypes.getLiteral(this.targetType.getFullyQualifiedName(), this.constantExpression);
            }
            catch (IllegalArgumentException ex) {
                errorMessageDetails = ex.getMessage();
            }
            if (baseForLiteral == null) {
                this.constantExpression = "\"" + this.constantExpression + "\"";
                baseForLiteral = String.class;
            }
            Type sourceType = this.ctx.getTypeFactory().getTypeForLiteral(baseForLiteral);
            Assignment assignment = null;
            assignment = !this.targetType.isEnumType() ? this.ctx.getMappingResolver().getTargetAssignment(this.method, this.targetType, this.targetPropertyName, this.formattingParameters, this.selectionParameters, new SourceRHS(this.constantExpression, sourceType, this.existingVariableNames, sourceErrorMessagePart), this.method.getMappingTargetParameter() != null) : this.getEnumAssignment();
            if (assignment != null) {
                if (this.ctx.getAccessorNaming().isSetterMethod(this.targetWriteAccessor) || Executables.isFieldAccessor(this.targetWriteAccessor)) {
                    if (assignment.isCallingUpdateMethod()) {
                        if (this.targetReadAccessor == null) {
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.CONSTANTMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                        }
                        boolean mapNullToDefault = this.method.getMapperConfiguration().getNullValueMappingStrategy() == NullValueMappingStrategyPrism.RETURN_DEFAULT;
                        MethodReference factoryMethod = ObjectFactoryMethodResolver.getFactoryMethod(this.method, this.targetType, null, this.ctx);
                        assignment = new UpdateWrapper(assignment, this.method.getThrownTypes(), factoryMethod, this.isFieldAssignment(), this.targetType, false, mapNullToDefault);
                    } else {
                        assignment = new SetterWrapper(assignment, this.method.getThrownTypes(), this.isFieldAssignment());
                    }
                } else {
                    assignment = new GetterWrapperForCollectionsAndMaps(assignment, this.method.getThrownTypes(), this.targetType, this.isFieldAssignment());
                }
            } else if (errorMessageDetails == null) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.mirror, Message.CONSTANTMAPPING_MAPPING_NOT_FOUND, sourceType, this.constantExpression, this.targetType, this.targetPropertyName);
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.mirror, Message.CONSTANTMAPPING_MAPPING_NOT_FOUND_WITH_DETAILS, sourceType, this.constantExpression, this.targetType, this.targetPropertyName, errorMessageDetails);
            }
            return new PropertyMapping(this.targetPropertyName, this.targetWriteAccessor.getSimpleName().toString(), ValueProvider.of(this.targetReadAccessor), this.targetType, assignment, this.dependsOn, null);
        }

        private Assignment getEnumAssignment() {
            ModelElement assignment = null;
            String enumExpression = this.constantExpression.substring(1, this.constantExpression.length() - 1);
            if (this.targetType.getEnumConstants().contains(enumExpression)) {
                String sourceErrorMessagePart = "constant '" + this.constantExpression + "'";
                assignment = new SourceRHS(enumExpression, this.targetType, this.existingVariableNames, sourceErrorMessagePart);
                assignment = new EnumConstantWrapper((Assignment)((Object)assignment), this.targetType);
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.CONSTANTMAPPING_NON_EXISTING_CONSTANT, this.constantExpression, this.targetType, this.targetPropertyName);
            }
            return assignment;
        }
    }

    public static class PropertyMappingBuilder
    extends MappingBuilderBase<PropertyMappingBuilder> {
        private String defaultValue;
        private String defaultJavaExpression;
        private SourceReference sourceReference;
        private SourceRHS rightHandSide;
        private FormattingParameters formattingParameters;
        private SelectionParameters selectionParameters;
        private MappingOptions forgeMethodWithMappingOptions;
        private boolean forceUpdateMethod;
        private boolean forgedNamedBased = true;

        PropertyMappingBuilder() {
            super(PropertyMappingBuilder.class);
        }

        public PropertyMappingBuilder sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public PropertyMappingBuilder selectionParameters(SelectionParameters selectionParameters) {
            this.selectionParameters = selectionParameters;
            return this;
        }

        public PropertyMappingBuilder formattingParameters(FormattingParameters formattingParameters) {
            this.formattingParameters = formattingParameters;
            return this;
        }

        public PropertyMappingBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public PropertyMappingBuilder defaultJavaExpression(String defaultJavaExpression) {
            this.defaultJavaExpression = defaultJavaExpression;
            return this;
        }

        public PropertyMappingBuilder forgeMethodWithMappingOptions(MappingOptions mappingOptions) {
            this.forgeMethodWithMappingOptions = mappingOptions;
            return this;
        }

        public PropertyMappingBuilder forceUpdateMethod(boolean forceUpdateMethod) {
            this.forceUpdateMethod = forceUpdateMethod;
            return this;
        }

        public PropertyMappingBuilder forgedNamedBased(boolean forgedNamedBased) {
            this.forgedNamedBased = forgedNamedBased;
            return this;
        }

        public PropertyMapping build() {
            this.rightHandSide = this.getSourceRHS(this.sourceReference);
            this.rightHandSide.setUseElementAsSourceTypeForMatching(this.targetWriteAccessorType == TargetWriteAccessorType.ADDER);
            boolean preferUpdateMethods = this.targetWriteAccessorType == TargetWriteAccessorType.ADDER ? false : this.method.getMappingTargetParameter() != null;
            Assignment assignment = null;
            if (this.forgeMethodWithMappingOptions == null) {
                assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, this.targetType, this.targetPropertyName, this.formattingParameters, this.selectionParameters, this.rightHandSide, preferUpdateMethods);
            }
            Type sourceType = this.rightHandSide.getSourceType();
            if (assignment == null) {
                assignment = (sourceType.isCollectionType() || sourceType.isArrayType()) && this.targetType.isIterableType() ? this.forgeIterableMapping(sourceType, this.targetType, this.rightHandSide, this.method.getExecutable()) : (sourceType.isMapType() && this.targetType.isMapType() ? this.forgeMapMapping(sourceType, this.targetType, this.rightHandSide, this.method.getExecutable()) : (sourceType.isIterableType() && this.targetType.isStreamType() || sourceType.isStreamType() && this.targetType.isStreamType() || sourceType.isStreamType() && this.targetType.isIterableType() ? this.forgeStreamMapping(sourceType, this.targetType, this.rightHandSide, this.method.getExecutable()) : this.forgeMapping(this.rightHandSide)));
            }
            if (assignment != null) {
                assignment = this.targetType.isCollectionOrMapType() ? this.assignToCollection(this.targetType, this.targetWriteAccessorType, assignment) : (this.targetType.isArrayType() && sourceType.isArrayType() && assignment.getType() == Assignment.AssignmentType.DIRECT ? this.assignToArray(this.targetType, assignment) : this.assignToPlain(this.targetType, this.targetWriteAccessorType, assignment));
            } else {
                this.reportCannotCreateMapping();
            }
            return new PropertyMapping(this.targetPropertyName, this.rightHandSide.getSourceParameterName(), this.targetWriteAccessor.getSimpleName().toString(), ValueProvider.of(this.targetReadAccessor), this.targetType, assignment, this.dependsOn, this.getDefaultValueAssignment(assignment));
        }

        private void reportCannotCreateMapping() {
            if (this.method instanceof ForgedMethod && ((ForgedMethod)this.method).getHistory() != null) {
                ForgedMethodHistory history = this.getForgedMethodHistory(this.rightHandSide);
                this.reportCannotCreateMapping(this.method, history.createSourcePropertyErrorMessage(), history.getSourceType(), history.getTargetType(), history.createTargetPropertyName());
            } else {
                this.reportCannotCreateMapping(this.method, this.rightHandSide.getSourceErrorMessagePart(), this.rightHandSide.getSourceType(), this.targetType, this.targetPropertyName);
            }
        }

        private Assignment getDefaultValueAssignment(Assignment rhs) {
            if (!(this.defaultValue == null || rhs.getSourceType().isPrimitive() && rhs.getSourcePresenceCheckerReference() == null)) {
                PropertyMapping build = ((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)new ConstantMappingBuilder().constantExpression(this.defaultValue).formattingParameters(this.formattingParameters).selectionParameters(this.selectionParameters).dependsOn(this.dependsOn)).existingVariableNames(this.existingVariableNames)).mappingContext(this.ctx)).sourceMethod(this.method)).targetPropertyName(this.targetPropertyName)).targetReadAccessor(this.targetReadAccessor)).targetWriteAccessor(this.targetWriteAccessor)).build();
                return build.getAssignment();
            }
            if (!(this.defaultJavaExpression == null || rhs.getSourceType().isPrimitive() && rhs.getSourcePresenceCheckerReference() == null)) {
                PropertyMapping build = ((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)new JavaExpressionMappingBuilder().javaExpression(this.defaultJavaExpression).dependsOn(this.dependsOn)).existingVariableNames(this.existingVariableNames)).mappingContext(this.ctx)).sourceMethod(this.method)).targetPropertyName(this.targetPropertyName)).targetReadAccessor(this.targetReadAccessor)).targetWriteAccessor(this.targetWriteAccessor)).build();
                return build.getAssignment();
            }
            return null;
        }

        private Assignment assignToPlain(Type targetType, TargetWriteAccessorType targetAccessorType, Assignment rightHandSide) {
            Assignment result = targetAccessorType == TargetWriteAccessorType.SETTER || targetAccessorType == TargetWriteAccessorType.FIELD ? this.assignToPlainViaSetter(targetType, rightHandSide) : this.assignToPlainViaAdder(rightHandSide);
            return result;
        }

        private Assignment assignToPlainViaSetter(Type targetType, Assignment rhs) {
            if (rhs.isCallingUpdateMethod()) {
                if (this.targetReadAccessor == null) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                }
                boolean mapNullToDefault = this.method.getMapperConfiguration().getNullValueMappingStrategy() == NullValueMappingStrategyPrism.RETURN_DEFAULT;
                MethodReference factory = ObjectFactoryMethodResolver.getFactoryMethod(this.method, targetType, SelectionParameters.forSourceRHS(this.rightHandSide), this.ctx);
                return new UpdateWrapper(rhs, this.method.getThrownTypes(), factory, this.isFieldAssignment(), targetType, !rhs.isSourceReferenceParameter(), mapNullToDefault);
            }
            NullValueCheckStrategyPrism nvcs = this.method.getMapperConfiguration().getNullValueCheckStrategy();
            return new SetterWrapper(rhs, this.method.getThrownTypes(), nvcs, this.isFieldAssignment(), targetType);
        }

        private Assignment assignToPlainViaAdder(Assignment rightHandSide) {
            Assignment result = rightHandSide;
            result = result.getSourceType().isCollectionType() ? new AdderWrapper(result, this.method.getThrownTypes(), this.isFieldAssignment(), this.targetPropertyName) : new SetterWrapper(result, this.method.getThrownTypes(), NullValueCheckStrategyPrism.ALWAYS, this.isFieldAssignment(), this.targetType);
            return result;
        }

        private Assignment assignToCollection(Type targetType, TargetWriteAccessorType targetAccessorType, Assignment rhs) {
            return new CollectionAssignmentBuilder().mappingBuilderContext(this.ctx).method(this.method).targetReadAccessor(this.targetReadAccessor).targetType(targetType).targetPropertyName(this.targetPropertyName).targetAccessorType(targetAccessorType).rightHandSide(this.rightHandSide).assignment(rhs).build();
        }

        private Assignment assignToArray(Type targetType, Assignment rightHandSide) {
            Type arrayType = this.ctx.getTypeFactory().getType(Arrays.class);
            ArrayCopyWrapper assignment = new ArrayCopyWrapper(rightHandSide, this.targetPropertyName, arrayType, targetType, this.isFieldAssignment());
            return assignment;
        }

        private SourceRHS getSourceRHS(SourceReference sourceReference) {
            Parameter sourceParam = sourceReference.getParameter();
            List<PropertyEntry> propertyEntries = sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return new SourceRHS(sourceParam.getName(), sourceParam.getType(), this.existingVariableNames, sourceReference.toString());
            }
            if (propertyEntries.size() == 1) {
                PropertyEntry propertyEntry = propertyEntries.get(0);
                String sourceRef = sourceParam.getName() + "." + ValueProvider.of(propertyEntry.getReadAccessor());
                return new SourceRHS(sourceParam.getName(), sourceRef, this.getSourcePresenceCheckerRef(sourceReference), propertyEntry.getType(), this.existingVariableNames, sourceReference.toString());
            }
            Type sourceType = Collections.last(propertyEntries).getType();
            if (sourceType.isPrimitive() && !this.targetType.isPrimitive()) {
                sourceType = this.ctx.getTypeFactory().getWrappedType(sourceType);
            }
            MapperConfiguration config = this.method.getMapperConfiguration();
            String forgedName = Strings.joinAndCamelize(sourceReference.getElementNames());
            forgedName = Strings.getSaveVariableName(forgedName, this.ctx.getNamesOfMappingsToGenerate());
            ForgedMethod methodRef = new ForgedMethod(forgedName, sourceReference.getParameter().getType(), sourceType, config, this.method.getExecutable(), java.util.Collections.<Parameter>emptyList(), ParameterProvidedMethods.empty());
            NestedPropertyMappingMethod.Builder builder = new NestedPropertyMappingMethod.Builder();
            NestedPropertyMappingMethod nestedPropertyMapping = builder.method(methodRef).propertyEntries(sourceReference.getPropertyEntries()).mappingContext(this.ctx).build();
            if (!this.ctx.getMappingsToGenerate().contains(nestedPropertyMapping)) {
                this.ctx.getMappingsToGenerate().add(nestedPropertyMapping);
            } else {
                forgedName = this.ctx.getExistingMappingMethod(nestedPropertyMapping).getName();
            }
            String sourceRef = forgedName + "( " + sourceParam.getName() + " )";
            SourceRHS sourceRhs = new SourceRHS(sourceParam.getName(), sourceRef, this.getSourcePresenceCheckerRef(sourceReference), sourceType, this.existingVariableNames, sourceReference.toString());
            String desiredName = Collections.last(sourceReference.getPropertyEntries()).getName();
            sourceRhs.setSourceLocalVarName(sourceRhs.createLocalVarName(desiredName));
            return sourceRhs;
        }

        private String getSourcePresenceCheckerRef(SourceReference sourceReference) {
            String sourcePresenceChecker = null;
            if (!sourceReference.getPropertyEntries().isEmpty()) {
                Parameter sourceParam = sourceReference.getParameter();
                PropertyEntry propertyEntry = Collections.first(sourceReference.getPropertyEntries());
                if (propertyEntry.getPresenceChecker() != null) {
                    sourcePresenceChecker = sourceParam.getName() + "." + propertyEntry.getPresenceChecker().getSimpleName() + "()";
                }
            }
            return sourcePresenceChecker;
        }

        private Assignment forgeStreamMapping(Type sourceType, Type targetType, SourceRHS source, ExecutableElement element) {
            StreamMappingMethod.Builder builder = new StreamMappingMethod.Builder();
            return this.forgeWithElementMapping(sourceType, targetType, source, element, builder);
        }

        private Assignment forgeIterableMapping(Type sourceType, Type targetType, SourceRHS source, ExecutableElement element) {
            IterableMappingMethod.Builder builder = new IterableMappingMethod.Builder();
            return this.forgeWithElementMapping(sourceType, targetType, source, element, builder);
        }

        private Assignment forgeWithElementMapping(Type sourceType, Type targetType, SourceRHS source, ExecutableElement element, ContainerMappingMethodBuilder<?, ? extends ContainerMappingMethod> builder) {
            targetType = targetType.withoutBounds();
            ForgedMethod methodRef = this.prepareForgedMethod(sourceType, targetType, source, element, "[]");
            MappingMethod iterableMappingMethod = ((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)builder.mappingContext(this.ctx)).method(methodRef)).selectionParameters(this.selectionParameters)).callingContextTargetPropertyName(this.targetPropertyName)).build();
            return this.createForgedAssignment(source, methodRef, iterableMappingMethod);
        }

        private ForgedMethod prepareForgedMethod(Type sourceType, Type targetType, SourceRHS source, ExecutableElement element, String suffix) {
            String name = this.getName(sourceType, targetType);
            name = Strings.getSaveVariableName(name, this.ctx.getNamesOfMappingsToGenerate());
            MapperConfiguration config = this.method.getMapperConfiguration();
            return new ForgedMethod(name, sourceType, targetType, config, element, this.method.getContextParameters(), this.method.getContextProvidedMethods(), this.getForgedMethodHistory(source, suffix), null, this.forgedNamedBased);
        }

        private Assignment forgeMapMapping(Type sourceType, Type targetType, SourceRHS source, ExecutableElement element) {
            targetType = targetType.withoutBounds();
            ForgedMethod methodRef = this.prepareForgedMethod(sourceType, targetType, source, element, "{}");
            MapMappingMethod.Builder builder = new MapMappingMethod.Builder();
            MapMappingMethod mapMappingMethod = ((MapMappingMethod.Builder)((MapMappingMethod.Builder)builder.mappingContext(this.ctx)).method(methodRef)).build();
            return this.createForgedAssignment(source, methodRef, mapMappingMethod);
        }

        private Assignment forgeMapping(SourceRHS sourceRHS) {
            Type returnType;
            Type sourceType = sourceRHS.getSourceType();
            if (this.forgedNamedBased && !this.canGenerateAutoSubMappingBetween(sourceType, this.targetType)) {
                return null;
            }
            if (sourceType.isPrimitive() || this.targetType.isPrimitive()) {
                return null;
            }
            String name = this.getName(sourceType, this.targetType);
            name = Strings.getSaveVariableName(name, this.ctx.getNamesOfMappingsToGenerate());
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.method.getContextParameters());
            if (!this.targetType.isEnumType() && (this.method.isUpdateMethod() || this.forceUpdateMethod)) {
                parameters.add(Parameter.forForgedMappingTarget(this.targetType));
                returnType = this.ctx.getTypeFactory().createVoidType();
            } else {
                returnType = this.targetType;
            }
            ForgedMethod forgedMethod = new ForgedMethod(name, sourceType, returnType, this.method.getMapperConfiguration(), this.method.getExecutable(), parameters, this.method.getContextProvidedMethods(), this.getForgedMethodHistory(sourceRHS), this.forgeMethodWithMappingOptions, this.forgedNamedBased);
            return this.createForgedAssignment(sourceRHS, forgedMethod);
        }

        private ForgedMethodHistory getForgedMethodHistory(SourceRHS sourceRHS) {
            return this.getForgedMethodHistory(sourceRHS, "");
        }

        private ForgedMethodHistory getForgedMethodHistory(SourceRHS sourceRHS, String suffix) {
            ForgedMethodHistory history = null;
            if (this.method instanceof ForgedMethod) {
                ForgedMethod method = (ForgedMethod)this.method;
                history = method.getHistory();
            }
            return new ForgedMethodHistory(history, this.getSourceElementName() + suffix, this.targetPropertyName + suffix, sourceRHS.getSourceType(), this.targetType, true, "property");
        }

        private String getName(Type sourceType, Type targetType) {
            String fromName = this.getName(sourceType);
            String toName = this.getName(targetType);
            return Strings.decapitalize(fromName + "To" + toName);
        }

        private String getName(Type type) {
            StringBuilder builder = new StringBuilder();
            for (Type typeParam : type.getTypeParameters()) {
                builder.append(typeParam.getIdentification());
            }
            builder.append(type.getIdentification());
            return builder.toString();
        }

        private String getSourceElementName() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return sourceParam.getName();
            }
            if (propertyEntries.size() == 1) {
                PropertyEntry propertyEntry = propertyEntries.get(0);
                return propertyEntry.getName();
            }
            return Strings.join(this.sourceReference.getElementNames(), ".");
        }
    }

    private static class MappingBuilderBase<T extends MappingBuilderBase<T>>
    extends AbstractBaseBuilder<T> {
        protected Accessor targetWriteAccessor;
        protected TargetWriteAccessorType targetWriteAccessorType;
        protected Type targetType;
        protected Accessor targetReadAccessor;
        protected String targetPropertyName;
        protected List<String> dependsOn;
        protected Set<String> existingVariableNames;
        protected AnnotationMirror mirror;

        MappingBuilderBase(Class<T> selfType) {
            super(selfType);
        }

        public T sourceMethod(Method sourceMethod) {
            return (T)((MappingBuilderBase)super.method(sourceMethod));
        }

        public T targetProperty(PropertyEntry targetProp) {
            this.targetReadAccessor = targetProp.getReadAccessor();
            this.targetWriteAccessor = targetProp.getWriteAccessor();
            this.targetType = targetProp.getType();
            this.targetWriteAccessorType = TargetWriteAccessorType.of(this.ctx.getAccessorNaming(), this.targetWriteAccessor);
            return (T)this;
        }

        public T targetReadAccessor(Accessor targetReadAccessor) {
            this.targetReadAccessor = targetReadAccessor;
            return (T)this;
        }

        public T targetWriteAccessor(Accessor targetWriteAccessor) {
            this.targetWriteAccessor = targetWriteAccessor;
            this.targetWriteAccessorType = TargetWriteAccessorType.of(this.ctx.getAccessorNaming(), targetWriteAccessor);
            this.targetType = this.determineTargetType();
            return (T)this;
        }

        T mirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return (T)this;
        }

        private Type determineTargetType() {
            Type mappingType = this.method.getResultType();
            if (!this.method.isUpdateMethod()) {
                mappingType = mappingType.getEffectiveType();
            }
            DeclaredType resultType = (DeclaredType)mappingType.getTypeMirror();
            switch (this.targetWriteAccessorType) {
                case ADDER: 
                case SETTER: {
                    return this.ctx.getTypeFactory().getSingleParameter(resultType, this.targetWriteAccessor).getType();
                }
            }
            return this.ctx.getTypeFactory().getReturnType(resultType, this.targetWriteAccessor);
        }

        public T targetPropertyName(String targetPropertyName) {
            this.targetPropertyName = targetPropertyName;
            return (T)this;
        }

        public T dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn;
            return (T)this;
        }

        public T existingVariableNames(Set<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return (T)this;
        }

        protected boolean isFieldAssignment() {
            return this.targetWriteAccessorType == TargetWriteAccessorType.FIELD;
        }
    }

    public static enum TargetWriteAccessorType {
        FIELD,
        GETTER,
        SETTER,
        ADDER;


        public static TargetWriteAccessorType of(AccessorNamingUtils accessorNaming, Accessor accessor) {
            if (accessorNaming.isSetterMethod(accessor)) {
                return SETTER;
            }
            if (accessorNaming.isAdderMethod(accessor)) {
                return ADDER;
            }
            if (accessorNaming.isGetterMethod(accessor)) {
                return GETTER;
            }
            return FIELD;
        }

        public static boolean isFieldAssignment(TargetWriteAccessorType accessorType) {
            return accessorType == FIELD;
        }
    }
}

