/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import org.mapstruct.ap.internal.model.common.ConversionContext;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    private static String typeReferenceName(ConversionContext conversionContext, String canonicalName) {
        return conversionContext.getTypeFactory().getType(canonicalName).getReferenceName();
    }

    private static String typeReferenceName(ConversionContext conversionContext, Class<?> type) {
        return conversionContext.getTypeFactory().getType(type).getReferenceName();
    }

    public static String bigDecimal(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, BigDecimal.class);
    }

    public static String bigInteger(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, BigInteger.class);
    }

    public static String locale(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Locale.class);
    }

    public static String currency(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Currency.class);
    }

    public static String sqlDate(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, java.sql.Date.class);
    }

    public static String time(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Time.class);
    }

    public static String timestamp(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Timestamp.class);
    }

    public static String decimalFormat(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, DecimalFormat.class);
    }

    public static String simpleDateFormat(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, SimpleDateFormat.class);
    }

    public static String date(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Date.class);
    }

    public static String zoneOffset(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, "java.time.ZoneOffset");
    }

    public static String zoneId(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, "java.time.ZoneId");
    }

    public static String localDateTime(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, "java.time.LocalDateTime");
    }

    public static String zonedDateTime(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, "java.time.ZonedDateTime");
    }

    public static String dateTimeFormatter(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, "java.time.format.DateTimeFormatter");
    }

    public static String dateTimeFormat(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, "org.joda.time.format.DateTimeFormat");
    }
}

