/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementKindVisitor6;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.prism.MapperPrism;
import org.mapstruct.ap.internal.prism.ReportingPolicyPrism;
import org.mapstruct.ap.internal.processor.DefaultModelElementProcessorContext;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.AnnotationProcessingException;
import org.mapstruct.ap.internal.util.AnnotationProcessorContext;
import org.mapstruct.ap.internal.util.RoundContext;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

@SupportedAnnotationTypes(value={"org.mapstruct.Mapper"})
@SupportedOptions(value={"mapstruct.suppressGeneratorTimestamp", "mapstruct.suppressGeneratorVersionInfoComment", "mapstruct.unmappedTargetPolicy", "mapstruct.defaultComponentModel"})
public class MappingProcessor
extends AbstractProcessor {
    private static final boolean ANNOTATIONS_CLAIMED_EXCLUSIVELY = false;
    protected static final String SUPPRESS_GENERATOR_TIMESTAMP = "mapstruct.suppressGeneratorTimestamp";
    protected static final String SUPPRESS_GENERATOR_VERSION_INFO_COMMENT = "mapstruct.suppressGeneratorVersionInfoComment";
    protected static final String UNMAPPED_TARGET_POLICY = "mapstruct.unmappedTargetPolicy";
    protected static final String DEFAULT_COMPONENT_MODEL = "mapstruct.defaultComponentModel";
    protected static final String ALWAYS_GENERATE_SERVICE_FILE = "mapstruct.alwaysGenerateServicesFile";
    private Options options;
    private AnnotationProcessorContext annotationProcessorContext;
    private Set<TypeElement> deferredMappers = new HashSet<TypeElement>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.options = this.createOptions();
        this.annotationProcessorContext = new AnnotationProcessorContext(processingEnv.getElementUtils());
    }

    private Options createOptions() {
        String unmappedTargetPolicy = this.processingEnv.getOptions().get(UNMAPPED_TARGET_POLICY);
        return new Options(Boolean.valueOf(this.processingEnv.getOptions().get(SUPPRESS_GENERATOR_TIMESTAMP)), Boolean.valueOf(this.processingEnv.getOptions().get(SUPPRESS_GENERATOR_VERSION_INFO_COMMENT)), unmappedTargetPolicy != null ? ReportingPolicyPrism.valueOf(unmappedTargetPolicy.toUpperCase()) : null, this.processingEnv.getOptions().get(DEFAULT_COMPONENT_MODEL), Boolean.valueOf(this.processingEnv.getOptions().get(ALWAYS_GENERATE_SERVICE_FILE)));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (!roundEnvironment.processingOver()) {
            RoundContext roundContext = new RoundContext(this.annotationProcessorContext);
            Set<TypeElement> deferredMappers = this.getAndResetDeferredMappers();
            this.processMapperElements(deferredMappers, roundContext);
            Set<TypeElement> mappers = this.getMappers(annotations, roundEnvironment);
            this.processMapperElements(mappers, roundContext);
        }
        return false;
    }

    private Set<TypeElement> getAndResetDeferredMappers() {
        HashSet<TypeElement> deferred = new HashSet<TypeElement>(this.deferredMappers.size());
        for (TypeElement element : this.deferredMappers) {
            deferred.add(this.processingEnv.getElementUtils().getTypeElement(element.getQualifiedName()));
        }
        this.deferredMappers.clear();
        return deferred;
    }

    private Set<TypeElement> getMappers(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        HashSet<TypeElement> mapperTypes = new HashSet<TypeElement>();
        for (TypeElement typeElement : annotations) {
            if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            try {
                Set<? extends Element> annotatedMappers = roundEnvironment.getElementsAnnotatedWith(typeElement);
                for (Element element : annotatedMappers) {
                    TypeElement mapperTypeElement = this.asTypeElement(element);
                    if (mapperTypeElement == null || MapperPrism.getInstanceOn(mapperTypeElement) == null) continue;
                    mapperTypes.add(mapperTypeElement);
                }
            }
            catch (Throwable t) {
                this.handleUncaughtError(typeElement, t);
            }
        }
        return mapperTypes;
    }

    private void processMapperElements(Set<TypeElement> mapperElements, RoundContext roundContext) {
        for (TypeElement mapperElement : mapperElements) {
            try {
                DefaultModelElementProcessorContext context = new DefaultModelElementProcessorContext(this.processingEnv, this.options, roundContext);
                this.processMapperTypeElement(context, mapperElement);
            }
            catch (TypeHierarchyErroneousException thie) {
                this.deferredMappers.add(mapperElement);
            }
            catch (Throwable t) {
                this.handleUncaughtError(mapperElement, t);
                break;
            }
        }
    }

    private void handleUncaughtError(Element element, Throwable thrown) {
        StringWriter sw = new StringWriter();
        thrown.printStackTrace(new PrintWriter(sw));
        String reportableStacktrace = sw.toString().replace(System.getProperty("line.separator"), "  ");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error in the mapping processor: " + reportableStacktrace, element);
    }

    private void processMapperTypeElement(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement) {
        Object model = null;
        for (ModelElementProcessor<?, ?> processor : this.getProcessors()) {
            try {
                model = this.process(context, processor, mapperTypeElement, model);
            }
            catch (AnnotationProcessingException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement(), e.getAnnotationMirror(), e.getAnnotationValue());
                break;
            }
        }
    }

    private <P, R> R process(ModelElementProcessor.ProcessorContext context, ModelElementProcessor<P, R> processor, TypeElement mapperTypeElement, Object modelElement) {
        Object sourceElement = modelElement;
        return processor.process(context, mapperTypeElement, sourceElement);
    }

    private Iterable<ModelElementProcessor<?, ?>> getProcessors() {
        Iterator<ModelElementProcessor> processorIterator = ServiceLoader.load(ModelElementProcessor.class, MappingProcessor.class.getClassLoader()).iterator();
        ArrayList processors = new ArrayList();
        while (processorIterator.hasNext()) {
            processors.add(processorIterator.next());
        }
        Collections.sort(processors, new ProcessorComparator());
        return processors;
    }

    private TypeElement asTypeElement(Element element) {
        return element.accept(new ElementKindVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitTypeAsInterface(TypeElement e, Void p) {
                return e;
            }

            @Override
            public TypeElement visitTypeAsClass(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    private static class ProcessorComparator
    implements Comparator<ModelElementProcessor<?, ?>> {
        private ProcessorComparator() {
        }

        @Override
        public int compare(ModelElementProcessor<?, ?> o1, ModelElementProcessor<?, ?> o2) {
            return o1.getPriority() < o2.getPriority() ? -1 : (o1.getPriority() == o2.getPriority() ? 0 : 1);
        }
    }
}

