/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.util.NativeTypes;

public class PrimitiveToWrapperConversion
extends SimpleConversion {
    private final Class<?> sourceType;
    private final Class<?> targetType;

    public PrimitiveToWrapperConversion(Class<?> sourceType, Class<?> targetType) {
        if (!sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no primitive type.");
        }
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is no wrapper type.");
        }
        this.sourceType = sourceType;
        this.targetType = NativeTypes.getPrimitiveType(targetType);
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        if (this.sourceType == this.targetType) {
            return "<SOURCE>";
        }
        return "(" + this.targetType.getName() + ") <SOURCE>";
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        return "<SOURCE>." + this.sourceType.getName() + "Value()";
    }
}

