/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Strings;

public class ForgedMethod
implements Method {
    private final List<Parameter> parameters;
    private final Type returnType;
    private final String name;
    private final ExecutableElement positionHintElement;
    private final List<Type> thrownTypes;
    private final MapperConfiguration mapperConfiguration;
    private final ForgedMethodHistory history;
    private final List<Parameter> sourceParameters;
    private final List<Parameter> contextParameters;
    private final Parameter mappingTargetParameter;
    private final MappingOptions mappingOptions;
    private final ParameterProvidedMethods contextProvidedMethods;
    private final boolean forgedNameBased;

    public ForgedMethod(String name, Type sourceType, Type returnType, MapperConfiguration mapperConfiguration, ExecutableElement positionHintElement, List<Parameter> additionalParameters, ParameterProvidedMethods parameterProvidedMethods) {
        this(name, sourceType, returnType, mapperConfiguration, positionHintElement, additionalParameters, parameterProvidedMethods, null, null, false);
    }

    public ForgedMethod(String name, Type sourceType, Type returnType, MapperConfiguration mapperConfiguration, ExecutableElement positionHintElement, List<Parameter> additionalParameters, ParameterProvidedMethods parameterProvidedMethods, ForgedMethodHistory history, MappingOptions mappingOptions, boolean forgedNameBased) {
        String sourceParamName = Strings.decapitalize(sourceType.getName());
        String sourceParamSafeName = Strings.getSaveVariableName(sourceParamName, new String[0]);
        this.parameters = new ArrayList<Parameter>(1 + additionalParameters.size());
        Parameter sourceParameter = new Parameter(sourceParamSafeName, sourceType);
        this.parameters.add(sourceParameter);
        this.parameters.addAll(additionalParameters);
        this.sourceParameters = Parameter.getSourceParameters(this.parameters);
        this.contextParameters = Parameter.getContextParameters(this.parameters);
        this.mappingTargetParameter = Parameter.getMappingTargetParameter(this.parameters);
        this.contextProvidedMethods = parameterProvidedMethods;
        this.returnType = returnType;
        this.thrownTypes = new ArrayList<Type>();
        this.name = Strings.sanitizeIdentifierName(name);
        this.mapperConfiguration = mapperConfiguration;
        this.positionHintElement = positionHintElement;
        this.history = history;
        this.mappingOptions = mappingOptions == null ? MappingOptions.empty() : mappingOptions;
        this.mappingOptions.initWithParameter(sourceParameter);
        this.forgedNameBased = forgedNameBased;
    }

    public ForgedMethod(String name, ForgedMethod forgedMethod) {
        this.parameters = forgedMethod.parameters;
        this.returnType = forgedMethod.returnType;
        this.thrownTypes = new ArrayList<Type>();
        this.mapperConfiguration = forgedMethod.mapperConfiguration;
        this.positionHintElement = forgedMethod.positionHintElement;
        this.history = forgedMethod.history;
        this.sourceParameters = Parameter.getSourceParameters(this.parameters);
        this.contextParameters = Parameter.getContextParameters(this.parameters);
        this.mappingTargetParameter = Parameter.getMappingTargetParameter(this.parameters);
        this.mappingOptions = forgedMethod.mappingOptions;
        this.contextProvidedMethods = forgedMethod.contextProvidedMethods;
        this.name = name;
        this.forgedNameBased = forgedMethod.forgedNameBased;
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        if (!targetType.equals(this.returnType)) {
            return false;
        }
        if (this.parameters.size() != sourceTypes.size()) {
            return false;
        }
        Iterator<Type> srcTypeIt = sourceTypes.iterator();
        Iterator<Parameter> paramIt = this.parameters.iterator();
        while (srcTypeIt.hasNext() && paramIt.hasNext()) {
            Parameter param;
            Type sourceType = srcTypeIt.next();
            if (sourceType.equals((param = paramIt.next()).getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getDeclaringMapper() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        return this.sourceParameters;
    }

    @Override
    public List<Parameter> getContextParameters() {
        return this.contextParameters;
    }

    @Override
    public ParameterProvidedMethods getContextProvidedMethods() {
        return this.contextProvidedMethods;
    }

    @Override
    public Parameter getMappingTargetParameter() {
        return this.mappingTargetParameter;
    }

    @Override
    public Parameter getTargetTypeParameter() {
        return null;
    }

    @Override
    public Accessibility getAccessibility() {
        return Accessibility.PROTECTED;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public List<Type> getThrownTypes() {
        return this.thrownTypes;
    }

    public ForgedMethodHistory getHistory() {
        return this.history;
    }

    public boolean isForgedNamedBased() {
        return this.forgedNameBased;
    }

    public void addThrownTypes(List<Type> thrownTypesToAdd) {
        for (Type thrownType : thrownTypesToAdd) {
            if (this.thrownTypes.contains(thrownType)) continue;
            this.thrownTypes.add(thrownType);
        }
    }

    @Override
    public Type getResultType() {
        return this.mappingTargetParameter != null ? this.mappingTargetParameter.getType() : this.returnType;
    }

    @Override
    public List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Parameter parameter : this.getParameters()) {
            parameterNames.add(parameter.getName());
        }
        return parameterNames;
    }

    @Override
    public boolean overridesMethod() {
        return false;
    }

    @Override
    public ExecutableElement getExecutable() {
        return this.positionHintElement;
    }

    @Override
    public boolean isLifecycleCallbackMethod() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Type getDefiningType() {
        return null;
    }

    @Override
    public MapperConfiguration getMapperConfiguration() {
        return this.mapperConfiguration;
    }

    @Override
    public boolean isUpdateMethod() {
        return this.getMappingTargetParameter() != null;
    }

    @Override
    public boolean isObjectFactory() {
        return false;
    }

    @Override
    public MappingOptions getMappingOptions() {
        return this.mappingOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForgedMethod that = (ForgedMethod)o;
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.parameters != null ? this.parameters.hashCode() : 0;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

