/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.VariableElement;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.prism.ContextPrism;
import org.mapstruct.ap.internal.prism.MappingTargetPrism;
import org.mapstruct.ap.internal.prism.TargetTypePrism;
import org.mapstruct.ap.internal.util.Collections;

public class Parameter
extends ModelElement {
    private final String name;
    private final String originalName;
    private final Type type;
    private final boolean mappingTarget;
    private final boolean targetType;
    private final boolean mappingContext;

    private Parameter(String name, Type type, boolean mappingTarget, boolean targetType, boolean mappingContext) {
        this.name = "values".equals(name) ? "values_" : name;
        this.originalName = name;
        this.type = type;
        this.mappingTarget = mappingTarget;
        this.targetType = targetType;
        this.mappingContext = mappingContext;
    }

    public Parameter(String name, Type type) {
        this(name, type, false, false, false);
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isMappingTarget() {
        return this.mappingTarget;
    }

    public String toString() {
        return (this.mappingTarget ? "@MappingTarget " : "") + (this.targetType ? "@TargetType " : "") + (this.mappingContext ? "@Context " : "") + this.type.toString() + " " + this.name;
    }

    @Override
    public Set<Type> getImportTypes() {
        return Collections.asSet(this.type);
    }

    public boolean isTargetType() {
        return this.targetType;
    }

    public boolean isMappingContext() {
        return this.mappingContext;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static Parameter forElementAndType(VariableElement element, Type parameterType) {
        return new Parameter(element.getSimpleName().toString(), parameterType, MappingTargetPrism.getInstanceOn(element) != null, TargetTypePrism.getInstanceOn(element) != null, ContextPrism.getInstanceOn(element) != null);
    }

    public static Parameter forForgedMappingTarget(Type parameterType) {
        return new Parameter("mappingTarget", parameterType, true, false, false);
    }

    public static List<Parameter> getSourceParameters(List<Parameter> parameters) {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>(parameters.size());
        for (Parameter parameter : parameters) {
            if (parameter.isMappingTarget() || parameter.isTargetType() || parameter.isMappingContext()) continue;
            sourceParameters.add(parameter);
        }
        return sourceParameters;
    }

    public static List<Parameter> getContextParameters(List<Parameter> parameters) {
        ArrayList<Parameter> contextParameters = new ArrayList<Parameter>(parameters.size());
        for (Parameter parameter : parameters) {
            if (!parameter.isMappingContext()) continue;
            contextParameters.add(parameter);
        }
        return contextParameters;
    }

    public static Parameter getMappingTargetParameter(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isMappingTarget()) continue;
            return parameter;
        }
        return null;
    }

    public static Parameter getTargetTypeParameter(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isTargetType()) continue;
            return parameter;
        }
        return null;
    }
}

