/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.internal.naming.DefaultAccessorNamingStrategy;
import org.mapstruct.ap.internal.prism.AfterMappingPrism;
import org.mapstruct.ap.internal.prism.BeforeMappingPrism;
import org.mapstruct.ap.internal.services.Services;
import org.mapstruct.ap.internal.util.SpecificCompilerWorkarounds;
import org.mapstruct.ap.spi.AccessorNamingStrategy;
import org.mapstruct.ap.spi.MethodType;

public class Executables {
    private static final Method DEFAULT_METHOD;
    private static final AccessorNamingStrategy ACCESSOR_NAMING_STRATEGY;

    private Executables() {
    }

    public static boolean isGetterMethod(ExecutableElement method) {
        return Executables.isPublic(method) && method.getParameters().isEmpty() && ACCESSOR_NAMING_STRATEGY.getMethodType(method) == MethodType.GETTER;
    }

    public static boolean isSetterMethod(ExecutableElement method) {
        return Executables.isPublic(method) && method.getParameters().size() == 1 && ACCESSOR_NAMING_STRATEGY.getMethodType(method) == MethodType.SETTER;
    }

    public static boolean isAdderMethod(ExecutableElement method) {
        return Executables.isPublic(method) && method.getParameters().size() == 1 && ACCESSOR_NAMING_STRATEGY.getMethodType(method) == MethodType.ADDER;
    }

    private static boolean isPublic(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public static String getPropertyName(ExecutableElement getterOrSetterMethod) {
        return ACCESSOR_NAMING_STRATEGY.getPropertyName(getterOrSetterMethod);
    }

    public static boolean isDefaultMethod(ExecutableElement method) {
        try {
            return DEFAULT_METHOD != null && Boolean.TRUE.equals(DEFAULT_METHOD.invoke((Object)method, new Object[0]));
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    public static String getElementNameForAdder(ExecutableElement adderMethod) {
        return ACCESSOR_NAMING_STRATEGY.getElementName(adderMethod);
    }

    public static String getCollectionGetterName(ExecutableElement targetSetter) {
        String propertyName = ACCESSOR_NAMING_STRATEGY.getPropertyName(targetSetter);
        return ACCESSOR_NAMING_STRATEGY.getCollectionGetterName(propertyName);
    }

    private static TypeElement asTypeElement(TypeMirror mirror) {
        return (TypeElement)((DeclaredType)mirror).asElement();
    }

    public static List<ExecutableElement> getAllEnclosedExecutableElements(Elements elementUtils, TypeElement element) {
        ArrayList<ExecutableElement> enclosedElements = new ArrayList<ExecutableElement>();
        element = SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(elementUtils, element);
        Executables.addEnclosedElementsInHierarchy(elementUtils, enclosedElements, element, element);
        return enclosedElements;
    }

    private static void addEnclosedElementsInHierarchy(Elements elementUtils, List<ExecutableElement> alreadyAdded, TypeElement element, TypeElement parentType) {
        if (element != parentType) {
            element = SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(elementUtils, element);
        }
        Executables.addNotYetOverridden(elementUtils, alreadyAdded, ElementFilter.methodsIn(element.getEnclosedElements()), parentType);
        if (Executables.hasNonObjectSuperclass(element)) {
            Executables.addEnclosedElementsInHierarchy(elementUtils, alreadyAdded, Executables.asTypeElement(element.getSuperclass()), parentType);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            Executables.addEnclosedElementsInHierarchy(elementUtils, alreadyAdded, Executables.asTypeElement(typeMirror), parentType);
        }
    }

    private static void addNotYetOverridden(Elements elementUtils, List<ExecutableElement> alreadyCollected, List<ExecutableElement> methodsToAdd, TypeElement parentType) {
        ArrayList<ExecutableElement> safeToAdd = new ArrayList<ExecutableElement>(methodsToAdd.size());
        for (ExecutableElement toAdd : methodsToAdd) {
            if (!Executables.isNotStaticMethodInInterface(toAdd, parentType) || !Executables.isNotInterfaceDefaultMethod(toAdd, parentType) || !Executables.isNotObjectEquals(toAdd) || !Executables.wasNotYetOverridden(elementUtils, alreadyCollected, toAdd, parentType)) continue;
            safeToAdd.add(toAdd);
        }
        alreadyCollected.addAll(0, safeToAdd);
    }

    private static boolean isNotStaticMethodInInterface(ExecutableElement element, TypeElement parentType) {
        return !parentType.getKind().isInterface() || element.getKind() != ElementKind.METHOD || !element.getModifiers().containsAll(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC));
    }

    private static boolean isNotInterfaceDefaultMethod(ExecutableElement element, TypeElement parentType) {
        return !parentType.getKind().isInterface() || element.getKind() != ElementKind.METHOD || !Executables.isDefaultMethod(element);
    }

    private static boolean isNotObjectEquals(ExecutableElement executable) {
        return !executable.getSimpleName().contentEquals("equals") || executable.getParameters().size() != 1 || !Executables.asTypeElement(executable.getParameters().get(0).asType()).getQualifiedName().contentEquals("java.lang.Object");
    }

    private static boolean wasNotYetOverridden(Elements elementUtils, List<ExecutableElement> alreadyAdded, ExecutableElement executable, TypeElement parentType) {
        for (ExecutableElement executableInSubtype : alreadyAdded) {
            if (!elementUtils.overrides(executableInSubtype, executable, parentType)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNonObjectSuperclass(TypeElement element) {
        return element.getSuperclass().getKind() == TypeKind.DECLARED && Executables.asTypeElement(element.getSuperclass()).getSuperclass().getKind() == TypeKind.DECLARED;
    }

    public static boolean isLifecycleCallbackMethod(ExecutableElement executableElement) {
        return Executables.isBeforeMappingMethod(executableElement) || Executables.isAfterMappingMethod(executableElement);
    }

    public static boolean isAfterMappingMethod(ExecutableElement executableElement) {
        return AfterMappingPrism.getInstanceOn(executableElement) != null;
    }

    public static boolean isBeforeMappingMethod(ExecutableElement executableElement) {
        return BeforeMappingPrism.getInstanceOn(executableElement) != null;
    }

    static {
        Method method;
        try {
            method = ExecutableElement.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        DEFAULT_METHOD = method;
        ACCESSOR_NAMING_STRATEGY = Services.get(AccessorNamingStrategy.class, new DefaultAccessorNamingStrategy());
    }
}

