/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Strings;

public class ForgedMethod
implements Method {
    private final List<Parameter> parameters;
    private final Type returnType;
    private final String name;
    private final ExecutableElement positionHintElement;
    private final List<Type> thrownTypes;

    public ForgedMethod(String name, Type sourceType, Type targetType, ExecutableElement positionHintElement) {
        String sourceParamName = Strings.decapitalize(sourceType.getName().replace("[]", ""));
        String sourceParamSafeName = Strings.getSaveVariableName(sourceParamName, new String[0]);
        this.parameters = Arrays.asList(new Parameter(sourceParamSafeName, sourceType));
        this.returnType = targetType;
        this.thrownTypes = new ArrayList<Type>();
        this.name = name;
        this.positionHintElement = positionHintElement;
    }

    public ForgedMethod(String name, ForgedMethod forgedMethod) {
        this.parameters = forgedMethod.parameters;
        this.returnType = forgedMethod.returnType;
        this.thrownTypes = new ArrayList<Type>();
        this.positionHintElement = forgedMethod.positionHintElement;
        this.name = name;
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        if (!targetType.equals(this.returnType)) {
            return false;
        }
        if (this.parameters.size() != 1 || sourceTypes.size() != 1) {
            return false;
        }
        return Collections.first(sourceTypes).equals(this.parameters.get(0).getType());
    }

    @Override
    public Type getDeclaringMapper() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        return this.parameters;
    }

    @Override
    public Parameter getMappingTargetParameter() {
        return null;
    }

    @Override
    public Parameter getTargetTypeParameter() {
        return null;
    }

    @Override
    public Accessibility getAccessibility() {
        return Accessibility.PROTECTED;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public List<Type> getThrownTypes() {
        return this.thrownTypes;
    }

    public void addThrownTypes(List<Type> thrownTypesToAdd) {
        for (Type thrownType : thrownTypesToAdd) {
            if (this.thrownTypes.contains(thrownType)) continue;
            this.thrownTypes.add(thrownType);
        }
    }

    @Override
    public Type getResultType() {
        return this.returnType;
    }

    @Override
    public List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Parameter parameter : this.getParameters()) {
            parameterNames.add(parameter.getName());
        }
        return parameterNames;
    }

    @Override
    public boolean overridesMethod() {
        return false;
    }

    @Override
    public ExecutableElement getExecutable() {
        return this.positionHintElement;
    }

    @Override
    public boolean isLifecycleCallbackMethod() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public MapperConfiguration getMapperConfiguration() {
        return null;
    }

    @Override
    public boolean isUpdateMethod() {
        return this.getMappingTargetParameter() != null;
    }
}

