/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.model.LifecycleCallbackFactory;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.dependency.GraphAnalyzer;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.option.ReportingPolicy;
import org.mapstruct.ap.internal.prism.BeanMappingPrism;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class BeanMappingMethod
extends MappingMethod {
    private final List<PropertyMapping> propertyMappings;
    private final Map<String, List<PropertyMapping>> mappingsByParameter;
    private final List<PropertyMapping> constantMappings;
    private final MethodReference factoryMethod;
    private final boolean mapNullToDefault;
    private final Type resultType;

    private BeanMappingMethod(SourceMethod method, List<PropertyMapping> propertyMappings, MethodReference factoryMethod, boolean mapNullToDefault, Type resultType, Collection<String> existingVariableNames, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences) {
        super(method, existingVariableNames, beforeMappingReferences, afterMappingReferences);
        this.propertyMappings = propertyMappings;
        this.mappingsByParameter = new HashMap<String, List<PropertyMapping>>();
        this.constantMappings = new ArrayList<PropertyMapping>(propertyMappings);
        for (Parameter sourceParameter : this.getSourceParameters()) {
            ArrayList<PropertyMapping> mappingsOfParameter = new ArrayList<PropertyMapping>();
            this.mappingsByParameter.put(sourceParameter.getName(), mappingsOfParameter);
            for (PropertyMapping mapping : propertyMappings) {
                if (!sourceParameter.getName().equals(mapping.getSourceBeanName())) continue;
                mappingsOfParameter.add(mapping);
                this.constantMappings.remove(mapping);
            }
        }
        this.factoryMethod = factoryMethod;
        this.mapNullToDefault = mapNullToDefault;
        this.resultType = resultType;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public List<PropertyMapping> getConstantMappings() {
        return this.constantMappings;
    }

    public Map<String, List<PropertyMapping>> getPropertyMappingsByParameter() {
        return this.mappingsByParameter;
    }

    public boolean isMapNullToDefault() {
        return this.mapNullToDefault;
    }

    @Override
    public Type getResultType() {
        if (this.resultType == null) {
            return super.getResultType();
        }
        return this.resultType;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            types.addAll(propertyMapping.getImportTypes());
        }
        return types;
    }

    public List<Parameter> getSourceParametersExcludingPrimitives() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    public List<Parameter> getSourcePrimitiveParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (!sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private Map<String, ExecutableElement> unprocessedTargetProperties;
        private Set<String> targetProperties;
        private final List<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        private final Set<Parameter> unprocessedSourceParameters = new HashSet<Parameter>();
        private List<TypeMirror> qualifiers;
        private NullValueMappingStrategyPrism nullValueMappingStrategy;
        private TypeMirror resultTypeMirror;
        private final Set<String> existingVariableNames = new HashSet<String>();

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            CollectionMappingStrategyPrism cms = sourceMethod.getMapperConfiguration().getCollectionMappingStrategy();
            Map<String, ExecutableElement> accessors = this.method.getResultType().getPropertyWriteAccessors(cms);
            this.targetProperties = accessors.keySet();
            this.unprocessedTargetProperties = new LinkedHashMap<String, ExecutableElement>(accessors);
            for (Parameter sourceParameter : this.method.getSourceParameters()) {
                this.unprocessedSourceParameters.add(sourceParameter);
            }
            this.existingVariableNames.addAll(this.method.getParameterNames());
            return this;
        }

        public Builder qualifiers(List<TypeMirror> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public Builder nullValueMappingStrategy(NullValueMappingStrategyPrism nullValueMappingStrategy) {
            this.nullValueMappingStrategy = nullValueMappingStrategy;
            return this;
        }

        public Builder resultType(TypeMirror resultType) {
            this.resultTypeMirror = resultType;
            return this;
        }

        public BeanMappingMethod build() {
            boolean mappingErrorOccured = this.handleDefinedSourceMappings();
            if (mappingErrorOccured) {
                return null;
            }
            this.applyPropertyNameBasedMapping();
            this.applyParameterNameBasedMapping();
            this.reportErrorForUnmappedTargetPropertiesIfRequired();
            boolean mapNullToDefault = this.method.getMapperConfiguration().isMapToDefault(this.nullValueMappingStrategy);
            BeanMappingPrism beanMappingPrism = BeanMappingPrism.getInstanceOn(this.method.getExecutable());
            MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, this.method.getResultType(), this.qualifiers, this.resultTypeMirror);
            Type resultType = null;
            if (factoryMethod == null && this.resultTypeMirror != null && !(resultType = this.ctx.getTypeFactory().getType(this.resultTypeMirror)).isAssignableTo(this.method.getResultType())) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), beanMappingPrism.mirror, Message.BEANMAPPING_NOT_ASSIGNABLE, resultType, this.method.getResultType());
            }
            this.sortPropertyMappingsByDependencies();
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleCallbackFactory.beforeMappingMethods(this.method, this.qualifiers, this.ctx);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleCallbackFactory.afterMappingMethods(this.method, this.qualifiers, this.ctx);
            return new BeanMappingMethod(this.method, this.propertyMappings, factoryMethod, mapNullToDefault, resultType, this.existingVariableNames, beforeMappingMethods, afterMappingMethods);
        }

        private void sortPropertyMappingsByDependencies() {
            GraphAnalyzer.GraphAnalyzerBuilder graphAnalyzerBuilder = GraphAnalyzer.builder();
            for (PropertyMapping propertyMapping : this.propertyMappings) {
                graphAnalyzerBuilder.withNode(propertyMapping.getName(), propertyMapping.getDependsOn());
            }
            final GraphAnalyzer graphAnalyzer = graphAnalyzerBuilder.build();
            if (!graphAnalyzer.getCycles().isEmpty()) {
                HashSet<String> cycles = new HashSet<String>();
                for (List<String> cycle : graphAnalyzer.getCycles()) {
                    cycles.add(Strings.join(cycle, " -> "));
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_CYCLE_BETWEEN_PROPERTIES, Strings.join(cycles, ", "));
            } else {
                Collections.sort(this.propertyMappings, new Comparator<PropertyMapping>(){

                    @Override
                    public int compare(PropertyMapping o1, PropertyMapping o2) {
                        if (graphAnalyzer.getAllDescendants(o1.getName()).contains(o2.getName())) {
                            return 1;
                        }
                        if (graphAnalyzer.getAllDescendants(o2.getName()).contains(o1.getName())) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
        }

        private boolean handleDefinedSourceMappings() {
            boolean errorOccurred = false;
            HashSet<String> handledTargets = new HashSet<String>();
            for (Map.Entry<String, List<Mapping>> entry : this.method.getMappingOptions().getMappings().entrySet()) {
                for (Mapping mapping : entry.getValue()) {
                    PropertyMapping propertyMapping = null;
                    ExecutableElement targetWriteAccessor = this.unprocessedTargetProperties.get(mapping.getTargetName());
                    if (targetWriteAccessor == null) {
                        this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getSourceAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_RETURNTYPE, mapping.getTargetName());
                        errorOccurred = true;
                    }
                    for (String dependency : mapping.getDependsOn()) {
                        if (this.targetProperties.contains(dependency)) continue;
                        this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getDependsOnAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_DEPENDS_ON, dependency);
                        errorOccurred = true;
                    }
                    if (mapping.isIgnored()) {
                        propertyMapping = null;
                        handledTargets.add(mapping.getTargetName());
                    } else if (mapping.getSourceName() != null) {
                        SourceReference sourceRef = mapping.getSourceReference();
                        if (sourceRef.isValid()) {
                            if (targetWriteAccessor != null) {
                                propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetWriteAccessor)).targetReadAccessor(this.getTargetPropertyReadAccessor(mapping.getTargetName()))).targetPropertyName(mapping.getTargetName())).sourceReference(sourceRef).qualifiers(mapping.getQualifiers()).resultType(mapping.getResultType()).dateFormat(mapping.getDateFormat()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).build();
                                handledTargets.add(mapping.getTargetName());
                                this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                            }
                        } else {
                            errorOccurred = true;
                        }
                    } else if (mapping.getConstant() != null && targetWriteAccessor != null) {
                        propertyMapping = ((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)new PropertyMapping.ConstantMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).constantExpression("\"" + mapping.getConstant() + "\"").targetWriteAccessor(targetWriteAccessor)).targetReadAccessor(this.getTargetPropertyReadAccessor(mapping.getTargetName()))).targetPropertyName(mapping.getTargetName())).dateFormat(mapping.getDateFormat()).qualifiers(mapping.getQualifiers()).resultType(mapping.getResultType()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).build();
                        handledTargets.add(mapping.getTargetName());
                    } else if (mapping.getJavaExpression() != null && targetWriteAccessor != null) {
                        propertyMapping = ((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(mapping.getJavaExpression()).existingVariableNames(this.existingVariableNames)).targetWriteAccessor(targetWriteAccessor)).targetReadAccessor(targetWriteAccessor)).targetPropertyName(mapping.getTargetName())).dependsOn(mapping.getDependsOn())).build();
                        handledTargets.add(mapping.getTargetName());
                    }
                    if (propertyMapping == null) continue;
                    this.propertyMappings.add(propertyMapping);
                }
            }
            for (String handledTarget : handledTargets) {
                this.unprocessedTargetProperties.remove(handledTarget);
            }
            return errorOccurred;
        }

        private void applyPropertyNameBasedMapping() {
            Iterator<Map.Entry<String, ExecutableElement>> targetProperties = this.unprocessedTargetProperties.entrySet().iterator();
            ArrayList<ExecutableElement> candidates = new ArrayList<ExecutableElement>(2);
            while (targetProperties.hasNext()) {
                Map.Entry<String, ExecutableElement> targetProperty = targetProperties.next();
                PropertyMapping propertyMapping = null;
                if (propertyMapping == null) {
                    for (Parameter sourceParameter : this.method.getSourceParameters()) {
                        if (sourceParameter.getType().isPrimitive()) continue;
                        Collection<ExecutableElement> sourceReadAccessors = sourceParameter.getType().getPropertyReadAccessors().values();
                        for (ExecutableElement sourceReadAccessor : sourceReadAccessors) {
                            String sourcePropertyName = Executables.getPropertyName(sourceReadAccessor);
                            if (!sourcePropertyName.equals(targetProperty.getKey())) continue;
                            candidates.add(sourceReadAccessor);
                        }
                        PropertyMapping newPropertyMapping = null;
                        ExecutableElement sourceAccessor = this.getSourceAccessor(targetProperty.getKey(), candidates);
                        if (sourceAccessor != null) {
                            Mapping mapping = this.method.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                            SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(this.ctx.getTypeFactory().getReturnType(sourceAccessor)).accessor(sourceAccessor).name(targetProperty.getKey()).build();
                            newPropertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetProperty.getValue())).targetReadAccessor(this.getTargetPropertyReadAccessor(targetProperty.getKey()))).targetPropertyName(targetProperty.getKey())).sourceReference(sourceRef).qualifiers(mapping != null ? mapping.getQualifiers() : null).resultType(mapping != null ? mapping.getResultType() : null).dateFormat(mapping != null ? mapping.getDateFormat() : null).existingVariableNames(this.existingVariableNames)).dependsOn(mapping != null ? mapping.getDependsOn() : Collections.emptyList())).build();
                            this.unprocessedSourceParameters.remove(sourceParameter);
                        }
                        candidates.clear();
                        if (propertyMapping != null && newPropertyMapping != null) {
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_SEVERAL_POSSIBLE_SOURCES, targetProperty.getKey());
                            break;
                        }
                        if (newPropertyMapping == null) continue;
                        propertyMapping = newPropertyMapping;
                    }
                }
                if (propertyMapping == null) continue;
                this.propertyMappings.add(propertyMapping);
                targetProperties.remove();
            }
        }

        private void applyParameterNameBasedMapping() {
            Iterator<Map.Entry<String, ExecutableElement>> targetProperties = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetProperties.hasNext()) {
                Map.Entry<String, ExecutableElement> targetProperty = targetProperties.next();
                Iterator<Parameter> sourceParameters = this.unprocessedSourceParameters.iterator();
                while (sourceParameters.hasNext()) {
                    Parameter sourceParameter = sourceParameters.next();
                    if (!sourceParameter.getName().equals(targetProperty.getKey())) continue;
                    Mapping mapping = this.method.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                    SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getKey()).build();
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetProperty.getValue())).targetReadAccessor(this.getTargetPropertyReadAccessor(targetProperty.getKey()))).targetPropertyName(targetProperty.getKey())).sourceReference(sourceRef).qualifiers(mapping != null ? mapping.getQualifiers() : null).resultType(mapping != null ? mapping.getResultType() : null).dateFormat(mapping != null ? mapping.getDateFormat() : null).existingVariableNames(this.existingVariableNames)).dependsOn(mapping != null ? mapping.getDependsOn() : Collections.emptyList())).build();
                    this.propertyMappings.add(propertyMapping);
                    targetProperties.remove();
                    sourceParameters.remove();
                }
            }
        }

        private ExecutableElement getSourceAccessor(String sourcePropertyName, List<ExecutableElement> candidates) {
            if (candidates.isEmpty()) {
                return null;
            }
            if (candidates.size() == 1) {
                return candidates.get(0);
            }
            if (candidates.size() == 2) {
                if (candidates.get(0).getSimpleName().toString().startsWith("get")) {
                    return candidates.get(0);
                }
                return candidates.get(1);
            }
            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_SEVERAL_POSSIBLE_TARGET_ACCESSORS, sourcePropertyName);
            return null;
        }

        private ExecutableElement getTargetPropertyReadAccessor(String propertyName) {
            return this.method.getResultType().getPropertyReadAccessors().get(propertyName);
        }

        private ReportingPolicy getEffectiveUnmappedTargetPolicy() {
            MapperConfiguration mapperSettings = MapperConfiguration.getInstanceOn(this.ctx.getMapperTypeElement());
            boolean setViaAnnotation = mapperSettings.isSetUnmappedTargetPolicy();
            ReportingPolicy annotationValue = ReportingPolicy.valueOf(mapperSettings.unmappedTargetPolicy());
            if (setViaAnnotation || this.ctx.getOptions().getUnmappedTargetPolicy() == null) {
                return annotationValue;
            }
            return this.ctx.getOptions().getUnmappedTargetPolicy();
        }

        private void reportErrorForUnmappedTargetPropertiesIfRequired() {
            ReportingPolicy unmappedTargetPolicy = this.getEffectiveUnmappedTargetPolicy();
            if (!this.unprocessedTargetProperties.isEmpty() && unmappedTargetPolicy.requiresReport()) {
                Message msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_TARGETS_WARNING;
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", ")));
            }
        }
    }
}

