/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;

public class Executables {
    private Executables() {
    }

    public static boolean isGetterMethod(ExecutableElement method) {
        return Executables.isPublic(method) && (Executables.isNonBooleanGetterMethod(method) || Executables.isBooleanGetterMethod(method));
    }

    private static boolean isNonBooleanGetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return method.getParameters().isEmpty() && name.startsWith("get") && name.length() > 3 && method.getReturnType().getKind() != TypeKind.VOID;
    }

    private static boolean isBooleanGetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        boolean returnTypeIsBoolean = method.getReturnType().getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(Executables.getQualifiedName(method.getReturnType()));
        return method.getParameters().isEmpty() && name.startsWith("is") && name.length() > 2 && returnTypeIsBoolean;
    }

    public static boolean isSetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return Executables.isPublic(method) && name.startsWith("set") && name.length() > 3 && method.getParameters().size() == 1;
    }

    public static boolean isAdderMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return Executables.isPublic(method) && name.startsWith("add") && name.length() > 3 && method.getParameters().size() == 1;
    }

    private static boolean isPublic(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public static String getPropertyName(ExecutableElement getterOrSetterMethod) {
        if (Executables.isNonBooleanGetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(3));
        }
        if (Executables.isBooleanGetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(2));
        }
        if (Executables.isSetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(3));
        }
        throw new IllegalArgumentException("Executable " + getterOrSetterMethod + " is not getter or setter method.");
    }

    public static String getElementNameForAdder(ExecutableElement adderMethod) {
        if (Executables.isAdderMethod(adderMethod)) {
            return Introspector.decapitalize(adderMethod.getSimpleName().toString().substring(3));
        }
        throw new IllegalArgumentException("Executable " + adderMethod + " is not an adder method.");
    }

    public static Set<String> getPropertyNames(List<ExecutableElement> propertyAccessors) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (ExecutableElement executableElement : propertyAccessors) {
            propertyNames.add(Executables.getPropertyName(executableElement));
        }
        return propertyNames;
    }

    private static String getQualifiedName(TypeMirror type) {
        DeclaredType declaredType = type.accept(new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        if (declaredType == null) {
            return null;
        }
        TypeElement typeElement = declaredType.asElement().accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
        return typeElement != null ? typeElement.getQualifiedName().toString() : null;
    }

    private static TypeElement asTypeElement(TypeMirror mirror) {
        return (TypeElement)((DeclaredType)mirror).asElement();
    }

    public static List<ExecutableElement> getAllEnclosedExecutableElements(Elements elementUtils, TypeElement element) {
        ArrayList<ExecutableElement> enclosedElements = new ArrayList<ExecutableElement>();
        Executables.addEnclosingElementsIncludingSuper(elementUtils, enclosedElements, element);
        return enclosedElements;
    }

    private static void addEnclosingElementsIncludingSuper(Elements elementUtils, List<ExecutableElement> alreadyAdded, TypeElement element) {
        Executables.addNotYetOverridden(elementUtils, alreadyAdded, ElementFilter.methodsIn(element.getEnclosedElements()));
        if (Executables.hasNonObjectSuperclass(element)) {
            Executables.addEnclosingElementsIncludingSuper(elementUtils, alreadyAdded, Executables.asTypeElement(element.getSuperclass()));
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            Executables.addEnclosingElementsIncludingSuper(elementUtils, alreadyAdded, Executables.asTypeElement(typeMirror));
        }
    }

    private static void addNotYetOverridden(Elements elementUtils, List<ExecutableElement> alreadyCollected, List<ExecutableElement> methodsToAdd) {
        ArrayList<ExecutableElement> safeToAdd = new ArrayList<ExecutableElement>(methodsToAdd.size());
        for (ExecutableElement toAdd : methodsToAdd) {
            if (!Executables.isNotObjectEquals(toAdd) || !Executables.wasNotYetOverridden(elementUtils, alreadyCollected, toAdd)) continue;
            safeToAdd.add(toAdd);
        }
        alreadyCollected.addAll(safeToAdd);
    }

    private static boolean isNotObjectEquals(ExecutableElement executable) {
        return !executable.getSimpleName().contentEquals("equals") || executable.getParameters().size() != 1 || !Executables.asTypeElement(executable.getParameters().get(0).asType()).getQualifiedName().contentEquals("java.lang.Object");
    }

    private static boolean wasNotYetOverridden(Elements elementUtils, List<ExecutableElement> alreadyAdded, ExecutableElement executable) {
        for (ExecutableElement executableInSubtype : alreadyAdded) {
            TypeElement declaringType;
            if (!elementUtils.overrides(executableInSubtype, executable, declaringType = (TypeElement)executableInSubtype.getEnclosingElement())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNonObjectSuperclass(TypeElement element) {
        return element.getSuperclass().getKind() == TypeKind.DECLARED && Executables.asTypeElement(element.getSuperclass()).getSuperclass().getKind() == TypeKind.DECLARED;
    }
}

