/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import java.util.ListIterator;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.model.Annotation;
import org.mapstruct.ap.model.AnnotationMapperReference;
import org.mapstruct.ap.model.Mapper;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.option.OptionsHelper;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.util.MapperConfig;

public abstract class AnnotationBasedComponentModelProcessor
implements ModelElementProcessor<Mapper, Mapper> {
    private TypeFactory typeFactory;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Mapper mapper) {
        this.typeFactory = context.getTypeFactory();
        String componentModel = MapperConfig.getInstanceOn(mapperTypeElement).componentModel();
        String effectiveComponentModel = OptionsHelper.getEffectiveComponentModel(context.getOptions(), componentModel);
        if (!this.getComponentModelIdentifier().equalsIgnoreCase(effectiveComponentModel)) {
            return mapper;
        }
        mapper.addAnnotation(this.getTypeAnnotation());
        ListIterator<MapperReference> iterator = mapper.getReferencedMappers().listIterator();
        while (iterator.hasNext()) {
            MapperReference reference = iterator.next();
            iterator.remove();
            iterator.add(this.replacementMapperReference(reference));
        }
        return mapper;
    }

    protected MapperReference replacementMapperReference(MapperReference originalReference) {
        return new AnnotationMapperReference(originalReference.getType(), originalReference.getVariableName(), this.getMapperReferenceAnnotation());
    }

    protected abstract String getComponentModelIdentifier();

    protected abstract Annotation getTypeAnnotation();

    protected abstract Annotation getMapperReferenceAnnotation();

    @Override
    public int getPriority() {
        return 1100;
    }

    protected TypeFactory getTypeFactory() {
        return this.typeFactory;
    }
}

