/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.selector.MethodSelector;

public class InheritanceSelector
implements MethodSelector {
    @Override
    public <T extends Method> List<T> getMatchingMethods(Method mappingMethod, List<T> methods, Type parameterType, Type returnType, List<TypeMirror> qualifiers, String targetPropertyName) {
        ArrayList candidatesWithBestMatchingSourceType = new ArrayList();
        int bestMatchingSourceTypeDistance = Integer.MAX_VALUE;
        for (Method method : methods) {
            Parameter singleSourceParam = method.getSourceParameters().iterator().next();
            int sourceTypeDistance = parameterType.distanceTo(singleSourceParam.getType());
            bestMatchingSourceTypeDistance = this.addToCandidateListIfMinimal(candidatesWithBestMatchingSourceType, bestMatchingSourceTypeDistance, method, sourceTypeDistance);
        }
        return candidatesWithBestMatchingSourceType;
    }

    private <T extends Method> int addToCandidateListIfMinimal(List<T> candidatesWithBestMathingType, int bestMatchingTypeDistance, T method, int currentTypeDistance) {
        if (currentTypeDistance == bestMatchingTypeDistance) {
            candidatesWithBestMathingType.add(method);
        } else if (currentTypeDistance < bestMatchingTypeDistance) {
            bestMatchingTypeDistance = currentTypeDistance;
            candidatesWithBestMathingType.clear();
            candidatesWithBestMathingType.add(method);
        }
        return bestMatchingTypeDistance;
    }
}

