/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.SourceReference;
import org.mapstruct.ap.prism.MappingPrism;
import org.mapstruct.ap.prism.MappingsPrism;
import org.mapstruct.ap.util.Executables;

public class Mapping {
    private static final Pattern JAVA_EXPRESSION = Pattern.compile("^java\\((.*)\\)$");
    private final String sourceName;
    private final String constant;
    private final String javaExpression;
    private final String targetName;
    private final String dateFormat;
    private final List<TypeMirror> qualifiers;
    private final boolean isIgnored;
    private final AnnotationMirror mirror;
    private final AnnotationValue sourceAnnotationValue;
    private final AnnotationValue targetAnnotationValue;
    private SourceReference sourceReference;

    public static Map<String, List<Mapping>> fromMappingsPrism(MappingsPrism mappingsAnnotation, ExecutableElement method, Messager messager) {
        HashMap<String, List<Mapping>> mappings = new HashMap<String, List<Mapping>>();
        for (MappingPrism mappingPrism : mappingsAnnotation.value()) {
            Mapping mapping = Mapping.fromMappingPrism(mappingPrism, method, messager);
            if (mapping == null) continue;
            ArrayList<Mapping> mappingsOfProperty = (ArrayList<Mapping>)mappings.get(mappingPrism.target());
            if (mappingsOfProperty == null) {
                mappingsOfProperty = new ArrayList<Mapping>();
                mappings.put(mappingPrism.target(), mappingsOfProperty);
            }
            mappingsOfProperty.add(mapping);
            if (mappingsOfProperty.size() <= 1 || Mapping.isEnumType(method.getReturnType())) continue;
            messager.printMessage(Diagnostic.Kind.ERROR, "Target property \"" + mappingPrism.target() + "\" must not be mapped more than once.", method);
        }
        return mappings;
    }

    public static Mapping fromMappingPrism(MappingPrism mappingPrism, ExecutableElement element, Messager messager) {
        if (mappingPrism.target().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Target must not be empty in @Mapping", element, mappingPrism.mirror, mappingPrism.values.target());
            return null;
        }
        if (!mappingPrism.source().isEmpty() && !mappingPrism.constant().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Source and constant are both defined in @Mapping, either define a source or a constant", element);
            return null;
        }
        if (!mappingPrism.source().isEmpty() && !mappingPrism.expression().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Source and expression are both defined in @Mapping, either define a source or an expression", element);
            return null;
        }
        if (!mappingPrism.expression().isEmpty() && !mappingPrism.constant().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Expression and constant are both defined in @Mapping, either define an expression or a constant", element);
            return null;
        }
        String source = mappingPrism.source().isEmpty() ? null : mappingPrism.source();
        String constant = mappingPrism.constant().isEmpty() ? null : mappingPrism.constant();
        String expression = Mapping.getExpression(mappingPrism, element, messager);
        String dateFormat = mappingPrism.dateFormat().isEmpty() ? null : mappingPrism.dateFormat();
        return new Mapping(source, constant, expression, mappingPrism.target(), dateFormat, mappingPrism.qualifiedBy(), mappingPrism.ignore(), mappingPrism.mirror, mappingPrism.values.source(), mappingPrism.values.target());
    }

    private Mapping(String sourceName, String constant, String javaExpression, String targetName, String dateFormat, List<TypeMirror> qualifiers, boolean isIgnored, AnnotationMirror mirror, AnnotationValue sourceAnnotationValue, AnnotationValue targetAnnotationValue) {
        this.sourceName = sourceName;
        this.constant = constant;
        this.javaExpression = javaExpression;
        this.targetName = targetName;
        this.dateFormat = dateFormat;
        this.qualifiers = qualifiers;
        this.isIgnored = isIgnored;
        this.mirror = mirror;
        this.sourceAnnotationValue = sourceAnnotationValue;
        this.targetAnnotationValue = targetAnnotationValue;
    }

    private static String getExpression(MappingPrism mappingPrism, ExecutableElement element, Messager messager) {
        if (mappingPrism.expression().isEmpty()) {
            return null;
        }
        Matcher javaExpressionMatcher = JAVA_EXPRESSION.matcher(mappingPrism.expression());
        if (!javaExpressionMatcher.matches()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Value must be given in the form \"java(<EXPRESSION>)\"", element, mappingPrism.mirror, mappingPrism.values.expression());
            return null;
        }
        return javaExpressionMatcher.group(1).trim();
    }

    private static boolean isEnumType(TypeMirror mirror) {
        return mirror.getKind() == TypeKind.DECLARED && ((DeclaredType)mirror).asElement().getKind() == ElementKind.ENUM;
    }

    public void init(SourceMethod method, Messager messager, TypeFactory typeFactory) {
        if (!method.isEnumMapping()) {
            this.sourceReference = new SourceReference.BuilderFromMapping().mapping(this).method(method).messager(messager).typeFactory(typeFactory).build();
        }
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getConstant() {
        return this.constant;
    }

    public String getJavaExpression() {
        return this.javaExpression;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public List<TypeMirror> getQualifiers() {
        return this.qualifiers;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public AnnotationValue getSourceAnnotationValue() {
        return this.sourceAnnotationValue;
    }

    public AnnotationValue getTargetAnnotationValue() {
        return this.targetAnnotationValue;
    }

    public SourceReference getSourceReference() {
        return this.sourceReference;
    }

    private boolean hasPropertyInReverseMethod(String name, SourceMethod method) {
        for (ExecutableElement getter : method.getResultType().getGetters()) {
            if (!Executables.getPropertyName(getter).equals(name)) continue;
            return true;
        }
        for (ExecutableElement getter : method.getResultType().getAlternativeTargetAccessors()) {
            if (!Executables.getPropertyName(getter).equals(name)) continue;
            return true;
        }
        return false;
    }

    public Mapping reverse(SourceMethod method, Messager messager, TypeFactory typeFactory) {
        if (this.constant != null || this.javaExpression != null) {
            return null;
        }
        if (this.isIgnored && this.sourceName == null && !this.hasPropertyInReverseMethod(this.targetName, method)) {
            return null;
        }
        if (this.sourceReference != null && this.sourceReference.getPropertyEntries().size() > 1) {
            return null;
        }
        if (this.sourceReference != null && this.sourceReference.getPropertyEntries().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("Parameter %s cannot be reversed", this.sourceReference.getParameter()), method.getExecutable());
            return null;
        }
        Mapping reverse = new Mapping(this.sourceName != null ? this.targetName : null, null, null, this.sourceName != null ? this.sourceName : this.targetName, this.dateFormat, this.qualifiers, this.isIgnored, this.mirror, this.sourceAnnotationValue, this.targetAnnotationValue);
        reverse.init(method, messager, typeFactory);
        return reverse;
    }

    public String toString() {
        return "Mapping {\n    sourceName='" + this.sourceName + "'," + "\n    targetName='" + this.targetName + "'," + "\n}";
    }
}

