/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.AssignmentFactory;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.PropertyMapping;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.SourceReference;
import org.mapstruct.ap.option.ReportingPolicy;
import org.mapstruct.ap.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.prism.NullValueMappingPrism;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.MapperConfig;
import org.mapstruct.ap.util.Strings;

public class BeanMappingMethod
extends MappingMethod {
    private final List<PropertyMapping> propertyMappings;
    private final Map<String, List<PropertyMapping>> mappingsByParameter;
    private final List<PropertyMapping> constantMappings;
    private final MethodReference factoryMethod;
    private final boolean mapNullToDefault;

    private BeanMappingMethod(SourceMethod method, List<PropertyMapping> propertyMappings, MethodReference factoryMethod, boolean mapNullToDefault) {
        super(method);
        this.propertyMappings = propertyMappings;
        this.mappingsByParameter = new HashMap<String, List<PropertyMapping>>();
        this.constantMappings = new ArrayList<PropertyMapping>(propertyMappings);
        for (Parameter sourceParameter : this.getSourceParameters()) {
            ArrayList<PropertyMapping> mappingsOfParameter = new ArrayList<PropertyMapping>();
            this.mappingsByParameter.put(sourceParameter.getName(), mappingsOfParameter);
            for (PropertyMapping mapping : propertyMappings) {
                if (!sourceParameter.getName().equals(mapping.getSourceBeanName())) continue;
                mappingsOfParameter.add(mapping);
                this.constantMappings.remove(mapping);
            }
        }
        this.factoryMethod = factoryMethod;
        this.mapNullToDefault = mapNullToDefault;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public List<PropertyMapping> getConstantMappings() {
        return this.constantMappings;
    }

    public Map<String, List<PropertyMapping>> getPropertyMappingsByParameter() {
        return this.mappingsByParameter;
    }

    public boolean isMapNullToDefault() {
        return this.mapNullToDefault;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            types.addAll(propertyMapping.getImportTypes());
        }
        return types;
    }

    public List<Parameter> getSourceParametersExcludingPrimitives() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    public List<Parameter> getSourcePrimitiveParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (!sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private Map<String, ExecutableElement> unprocessedTargetProperties;
        private final List<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        private final Set<Parameter> unprocessedSourceParameters = new HashSet<Parameter>();

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            this.unprocessedTargetProperties = this.initTargetPropertyAccessors();
            for (Parameter sourceParameter : this.method.getSourceParameters()) {
                this.unprocessedSourceParameters.add(sourceParameter);
            }
            return this;
        }

        public BeanMappingMethod build() {
            boolean mappingErrorOccured = this.handleDefinedSourceMappings();
            if (mappingErrorOccured) {
                return null;
            }
            this.applyPropertyNameBasedMapping();
            this.applyParameterNameBasedMapping();
            this.reportErrorForUnmappedTargetPropertiesIfRequired();
            NullValueMappingPrism prism = NullValueMappingPrism.getInstanceOn(this.method.getExecutable());
            boolean mapNullToDefault = MapperConfig.getInstanceOn(this.ctx.getMapperTypeElement()).isMapToDefault(prism);
            MethodReference factoryMethod = AssignmentFactory.createFactoryMethod(this.method.getReturnType(), this.ctx);
            return new BeanMappingMethod(this.method, this.propertyMappings, factoryMethod, mapNullToDefault);
        }

        private Map<String, ExecutableElement> initTargetPropertyAccessors() {
            CollectionMappingStrategyPrism cmStrategy = this.getEffectiveCollectionMappingStrategy();
            ArrayList<ExecutableElement> candidates = new ArrayList<ExecutableElement>();
            candidates.addAll(this.method.getResultType().getSetters());
            candidates.addAll(this.method.getResultType().getAlternativeTargetAccessors());
            HashMap<String, ExecutableElement> targetProperties = new HashMap<String, ExecutableElement>();
            for (ExecutableElement candidate : candidates) {
                String targetPropertyName = Executables.getPropertyName(candidate);
                if (cmStrategy == CollectionMappingStrategyPrism.SETTER_PREFERRED || cmStrategy == CollectionMappingStrategyPrism.ADDER_PREFERRED) {
                    Type targetType;
                    ExecutableElement adderMethod = null;
                    if (Executables.isSetterMethod(candidate)) {
                        targetType = this.ctx.getTypeFactory().getSingleParameter(candidate).getType();
                        if (cmStrategy == CollectionMappingStrategyPrism.ADDER_PREFERRED) {
                            adderMethod = this.method.getResultType().getAdderForType(targetType, targetPropertyName);
                        }
                    } else if (Executables.isGetterMethod(candidate)) {
                        targetType = this.ctx.getTypeFactory().getReturnType(candidate);
                        adderMethod = this.method.getResultType().getAdderForType(targetType, targetPropertyName);
                    }
                    if (adderMethod != null) {
                        candidate = adderMethod;
                    }
                }
                targetProperties.put(targetPropertyName, candidate);
            }
            return targetProperties;
        }

        private boolean handleDefinedSourceMappings() {
            boolean errorOccurred = false;
            HashSet<String> handledTargets = new HashSet<String>();
            for (Map.Entry<String, List<Mapping>> entry : this.method.getMappings().entrySet()) {
                for (Mapping mapping : entry.getValue()) {
                    PropertyMapping propertyMapping = null;
                    ExecutableElement targetProperty = this.unprocessedTargetProperties.get(mapping.getTargetName());
                    if (targetProperty == null) {
                        this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Unknown property \"%s\" in return type.", mapping.getTargetName()), this.method.getExecutable(), mapping.getMirror(), mapping.getSourceAnnotationValue());
                        errorOccurred = true;
                    }
                    if (mapping.isIgnored()) {
                        propertyMapping = null;
                        handledTargets.add(mapping.getTargetName());
                    } else if (mapping.getSourceName() != null) {
                        SourceReference sourceRef = mapping.getSourceReference();
                        if (sourceRef.isValid()) {
                            if (targetProperty != null) {
                                propertyMapping = new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx).souceMethod(this.method).targetAccessor(targetProperty).targetPropertyName(mapping.getTargetName()).sourceReference(sourceRef).qualifiers(mapping.getQualifiers()).dateFormat(mapping.getDateFormat()).build();
                                handledTargets.add(mapping.getTargetName());
                                this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                            }
                        } else {
                            errorOccurred = true;
                        }
                    } else if (mapping.getConstant() != null && targetProperty != null) {
                        propertyMapping = new PropertyMapping.ConstantMappingBuilder().mappingContext(this.ctx).sourceMethod(this.method).constantExpression("\"" + mapping.getConstant() + "\"").targetAccessor(targetProperty).dateFormat(mapping.getDateFormat()).qualifiers(mapping.getQualifiers()).build();
                        handledTargets.add(mapping.getTargetName());
                    } else if (mapping.getJavaExpression() != null && targetProperty != null) {
                        propertyMapping = new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx).souceMethod(this.method).javaExpression(mapping.getJavaExpression()).targetAccessor(targetProperty).build();
                        handledTargets.add(mapping.getTargetName());
                    }
                    if (propertyMapping == null) continue;
                    this.propertyMappings.add(propertyMapping);
                }
            }
            for (String handledTarget : handledTargets) {
                this.unprocessedTargetProperties.remove(handledTarget);
            }
            return errorOccurred;
        }

        private void applyPropertyNameBasedMapping() {
            Iterator<Map.Entry<String, ExecutableElement>> targetProperties = this.unprocessedTargetProperties.entrySet().iterator();
            ArrayList<ExecutableElement> candidates = new ArrayList<ExecutableElement>(2);
            while (targetProperties.hasNext()) {
                Map.Entry<String, ExecutableElement> targetProperty = targetProperties.next();
                PropertyMapping propertyMapping = null;
                if (propertyMapping == null) {
                    for (Parameter sourceParameter : this.method.getSourceParameters()) {
                        ExecutableElement sourceAccessor2;
                        if (sourceParameter.getType().isPrimitive()) continue;
                        for (ExecutableElement sourceAccessor2 : sourceParameter.getType().getGetters()) {
                            String sourcePropertyName = Executables.getPropertyName(sourceAccessor2);
                            if (!sourcePropertyName.equals(targetProperty.getKey())) continue;
                            candidates.add(sourceAccessor2);
                        }
                        PropertyMapping newPropertyMapping = null;
                        sourceAccessor2 = this.getSourceAccessor(targetProperty.getKey(), candidates);
                        if (sourceAccessor2 != null) {
                            Mapping mapping = this.method.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                            SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(this.ctx.getTypeFactory().getReturnType(sourceAccessor2)).accessor(sourceAccessor2).name(targetProperty.getKey()).build();
                            newPropertyMapping = new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx).souceMethod(this.method).targetAccessor(targetProperty.getValue()).targetPropertyName(targetProperty.getKey()).sourceReference(sourceRef).qualifiers(mapping != null ? mapping.getQualifiers() : null).dateFormat(mapping != null ? mapping.getDateFormat() : null).build();
                            this.unprocessedSourceParameters.remove(sourceParameter);
                        }
                        candidates.clear();
                        if (propertyMapping != null && newPropertyMapping != null) {
                            this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, "Several possible source properties for target property \"" + targetProperty.getKey() + "\".", this.method.getExecutable());
                            break;
                        }
                        if (newPropertyMapping == null) continue;
                        propertyMapping = newPropertyMapping;
                    }
                }
                if (propertyMapping == null) continue;
                this.propertyMappings.add(propertyMapping);
                targetProperties.remove();
            }
        }

        private void applyParameterNameBasedMapping() {
            Iterator<Map.Entry<String, ExecutableElement>> targetProperties = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetProperties.hasNext()) {
                Map.Entry<String, ExecutableElement> targetProperty = targetProperties.next();
                Iterator<Parameter> sourceParameters = this.unprocessedSourceParameters.iterator();
                while (sourceParameters.hasNext()) {
                    Parameter sourceParameter = sourceParameters.next();
                    if (!sourceParameter.getName().equals(targetProperty.getKey())) continue;
                    Mapping mapping = this.method.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                    SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getKey()).build();
                    PropertyMapping propertyMapping = new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx).souceMethod(this.method).targetAccessor(targetProperty.getValue()).targetPropertyName(targetProperty.getKey()).sourceReference(sourceRef).qualifiers(mapping != null ? mapping.getQualifiers() : null).dateFormat(mapping != null ? mapping.getDateFormat() : null).build();
                    this.propertyMappings.add(propertyMapping);
                    targetProperties.remove();
                    sourceParameters.remove();
                }
            }
        }

        private ExecutableElement getSourceAccessor(String sourcePropertyName, List<ExecutableElement> candidates) {
            if (candidates.isEmpty()) {
                return null;
            }
            if (candidates.size() == 1) {
                return candidates.get(0);
            }
            if (candidates.size() == 2) {
                if (candidates.get(0).getSimpleName().toString().startsWith("get")) {
                    return candidates.get(0);
                }
                return candidates.get(1);
            }
            this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Found several matching getters for property \"%s\"", sourcePropertyName), this.method.getExecutable());
            return null;
        }

        private ReportingPolicy getEffectiveUnmappedTargetPolicy() {
            MapperConfig mapperSettings = MapperConfig.getInstanceOn(this.ctx.getMapperTypeElement());
            boolean setViaAnnotation = mapperSettings.isSetUnmappedTargetPolicy();
            ReportingPolicy annotationValue = ReportingPolicy.valueOf(mapperSettings.unmappedTargetPolicy());
            if (setViaAnnotation || this.ctx.getOptions().getUnmappedTargetPolicy() == null) {
                return annotationValue;
            }
            return this.ctx.getOptions().getUnmappedTargetPolicy();
        }

        private CollectionMappingStrategyPrism getEffectiveCollectionMappingStrategy() {
            MapperConfig mapperSettings = MapperConfig.getInstanceOn(this.ctx.getMapperTypeElement());
            return mapperSettings.getCollectionMappingStrategy();
        }

        private void reportErrorForUnmappedTargetPropertiesIfRequired() {
            ReportingPolicy unmappedTargetPolicy = this.getEffectiveUnmappedTargetPolicy();
            if (!this.unprocessedTargetProperties.isEmpty() && unmappedTargetPolicy.requiresReport()) {
                this.ctx.getMessager().printMessage(unmappedTargetPolicy.getDiagnosticKind(), MessageFormat.format("Unmapped target {0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", ")), this.method.getExecutable());
            }
        }
    }
}

