/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementKindVisitor6;
import javax.tools.Diagnostic;
import org.mapstruct.ap.option.Options;
import org.mapstruct.ap.option.ReportingPolicy;
import org.mapstruct.ap.processor.DefaultModelElementProcessorContext;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.util.AnnotationProcessingException;

@SupportedAnnotationTypes(value={"org.mapstruct.Mapper"})
@SupportedOptions(value={"suppressGeneratorTimestamp", "unmappedTargetPolicy", "defaultComponentModel"})
public class MappingProcessor
extends AbstractProcessor {
    private static final boolean ANNOTATIONS_CLAIMED_EXCLUSIVELY = false;
    protected static final String SUPPRESS_GENERATOR_TIMESTAMP = "suppressGeneratorTimestamp";
    protected static final String UNMAPPED_TARGET_POLICY = "unmappedTargetPolicy";
    protected static final String DEFAULT_COMPONENT_MODEL = "defaultComponentModel";
    private Options options;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.options = this.createOptions();
    }

    private Options createOptions() {
        String unmappedTargetPolicy = this.processingEnv.getOptions().get(UNMAPPED_TARGET_POLICY);
        return new Options(Boolean.valueOf(this.processingEnv.getOptions().get(SUPPRESS_GENERATOR_TIMESTAMP)), unmappedTargetPolicy != null ? ReportingPolicy.valueOf(unmappedTargetPolicy) : null, this.processingEnv.getOptions().get(DEFAULT_COMPONENT_MODEL));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        for (TypeElement typeElement : annotations) {
            if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
                TypeElement mapperTypeElement = this.asTypeElement(element);
                DefaultModelElementProcessorContext context = new DefaultModelElementProcessorContext(this.processingEnv, this.options);
                this.processMapperTypeElement(context, mapperTypeElement);
            }
        }
        return false;
    }

    private void processMapperTypeElement(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement) {
        Object model = null;
        for (ModelElementProcessor<?, ?> processor : this.getProcessors()) {
            try {
                model = this.process(context, processor, mapperTypeElement, model);
            }
            catch (AnnotationProcessingException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement(), e.getAnnotationMirror(), e.getAnnotationValue());
                break;
            }
        }
    }

    private <P, R> R process(ModelElementProcessor.ProcessorContext context, ModelElementProcessor<P, R> processor, TypeElement mapperTypeElement, Object modelElement) {
        Object sourceElement = modelElement;
        return processor.process(context, mapperTypeElement, sourceElement);
    }

    private Iterable<ModelElementProcessor<?, ?>> getProcessors() {
        Iterator<ModelElementProcessor> processorIterator = ServiceLoader.load(ModelElementProcessor.class, MappingProcessor.class.getClassLoader()).iterator();
        ArrayList processors = new ArrayList();
        while (processorIterator.hasNext()) {
            processors.add(processorIterator.next());
        }
        Collections.sort(processors, new ProcessorComparator());
        return processors;
    }

    private TypeElement asTypeElement(Element element) {
        return element.accept(new ElementKindVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitTypeAsInterface(TypeElement e, Void p) {
                return e;
            }

            @Override
            public TypeElement visitTypeAsClass(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    private static class ProcessorComparator
    implements Comparator<ModelElementProcessor<?, ?>> {
        private ProcessorComparator() {
        }

        @Override
        public int compare(ModelElementProcessor<?, ?> o1, ModelElementProcessor<?, ?> o2) {
            return o1.getPriority() < o2.getPriority() ? -1 : (o1.getPriority() == o2.getPriority() ? 0 : 1);
        }
    }
}

