/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.Collections;
import java.util.Set;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.common.ConversionContext;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.builtin.BuiltInMethod;

public class MethodReference
extends MappingMethod {
    private final MapperReference declaringMapper;
    private final Set<Type> importTypes;
    private MethodReference methodRefChild;
    private final String contextParam;

    public MethodReference(SourceMethod method, MapperReference declaringMapper, Type targetType) {
        super(method);
        this.declaringMapper = declaringMapper;
        this.contextParam = null;
        this.importTypes = targetType == null ? Collections.emptySet() : Collections.singleton(targetType);
    }

    public MethodReference(BuiltInMethod method, ConversionContext contextParam) {
        super(method);
        this.declaringMapper = null;
        this.contextParam = method.getContextParameter(contextParam);
        this.importTypes = Collections.emptySet();
    }

    public MapperReference getDeclaringMapper() {
        return this.declaringMapper;
    }

    public String getMapperVariableName() {
        return this.declaringMapper.getVariableName();
    }

    public String getContextParam() {
        return this.contextParam;
    }

    public Type getSingleSourceParameterType() {
        for (Parameter parameter : this.getSourceParameters()) {
            if (parameter.isTargetType()) continue;
            return parameter.getType();
        }
        return null;
    }

    public void setMethodRefChild(MethodReference methodRefChild) {
        this.methodRefChild = methodRefChild;
    }

    public MethodReference getMethodRefChild() {
        return this.methodRefChild;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> imported = super.getImportTypes();
        imported.addAll(this.importTypes);
        if (this.methodRefChild != null) {
            imported.addAll(this.methodRefChild.getImportTypes());
        }
        return imported;
    }
}

