/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.SimpleConversion;
import org.mapstruct.ap.model.common.ConversionContext;
import org.mapstruct.ap.util.NativeTypes;
import org.mapstruct.ap.util.Strings;

public class PrimitiveToStringConversion
extends SimpleConversion {
    private final Class<?> sourceType;
    private final Class<?> wrapperType;

    public PrimitiveToStringConversion(Class<?> sourceType) {
        if (!sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no primitive type.");
        }
        this.sourceType = sourceType;
        this.wrapperType = NativeTypes.getWrapperType(sourceType);
    }

    @Override
    public String getToConversionString(String sourceReference, ConversionContext conversionContext) {
        return "String.valueOf( " + sourceReference + " )";
    }

    @Override
    public String getFromConversionString(String targetReference, ConversionContext conversionContext) {
        return this.wrapperType.getSimpleName() + ".parse" + Strings.capitalize(this.sourceType.getSimpleName()) + "( " + targetReference + " )";
    }
}

