/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.model.Parameter;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.model.source.IterableMapping;
import org.mapstruct.ap.model.source.MapMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.util.Strings;

public class Method {
    private final Type declaringMapper;
    private final ExecutableElement executable;
    private final List<Parameter> parameters;
    private final Type returnType;
    private Map<String, Mapping> mappings;
    private IterableMapping iterableMapping;
    private MapMapping mapMapping;
    private final Parameter targetParameter;

    public static Method forMethodRequiringImplementation(ExecutableElement executable, List<Parameter> parameters, Type returnType, Map<String, Mapping> mappings, IterableMapping iterableMapping, MapMapping mapMapping) {
        return new Method(null, executable, parameters, returnType, mappings, iterableMapping, mapMapping);
    }

    public static Method forReferencedMethod(Type declaringMapper, ExecutableElement executable, List<Parameter> parameters, Type returnType) {
        return new Method(declaringMapper, executable, parameters, returnType, Collections.<String, Mapping>emptyMap(), null, null);
    }

    private Method(Type declaringMapper, ExecutableElement executable, List<Parameter> parameters, Type returnType, Map<String, Mapping> mappings, IterableMapping iterableMapping, MapMapping mapMapping) {
        this.declaringMapper = declaringMapper;
        this.executable = executable;
        this.parameters = parameters;
        this.returnType = returnType;
        this.mappings = mappings;
        this.iterableMapping = iterableMapping;
        this.mapMapping = mapMapping;
        this.targetParameter = this.determineTargetParameter(parameters);
    }

    private Parameter determineTargetParameter(Iterable<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isMappingTarget()) continue;
            return parameter;
        }
        return null;
    }

    public Type getDeclaringMapper() {
        return this.declaringMapper;
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    public String getName() {
        return this.executable.getSimpleName().toString();
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Parameter> getSourceParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter parameter : this.parameters) {
            if (parameter.isMappingTarget()) continue;
            sourceParameters.add(parameter);
        }
        return sourceParameters;
    }

    public List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.parameters.size());
        for (Parameter parameter : this.parameters) {
            parameterNames.add(parameter.getName());
        }
        return parameterNames;
    }

    public Type getResultType() {
        return this.targetParameter != null ? this.targetParameter.getType() : this.returnType;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Mapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, Mapping> mappings) {
        this.mappings = mappings;
    }

    public IterableMapping getIterableMapping() {
        return this.iterableMapping;
    }

    public void setIterableMapping(IterableMapping iterableMapping) {
        this.iterableMapping = iterableMapping;
    }

    public MapMapping getMapMapping() {
        return this.mapMapping;
    }

    public void setMapMapping(MapMapping mapMapping) {
        this.mapMapping = mapMapping;
    }

    public boolean reverses(Method method) {
        return this.getSourceParameters().size() == 1 && method.getSourceParameters().size() == 1 && this.equals(this.getSourceParameters().iterator().next().getType(), method.getResultType()) && this.equals(this.getResultType(), method.getSourceParameters().iterator().next().getType());
    }

    public Parameter getTargetParameter() {
        return this.targetParameter;
    }

    public boolean isIterableMapping() {
        return this.getSourceParameters().size() == 1 && this.getSourceParameters().iterator().next().getType().isIterableType() && this.getResultType().isIterableType();
    }

    public boolean isMapMapping() {
        return this.getSourceParameters().size() == 1 && this.getSourceParameters().iterator().next().getType().isMapType() && this.getResultType().isMapType();
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public String toString() {
        return this.returnType + " " + this.getName() + "(" + Strings.join(this.parameters, ", ") + ")";
    }

    public Mapping getMapping(String targetPropertyName) {
        for (Mapping mapping : this.mappings.values()) {
            if (!mapping.getTargetName().equals(targetPropertyName)) continue;
            return mapping;
        }
        return null;
    }

    public Parameter getSourceParameter(String sourceParameterName) {
        for (Parameter parameter : this.getSourceParameters()) {
            if (!parameter.getName().equals(sourceParameterName)) continue;
            return parameter;
        }
        return null;
    }
}

