/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Generated;
import org.mapstruct.ap.model.BeanMapping;
import org.mapstruct.ap.model.Options;
import org.mapstruct.ap.model.PropertyMapping;
import org.mapstruct.ap.model.Type;

public class Mapper {
    private final String packageName;
    private final String interfaceName;
    private final String implementationName;
    private final List<BeanMapping> beanMappings;
    private final List<Type> usedMapperTypes;
    private final Options options;
    private final SortedSet<Type> importedTypes;

    public Mapper(String packageName, String interfaceName, String implementationName, List<BeanMapping> beanMappings, List<Type> usedMapperTypes, Options options) {
        this.packageName = packageName;
        this.interfaceName = interfaceName;
        this.implementationName = implementationName;
        this.beanMappings = beanMappings;
        this.usedMapperTypes = usedMapperTypes;
        this.options = options;
        this.importedTypes = this.determineImportedTypes();
    }

    private SortedSet<Type> determineImportedTypes() {
        TreeSet<Type> importedTypes = new TreeSet<Type>();
        importedTypes.add(Type.forClass(Generated.class));
        for (BeanMapping beanMapping : this.beanMappings) {
            this.addWithDependents(importedTypes, beanMapping.getSourceType());
            this.addWithDependents(importedTypes, beanMapping.getTargetType());
            for (PropertyMapping propertyMapping : beanMapping.getPropertyMappings()) {
                this.addWithDependents(importedTypes, propertyMapping.getSourceType());
                this.addWithDependents(importedTypes, propertyMapping.getTargetType());
            }
        }
        return importedTypes;
    }

    private void addWithDependents(Collection<Type> collection, Type typeToAdd) {
        if (typeToAdd == null) {
            return;
        }
        if (typeToAdd.getPackageName() != null && !typeToAdd.getPackageName().equals(this.packageName) && !typeToAdd.getPackageName().startsWith("java.lang")) {
            collection.add(typeToAdd);
        }
        this.addWithDependents(collection, typeToAdd.getCollectionImplementationType());
        this.addWithDependents(collection, typeToAdd.getIterableImplementationType());
        this.addWithDependents(collection, typeToAdd.getElementType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Mapper {");
        sb.append("\n    packageName='" + this.packageName + "',");
        sb.append("\n    interfaceName='" + this.interfaceName + "',");
        sb.append("\n    implementationName='" + this.implementationName + "',");
        sb.append("\n    beanMappings=[");
        for (BeanMapping beanMapping : this.beanMappings) {
            sb.append("\n        " + beanMapping.toString().replaceAll("\n", "\n        "));
        }
        sb.append("\n    ]");
        sb.append("\n    usedMapperTypes=" + this.usedMapperTypes);
        sb.append("\n},");
        return sb.toString();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public List<BeanMapping> getBeanMappings() {
        return this.beanMappings;
    }

    public List<Type> getUsedMapperTypes() {
        return this.usedMapperTypes;
    }

    public Options getOptions() {
        return this.options;
    }

    public SortedSet<Type> getImportedTypes() {
        return this.importedTypes;
    }
}

