/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.UUID;
import journal.Logger;
import journal.Logger$;
import longevity.config.PersistenceConfig;
import longevity.effect.Effect;
import longevity.emblem.emblematic.Emblematic;
import longevity.emblem.emblematic.traversors.sync.EmblematicToJsonTranslator;
import longevity.emblem.emblematic.traversors.sync.JsonToEmblematicTranslator;
import longevity.emblem.exceptions.CouldNotTraverseException;
import longevity.emblem.stringUtil$;
import longevity.exceptions.persistence.NotInDomainModelTranslationException;
import longevity.model.ModelType;
import longevity.model.PType;
import longevity.model.ptype.Key;
import longevity.model.query.Query;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.DatabaseId;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.PState$;
import longevity.persistence.jdbc.JdbcCreate;
import longevity.persistence.jdbc.JdbcDelete;
import longevity.persistence.jdbc.JdbcId;
import longevity.persistence.jdbc.JdbcPRepo$;
import longevity.persistence.jdbc.JdbcQuery;
import longevity.persistence.jdbc.JdbcQuery$FilterInfo$;
import longevity.persistence.jdbc.JdbcRetrieve;
import longevity.persistence.jdbc.JdbcSchema;
import longevity.persistence.jdbc.JdbcUpdate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import streamadapter.Chunkerator;

@ScalaSignature(bytes="\u0006\u0001\rue!B\u0001\u0003\u0001\u0011A!!\u0003&eE\u000e\u0004&+\u001a9p\u0015\t\u0019A!\u0001\u0003kI\n\u001c'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\t\u0011\u0002\\8oO\u00164\u0018\u000e^=\u0016\t%\u0001\u0012\u0005J\n\t\u0001)1#&\f\u00194mA)1\u0002\u0004\b!G5\tA!\u0003\u0002\u000e\t\t)\u0001KU3q_B\u0011q\u0002\u0005\u0007\u0001\t\u0015\t\u0002A1\u0001\u0014\u0005\u000515\u0001A\u000b\u0003)y\t\"!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\u000f9{G\u000f[5oOB\u0011a\u0003H\u0005\u0003;]\u00111!\u00118z\t\u0015y\u0002C1\u0001\u0015\u0005\u0005y\u0006CA\b\"\t\u0015\u0011\u0003A1\u0001\u0015\u0005\u0005i\u0005CA\b%\t\u0015)\u0003A1\u0001\u0015\u0005\u0005\u0001\u0006#B\u0014)\u001d\u0001\u001aS\"\u0001\u0002\n\u0005%\u0012!A\u0003&eE\u000e\u001c6\r[3nCB)qe\u000b\b!G%\u0011AF\u0001\u0002\u000b\u0015\u0012\u00147m\u0011:fCR,\u0007#B\u0014/\u001d\u0001\u001a\u0013BA\u0018\u0003\u00051QEMY2SKR\u0014\u0018.\u001a<f!\u00159\u0013G\u0004\u0011$\u0013\t\u0011$AA\u0005KI\n\u001c\u0017+^3ssB)q\u0005\u000e\b!G%\u0011QG\u0001\u0002\u000b\u0015\u0012\u00147-\u00169eCR,\u0007#B\u00148\u001d\u0001\u001a\u0013B\u0001\u001d\u0003\u0005)QEMY2EK2,G/\u001a\u0005\nu\u0001\u0011\t\u0011)A\u0005w\u0001\u000ba!\u001a4gK\u000e$\bc\u0001\u001f?\u001d5\tQH\u0003\u0002;\r%\u0011q(\u0010\u0002\u0007\u000b\u001a4Wm\u0019;\n\u0005ib\u0001\"\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"J\u0003%iw\u000eZ3m)f\u0004X\rE\u0002E\u000f\u0002j\u0011!\u0012\u0006\u0003\r\u001a\tQ!\\8eK2L!\u0001S#\u0003\u00135{G-\u001a7UsB,\u0017B\u0001\"\r\u0011%Y\u0005A!A!\u0002\u0013au*A\u0003q)f\u0004X\r\u0005\u0003E\u001b\u0002\u001a\u0013B\u0001(F\u0005\u0015\u0001F+\u001f9f\u0013\tYE\u0002\u0003\u0005R\u0001\t\u0015\r\u0011\"\u0005S\u0003E\u0001XM]:jgR,gnY3D_:4\u0017nZ\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011aKB\u0001\u0007G>tg-[4\n\u0005a+&!\u0005)feNL7\u000f^3oG\u0016\u001cuN\u001c4jO\"A!\f\u0001B\u0001B\u0003%1+\u0001\nqKJ\u001c\u0018n\u001d;f]\u000e,7i\u001c8gS\u001e\u0004\u0003\u0002\u0003/\u0001\u0005\u000b\u0007I\u0011C/\u0002\u0015\r|gN\\3di&|g.F\u0001_!\r1r,Y\u0005\u0003A^\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017aA:rY*\ta-\u0001\u0003kCZ\f\u0017B\u00015d\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\tU\u0002\u0011\t\u0011)A\u0005=\u0006Y1m\u001c8oK\u000e$\u0018n\u001c8!\u0011\u0019a\u0007\u0001\"\u0001\u0005[\u00061A(\u001b8jiz\"bA\\8qcJ\u001c\b#B\u0014\u0001\u001d\u0001\u001a\u0003\"\u0002\u001el\u0001\u0004Y\u0004\"\u0002\"l\u0001\u0004\u0019\u0005\"B&l\u0001\u0004a\u0005\"B)l\u0001\u0004\u0019\u0006\"\u0002/l\u0001\u0004q\u0006bB;\u0001\u0005\u0004%\tB^\u0001\u0007Y><w-\u001a:\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT\u0011A_\u0001\bU>,(O\\1m\u0013\ta\u0018P\u0001\u0004M_\u001e<WM\u001d\u0005\u0007}\u0002\u0001\u000b\u0011B<\u0002\u000f1|wmZ3sA!Q\u0011\u0011\u0001\u0001C\u0002\u0013E!!a\u0001\u0002\u0013Q\f'\r\\3OC6,WCAA\u0003!\u0011\t9!!\u0006\u000f\t\u0005%\u0011\u0011\u0003\t\u0004\u0003\u00179RBAA\u0007\u0015\r\tyAE\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Mq#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'9\u0002\u0002CA\u000f\u0001\u0001\u0006I!!\u0002\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005C\u0006\u0002\"\u0001A)\u0019!C\t\u0005\u0005\r\u0012\u0001\u00069sS6\f'/_&fs\u000e{W\u000e]8oK:$8/\u0006\u0002\u0002&A1\u0011qEA\u0019\u0003oqA!!\u000b\u0002.9!\u00111BA\u0016\u0013\u0005A\u0012bAA\u0018/\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u00111aU3r\u0015\r\tyc\u0006\u0019\t\u0003s\t9%a\u0014\u0002VAQ\u00111HA!\u0003\u000b\ni%a\u0015\u000e\u0005\u0005u\"bAA \u000b\u0006A!/Z1mSj,G-\u0003\u0003\u0002D\u0005u\"!\u0006*fC2L'0\u001a3Qe>\u00048i\\7q_:,g\u000e\u001e\t\u0004\u001f\u0005\u001dC\u0001DA%\u0003?\t\t\u0011!A\u0003\u0002\u0005-#aA0%cE\u00111e\u0007\t\u0004\u001f\u0005=CaCA)\u0003?\t\t\u0011!A\u0003\u0002Q\u00111a\u0018\u00133!\ry\u0011Q\u000b\u0003\f\u0003/\ny\"!A\u0001\u0002\u000b\u0005ACA\u0002`IMB\u0011\"a\u0017\u0001\u0005\u0004%\t\"!\u0018\u0002)\u0005\u001cG/^1mSj,GmQ8na>tWM\u001c;t+\t\ty\u0006\u0005\u0004\u0002b\u0005-\u0014qN\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003S:\u0012AC2pY2,7\r^5p]&!\u0011QNA2\u0005\r\u0019V\r\u001e\u0019\t\u0003c\n)(!\"\u0002\fBQ\u00111HA!\u0003g\n\u0019)!#\u0011\u0007=\t)\b\u0002\u0007\u0002x\u0005e\u0014\u0011!A\u0001\u0006\u0003\tYEA\u0002`IYB\u0001\"a\u001f\u0001\t#\u0011\u0011QP\u0001\u0012S:$W\r_3e\u0007>l\u0007o\u001c8f]R\u001cXCAA@!\u0019\t9!!!\u0002p%!\u0011QNA\r!\ry\u0011Q\u0011\u0003\f\u0003\u000f\u000bI(!A\u0001\u0002\u000b\u0005ACA\u0002`I]\u00022aDAF\t-\ti)!\u001f\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\u0007}#\u0003\b\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BA0\u0003U\t7\r^;bY&TX\rZ\"p[B|g.\u001a8ug\u0002B\u0011\"!&\u0001\u0005\u0004%\t\"a&\u00025\u0015l'\r\\3nCRL7\rV8Kg>tGK]1og2\fGo\u001c:\u0016\u0005\u0005e\u0005\u0003BAN\u0003[k!!!(\u000b\t\u0005}\u0015\u0011U\u0001\u0005gft7M\u0003\u0003\u0002$\u0006\u0015\u0016A\u0003;sCZ,'o]8sg*!\u0011qUAU\u0003))WN\u00197f[\u0006$\u0018n\u0019\u0006\u0004\u0003W3\u0011AB3nE2,W.\u0003\u0003\u00020\u0006u%AG#nE2,W.\u0019;jGR{'j]8o)J\fgn\u001d7bi>\u0014\b\u0002CAZ\u0001\u0001\u0006I!!'\u00027\u0015l'\r\\3nCRL7\rV8Kg>tGK]1og2\fGo\u001c:!\u0011%\t9\f\u0001b\u0001\n#\tI,\u0001\u000ekg>tGk\\#nE2,W.\u0019;jGR\u0013\u0018M\\:mCR|'/\u0006\u0002\u0002<B!\u00111TA_\u0013\u0011\ty,!(\u00035)\u001bxN\u001c+p\u000b6\u0014G.Z7bi&\u001cGK]1og2\fGo\u001c:\t\u0011\u0005\r\u0007\u0001)A\u0005\u0003w\u000b1D[:p]R{W)\u001c2mK6\fG/[2Ue\u0006t7\u000f\\1u_J\u0004\u0003bBAd\u0001\u0011E\u0011\u0011Z\u0001\u000bG>dW/\u001c8OC6,G\u0003BAf\u0003+\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0004\u0003#,\u0017\u0001\u00027b]\u001eLA!a\u0006\u0002P\"A\u0011q[Ac\u0001\u0004\tI.\u0001\u0003qe>\u0004\b\u0007CAn\u0003?\f)/a;\u0011\u0015\u0005m\u0012\u0011IAo\u0003G\fI\u000fE\u0002\u0010\u0003?$1\"!9\u0002V\u0006\u0005\t\u0011!B\u0001)\t!q\fJ\u00198!\ry\u0011Q\u001d\u0003\f\u0003O\f).!A\u0001\u0002\u000b\u0005AC\u0001\u0003`IEB\u0004cA\b\u0002l\u0012Y\u0011Q^Ak\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\u0011yF%M\u001d\t\u000f\u0005E\b\u0001\"\u0005\u0002t\u0006Q1oY8sK\u0012\u0004\u0016\r\u001e5\u0015\t\u0005-\u0017Q\u001f\u0005\t\u0003/\fy\u000f1\u0001\u0002xBB\u0011\u0011`A\u007f\u0005\u0007\u0011I\u0001\u0005\u0006\u0002<\u0005\u0005\u00131 B\u0001\u0005\u000f\u00012aDA\u007f\t-\ty0!>\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\t}##\u0007\r\t\u0004\u001f\t\rAa\u0003B\u0003\u0003k\f\t\u0011!A\u0003\u0002Q\u0011Aa\u0018\u00133cA\u0019qB!\u0003\u0005\u0017\t-\u0011Q_A\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\u0012$\u0007C\u0004\u0003\u0010\u0001!\tB!\u0005\u0002\u001d)\u001cxN\\*ue&twMR8s!R!\u0011Q\u0001B\n\u0011\u001d\u0011)B!\u0004A\u0002\r\n\u0011\u0001\u001d\u0005\b\u00053\u0001A\u0011\u0003B\u000e\u0003E)\b\u000fZ1uK\u000e{G.^7o\u001d\u0006lWm\u001d\u000b\u0005\u0005;\u0011y\u0002\u0005\u0004\u0002(\u0005E\u0012Q\u0001\u0005\u000b\u0005C\u00119\u0002%AA\u0002\t\r\u0012\u0001C5t\u0007J,\u0017\r^3\u0011\u0007Y\u0011)#C\u0002\u0003(]\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0003,\u0001!\tB!\f\u0002%U\u0004H-\u0019;f\u0007>dW/\u001c8WC2,Xm\u001d\u000b\u0007\u0005_\u00119D!\u0011\u0011\r\u0005\u001d\u0012\u0011\u0007B\u0019!\r1\"1G\u0005\u0004\u0005k9\"AB!osJ+g\r\u0003\u0005\u0003:\t%\u0002\u0019\u0001B\u001e\u0003\u0015\u0019H/\u0019;f!\u0011Y!QH\u0012\n\u0007\t}BA\u0001\u0004Q'R\fG/\u001a\u0005\u000b\u0005C\u0011I\u0003%AA\u0002\t\r\u0002b\u0002B#\u0001\u0011E!qI\u0001\u0005kVLG\r\u0006\u0003\u0003J\tU\u0003\u0003\u0002B&\u0005#j!A!\u0014\u000b\u0007\t=S-\u0001\u0003vi&d\u0017\u0002\u0002B*\u0005\u001b\u0012A!V+J\t\"A!\u0011\bB\"\u0001\u0004\u0011Y\u0004C\u0004\u0003Z\u0001!\t\"a\u0001\u0002!]DWM]3BgNLwM\\7f]R\u001c\bb\u0002B/\u0001\u0011E!qL\u0001\u000eo\",'/\u001a\"j]\u0012LgnZ:\u0015\t\t\u0005$q\r\t\u0007\u0005G\u0012)G!\r\u000e\u0005\u0005\u001d\u0014\u0002BA\u001a\u0003OB\u0001B!\u000f\u0003\\\u0001\u0007!1\b\u0005\b\u0005W\u0002A\u0011\u0002B7\u00039\u0001(o\u001c9WC2\u0014\u0015N\u001c3j]\u001e,bAa\u001c\u0003|\t\u001dEC\u0002B\u0019\u0005c\u0012Y\t\u0003\u0005\u0003t\t%\u0004\u0019\u0001B;\u0003%\u0019w.\u001c9p]\u0016tG\u000f\r\u0003\u0003x\t\u0005\u0005CCA\u001e\u0003\u0003\u0012IHa \u0003\u0006B\u0019qBa\u001f\u0005\u0011\tu$\u0011\u000eb\u0001\u0003\u0017\u0012!\u0001\u0015)\u0011\u0007=\u0011\t\tB\u0006\u0003\u0004\nE\u0014\u0011!A\u0001\u0006\u0003!\"\u0001B0%ee\u00022a\u0004BD\t\u001d\u0011II!\u001bC\u0002Q\u0011\u0011!\u0011\u0005\b\u0005+\u0011I\u00071\u0001$\u0011\u001d\u0011y\t\u0001C\t\u0005#\u000b\u0011B\u001b3cGZ\u000bG.^3\u0015\t\tE\"1\u0013\u0005\b\u0005+\u0013i\t1\u0001\u001c\u0003\u00151\u0018\r\\;f\u0011\u001d\u0011I\n\u0001C\t\u00057\u000b\u0001B\u001b3cG\u0012\u000bG/\u001a\u000b\u0005\u0005;\u0013\u0019\u000b\u0005\u0003\u0003L\t}\u0015\u0002\u0002BQ\u0005\u001b\u0012A\u0001R1uK\"A!Q\u0015BL\u0001\u0004\u00119+A\u0001e!\u0011\u0011IKa.\u000e\u0005\t-&\u0002\u0002BW\u0005_\u000bA\u0001^5nK*!!\u0011\u0017BZ\u0003\u0011Qw\u000eZ1\u000b\u0005\tU\u0016aA8sO&!!\u0011\u0018BV\u0005!!\u0015\r^3US6,\u0007b\u0002B_\u0001\u0011E!qX\u0001\u0016e\u0016$(/[3wK\u001a\u0013x.\u001c*fgVdGoU3u)\u0019\u0011YD!1\u0003L\"A!1\u0019B^\u0001\u0004\u0011)-A\u0005sKN,H\u000e^*fiB\u0019!Ma2\n\u0007\t%7MA\u0005SKN,H\u000e^*fi\"Q!Q\u001aB^!\u0003\u0005\rAa\t\u0002\u00135LwM]1uS:<\u0007b\u0002Bi\u0001\u0011E!1[\u0001\u001dG>tg/\u001a:u\tV\u0004H.[2bi\u0016\\U-_#yG\u0016\u0004H/[8o)\u0011\u0011)Na:\u0011\u000fY\u00119Na7\u0003b&\u0019!\u0011\\\f\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004B!a\n\u0003^&!!q\\A\u001b\u0005%!\u0006N]8xC\ndW\rE\u0002\u0017\u0005GL1A!:\u0018\u0005\u0011)f.\u001b;\t\u0011\te\"q\u001aa\u0001\u0005wAqAa;\u0001\t\u0003\u0012i/\u0001\u0005u_N#(/\u001b8h)\t\t)\u0001C\u0005\u0003r\u0002\t\n\u0011\"\u0005\u0003t\u0006YR\u000f\u001d3bi\u0016\u001cu\u000e\\;n]:\u000bW.Z:%I\u00164\u0017-\u001e7uIE*\"A!>+\t\t\r\"q_\u0016\u0003\u0005s\u0004BAa?\u0004\u00065\u0011!Q \u0006\u0005\u0005\u007f\u001c\t!A\u0005v]\u000eDWmY6fI*\u001911A\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\b\tu(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I11\u0002\u0001\u0012\u0002\u0013E!1_\u0001\u001dkB$\u0017\r^3D_2,XN\u001c,bYV,7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011%\u0019y\u0001AI\u0001\n#\u0011\u00190A\u0010sKR\u0014\u0018.\u001a<f\rJ|WNU3tk2$8+\u001a;%I\u00164\u0017-\u001e7uIIBQba\u0005\u0001!\u0003\r\t\u0011!C\u0005\u0007+I\u0015aD:va\u0016\u0014H%\\8eK2$\u0016\u0010]3\u0016\u0003\r;\u0001b!\u0007\u0003\u0011\u0003!11D\u0001\n\u0015\u0012\u00147\r\u0015*fa>\u00042aJB\u000f\r\u001d\t!\u0001#\u0001\u0005\u0007?\u0019Ba!\b\u00032!9An!\b\u0005\u0002\r\rBCAB\u000e\u0011!\u00199c!\b\u0005\u0002\r%\u0012!B1qa2LX\u0003CB\u0016\u0007c\u0019Id!\u0010\u0015\u001d\r52qHB\"\u0007\u000f\u001aYe!\u0014\u0004xAAq\u0005AB\u0018\u0007o\u0019Y\u0004E\u0002\u0010\u0007c!q!EB\u0013\u0005\u0004\u0019\u0019$F\u0002\u0015\u0007k!aaHB\u0019\u0005\u0004!\u0002cA\b\u0004:\u00111!e!\nC\u0002Q\u00012aDB\u001f\t\u0019)3Q\u0005b\u0001)!9!h!\nA\u0002\r\u0005\u0003\u0003\u0002\u001f?\u0007_AqAQB\u0013\u0001\u0004\u0019)\u0005\u0005\u0003E\u000f\u000e]\u0002bB&\u0004&\u0001\u00071\u0011\n\t\u0007\t6\u001b9da\u000f\t\rY\u001b)\u00031\u0001T\u0011!\u0019ye!\nA\u0002\rE\u0013a\u00039pYf\u0014V\r]8PaR\u0004RAFB*\u0007/J1a!\u0016\u0018\u0005\u0019y\u0005\u000f^5p]B\"1\u0011LB/!!9\u0003aa\f\u00048\rm\u0003cA\b\u0004^\u0011a1qLB1\u0003\u0003\u0005\tQ!\u0001\u0004v\t!q\fJ\u001a1\u0011!\u0019ye!\nA\u0002\r\r\u0004#\u0002\f\u0004T\r\u0015\u0004\u0007BB4\u0007_\u0002\u0002b\n\u0001\u0004j\r-4Q\u000e\t\u0004\u001f\rE\u0002cA\b\u0004:A\u0019qba\u001c\u0005\u0019\r}3\u0011MA\u0001\u0002\u0003\u0015\ta!\u001d\u0012\u0007\rM4\u0004E\u0002\u0010\u0007{\t2aa\u000f\u001c\u0011\u0019a6Q\u0005a\u0001=\"Y11PB\u000f\u0005\u0004%\tAAB?\u0003=\u0011\u0017m]5d)>TEMY2UsB,WCAB@!!\t\tg!!\u0004\u0006\u0006-\u0017\u0002BBB\u0003G\u00121!T1qa\u0011\u00199i!&\u0011\r\r%5qRBJ\u001b\t\u0019YI\u0003\u0002\u0004\u000e\u00069A/\u001f9fW\u0016L\u0018\u0002BBI\u0007\u0017\u0013q\u0001V=qK.+\u0017\u0010E\u0002\u0010\u0007+#1ba&\u0004\u001a\u0006\u0005\t\u0011!B\u0001)\t!q\fJ\u001a2\u0011%\u0019Yj!\b!\u0002\u0013\u0019y(\u0001\tcCNL7\rV8KI\n\u001cG+\u001f9fA\u0001")
public class JdbcPRepo<F, M, P>
extends PRepo<F, M, P>
implements JdbcSchema<F, M, P>,
JdbcCreate<F, M, P>,
JdbcRetrieve<F, M, P>,
JdbcQuery<F, M, P>,
JdbcUpdate<F, M, P>,
JdbcDelete<F, M, P> {
    private Seq<RealizedPropComponent<? super P, ?, ?>> primaryKeyComponents;
    private final PersistenceConfig persistenceConfig;
    private final Function0<Connection> connection;
    private final Logger logger;
    private final String tableName;
    private final Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents;
    private final EmblematicToJsonTranslator emblematicToJsonTranslator;
    private final JsonToEmblematicTranslator jsonToEmblematicTranslator;
    private String longevity$persistence$jdbc$JdbcUpdate$$updateMigrationStartedSql;
    private String longevity$persistence$jdbc$JdbcUpdate$$updateMigrationCompleteSql;
    private volatile JdbcQuery$FilterInfo$ FilterInfo$module;
    private Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    private String longevity$persistence$jdbc$JdbcCreate$$insertSql;
    private volatile byte bitmap$0;

    public static <F, M, P> JdbcPRepo<F, M, P> apply(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Option<JdbcPRepo<F, M, ? super P>> option, Function0<Connection> function0) {
        return JdbcPRepo$.MODULE$.apply(effect, modelType, pType, persistenceConfig, option, function0);
    }

    @Override
    public F delete(PState<P> state) {
        return (F)JdbcDelete.delete$(this, state);
    }

    @Override
    public F update(PState<P> state) {
        return (F)JdbcUpdate.update$(this, state);
    }

    @Override
    public F updateMigrationStarted(PState<P> state) {
        return (F)JdbcUpdate.updateMigrationStarted$(this, state);
    }

    @Override
    public F updateMigrationComplete(PState<P> state) {
        return (F)JdbcUpdate.updateMigrationComplete$(this, state);
    }

    @Override
    public Chunkerator<PState<P>> queryToChunkerator(Query<P> query) {
        return JdbcQuery.queryToChunkerator$(this, query);
    }

    @Override
    public String queryWhereClause(JdbcQuery.FilterInfo filterInfo) {
        return JdbcQuery.queryWhereClause$(this, filterInfo);
    }

    @Override
    public <V> F retrieve(V keyVal2, Key<M, P, V> evidence$1) {
        return (F)JdbcRetrieve.retrieve$(this, keyVal2, evidence$1);
    }

    @Override
    public Option<PState<P>> retrieveFromPreparedStatement(PreparedStatement statement) {
        return JdbcRetrieve.retrieveFromPreparedStatement$(this, statement);
    }

    @Override
    public String keyValSelectStatementConjunction(RealizedKey<M, P, ?> key) {
        return JdbcRetrieve.keyValSelectStatementConjunction$(this, key);
    }

    @Override
    public F create(P p) {
        return (F)JdbcCreate.create$(this, p);
    }

    @Override
    public F createState(PState<P> state) {
        return (F)JdbcCreate.createState$(this, state);
    }

    @Override
    public void createSchemaBlocking() {
        JdbcSchema.createSchemaBlocking$(this);
    }

    @Override
    public void createTable() {
        JdbcSchema.createTable$(this);
    }

    @Override
    public void addColumn(String columnName, String columnType) {
        JdbcSchema.addColumn$(this, columnName, columnType);
    }

    @Override
    public <A> String componentToJdbcType(RealizedPropComponent<? super P, ?, A> component2) {
        return JdbcSchema.componentToJdbcType$(this, component2);
    }

    @Override
    public void createUniqueIndexes() {
        JdbcSchema.createUniqueIndexes$(this);
    }

    @Override
    public void createNonUniqueIndexes() {
        JdbcSchema.createNonUniqueIndexes$(this);
    }

    @Override
    public void createIndex(boolean unique, String indexName, Seq<String> columnNames) {
        JdbcSchema.createIndex$(this, unique, indexName, columnNames);
    }

    @Override
    public void createMigrationSchemaBlocking() {
        JdbcSchema.createMigrationSchemaBlocking$(this);
    }

    @Override
    public void dropSchemaBlocking() {
        JdbcSchema.dropSchemaBlocking$(this);
    }

    private String longevity$persistence$jdbc$JdbcUpdate$$updateMigrationStartedSql$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationStartedSql = JdbcUpdate.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationStartedSql$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationStartedSql;
    }

    @Override
    public String longevity$persistence$jdbc$JdbcUpdate$$updateMigrationStartedSql() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationStartedSql$lzycompute() : this.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationStartedSql;
    }

    private String longevity$persistence$jdbc$JdbcUpdate$$updateMigrationCompleteSql$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationCompleteSql = JdbcUpdate.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationCompleteSql$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationCompleteSql;
    }

    @Override
    public String longevity$persistence$jdbc$JdbcUpdate$$updateMigrationCompleteSql() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationCompleteSql$lzycompute() : this.longevity$persistence$jdbc$JdbcUpdate$$updateMigrationCompleteSql;
    }

    @Override
    public JdbcQuery$FilterInfo$ FilterInfo() {
        if (this.FilterInfo$module == null) {
            this.FilterInfo$lzycompute$1();
        }
        return this.FilterInfo$module;
    }

    private Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement = JdbcRetrieve.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    }

    @Override
    public Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$lzycompute() : this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    }

    private String longevity$persistence$jdbc$JdbcCreate$$insertSql$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.longevity$persistence$jdbc$JdbcCreate$$insertSql = JdbcCreate.longevity$persistence$jdbc$JdbcCreate$$insertSql$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.longevity$persistence$jdbc$JdbcCreate$$insertSql;
    }

    @Override
    public String longevity$persistence$jdbc$JdbcCreate$$insertSql() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.longevity$persistence$jdbc$JdbcCreate$$insertSql$lzycompute() : this.longevity$persistence$jdbc$JdbcCreate$$insertSql;
    }

    public /* synthetic */ ModelType longevity$persistence$jdbc$JdbcPRepo$$super$modelType() {
        return super.modelType();
    }

    public PersistenceConfig persistenceConfig() {
        return this.persistenceConfig;
    }

    public Function0<Connection> connection() {
        return this.connection;
    }

    public Logger logger() {
        return this.logger;
    }

    public String tableName() {
        return this.tableName;
    }

    private Seq<RealizedPropComponent<? super P, ?, ?>> primaryKeyComponents$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq seq;
                Option option = this.realizedPType().primaryKey();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
                    seq = (Seq)key.props().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
                } else if (None$.MODULE$.equals(option)) {
                    seq = (Seq)Seq$.MODULE$.empty();
                } else {
                    throw new MatchError(option);
                }
                this.primaryKeyComponents = seq;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.primaryKeyComponents;
    }

    public Seq<RealizedPropComponent<? super P, ?, ?>> primaryKeyComponents() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.primaryKeyComponents$lzycompute() : this.primaryKeyComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents() {
        return this.actualizedComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> indexedComponents() {
        Set keyComponents = (Set)((TraversableLike)this.realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JdbcPRepo.$anonfun$indexedComponents$1(x$2)))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.realizedProp().realizedPropComponents(), Set$.MODULE$.canBuildFrom());
        Set props = (Set)super.pType().indexSet().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.props(), Set$.MODULE$.canBuildFrom());
        Set realizedProps = (Set)props.map((Function1 & Serializable & scala.Serializable)x$5 -> (RealizedProp)this.realizedPType().realizedProps().apply(x$5), Set$.MODULE$.canBuildFrom());
        Set indexComponents = (Set)((GenericTraversableTemplate)realizedProps.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.realizedPropComponents(), Set$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return (Set)keyComponents.$plus$plus((GenTraversableOnce)indexComponents);
    }

    public EmblematicToJsonTranslator emblematicToJsonTranslator() {
        return this.emblematicToJsonTranslator;
    }

    public JsonToEmblematicTranslator jsonToEmblematicTranslator() {
        return this.jsonToEmblematicTranslator;
    }

    public String columnName(RealizedPropComponent<?, ?, ?> prop) {
        return "prop_" + this.scoredPath(prop);
    }

    public String scoredPath(RealizedPropComponent<?, ?, ?> prop) {
        return prop.outerPropPath().inlinedPath().replace('.', '_');
    }

    public String jsonStringForP(P p) {
        String string;
        try {
            JsonAST.JValue x$21 = this.emblematicToJsonTranslator().translate(p, this.pTypeKey());
            Formats x$22 = JsonMethods$.MODULE$.render$default$2(x$21);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$21, x$22));
        }
        catch (CouldNotTraverseException e) {
            throw new NotInDomainModelTranslationException(e.typeKey().name(), e);
        }
        return string;
    }

    public Seq<String> updateColumnNames(boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnNames = isCreate ? this.names$1(this.actualizedComponents()) : this.names$1(this.indexedComponents());
        String string = "p";
        Seq withP = (Seq)componentColumnNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            String string2 = "created_timestamp";
            String string3 = "updated_timestamp";
            seq3 = (Seq)((SeqLike)withP.$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            String string4 = "row_version";
            seq2 = (Seq)withDateTimes.$plus$colon((Object)string4, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            String string5 = "id";
            seq = (Seq)withRowVersion.$plus$colon((Object)string5, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        return seq;
    }

    public boolean updateColumnNames$default$1() {
        return true;
    }

    public Seq<Object> updateColumnValues(PState<P> state, boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnValues = isCreate ? this.values$1(this.actualizedComponents(), state) : this.values$1(this.indexedComponents(), state);
        String string = this.jsonStringForP(state.get());
        Seq withP = (Seq)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            Object object = state.createdTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.jdbcValue(value)).orNull(Predef$.MODULE$.$conforms());
            Object object2 = state.updatedTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.jdbcValue(value)).orNull(Predef$.MODULE$.$conforms());
            seq3 = (Seq)((SeqLike)withP.$plus$colon(object2, Seq$.MODULE$.canBuildFrom())).$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            Object object = state.rowVersionOrNull();
            seq2 = (Seq)withDateTimes.$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            UUID uUID = this.uuid(state);
            seq = (Seq)withRowVersion.$plus$colon((Object)uUID, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        return seq;
    }

    public boolean updateColumnValues$default$2() {
        return true;
    }

    public UUID uuid(PState<P> state) {
        return ((JdbcId)state.id().get()).uuid();
    }

    public String whereAssignments() {
        return this.hasPrimaryKey() ? ((TraversableOnce)((TraversableLike)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString("\nAND\n  ") : "id = :id";
    }

    public Seq<Object> whereBindings(PState<P> state) {
        return this.hasPrimaryKey() ? (Seq)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.outerPropPath().get().apply(state.get()), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{((JdbcId)state.id().get()).uuid()}));
    }

    private <PP, A> Object propValBinding(RealizedPropComponent<PP, ?, A> component2, P p) {
        return this.jdbcValue(component2.outerPropPath().get().apply(p));
    }

    public Object jdbcValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object2);
            object = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
        } else if (object2 instanceof DateTime) {
            DateTime dateTime = (DateTime)object2;
            object = this.jdbcDate(dateTime);
        } else {
            object = value;
        }
        return object;
    }

    public Date jdbcDate(DateTime d) {
        return new Date(d.getMillis());
    }

    public PState<P> retrieveFromResultSet(ResultSet resultSet, boolean migrating) {
        Tuple2.mcZZ.sp sp2;
        Tuple2 tuple2;
        None$ id = !this.hasPrimaryKey() ? new Some((Object)new JdbcId(UUID.fromString(resultSet.getString("id")))) : None$.MODULE$;
        None$ rowVersion = this.persistenceConfig().optimisticLocking() ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)resultSet.getLong("row_version"))) : None$.MODULE$;
        Tuple2 tuple22 = tuple2 = this.persistenceConfig().writeTimestamps() ? new Tuple2((Object)JdbcPRepo.toOptDateTime$1("created_timestamp", resultSet), (Object)JdbcPRepo.toOptDateTime$1("updated_timestamp", resultSet)) : new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option createdTimestamp = (Option)tuple2._1();
        Option updatedTimestamp = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)createdTimestamp, (Object)updatedTimestamp);
        Tuple2 tuple24 = tuple23;
        Option createdTimestamp2 = (Option)tuple24._1();
        Option updatedTimestamp2 = (Option)tuple24._2();
        Tuple2.mcZZ.sp sp3 = sp2 = migrating ? new Tuple2.mcZZ.sp(resultSet.getBoolean("migration_started"), resultSet.getBoolean("migration_complete")) : new Tuple2.mcZZ.sp(false, false);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        boolean migrationStarted = sp2._1$mcZ$sp();
        boolean migrationComplete = sp2._2$mcZ$sp();
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(migrationStarted, migrationComplete);
        Tuple2.mcZZ.sp sp5 = sp4;
        boolean migrationStarted2 = sp5._1$mcZ$sp();
        boolean migrationComplete2 = sp5._2$mcZ$sp();
        JsonAST.JValue json = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(resultSet.getString("p")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Object p = this.jsonToEmblematicTranslator().translate(json, this.pTypeKey());
        return PState$.MODULE$.apply((Option<DatabaseId>)id, (Option<Object>)rowVersion, (Option<DateTime>)createdTimestamp2, (Option<DateTime>)updatedTimestamp2, migrationStarted2, migrationComplete2, p, p);
    }

    public boolean retrieveFromResultSet$default$2() {
        return false;
    }

    public PartialFunction<Throwable, BoxedUnit> convertDuplicateKeyException(PState<P> state) {
        return PartialFunction$.MODULE$.empty();
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JdbcPRepo[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pTypeKey().name()}));
    }

    private final void FilterInfo$lzycompute$1() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if (this.FilterInfo$module == null) {
                this.FilterInfo$module = new JdbcQuery$FilterInfo$(this);
            }
        }
    }

    private final String raw$1() {
        return stringUtil$.MODULE$.camelToUnderscore(stringUtil$.MODULE$.typeName(this.pTypeKey().tpe()));
    }

    public static final /* synthetic */ boolean $anonfun$indexedComponents$1(RealizedKey x$2) {
        return x$2 instanceof RealizedPrimaryKey;
    }

    private final Seq names$1(Set components) {
        return (Seq)((SetLike)components.map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private final Seq values$1(Set components, PState state$1) {
        return (Seq)((TraversableLike)components.toSeq().sortBy((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)component2 -> this.propValBinding((RealizedPropComponent)component2, state$1.get()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Option toOptDateTime$1(String c, ResultSet resultSet$1) {
        return Option$.MODULE$.apply((Object)resultSet$1.getDate(c)).map((Function1 & Serializable & scala.Serializable)x$18 -> new DateTime(x$18, DateTimeZone.UTC));
    }

    public JdbcPRepo(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Function0<Connection> connection) {
        String string;
        this.persistenceConfig = persistenceConfig;
        this.connection = connection;
        super(effect, modelType, pType);
        JdbcSchema.$init$(this);
        JdbcCreate.$init$(this);
        JdbcRetrieve.$init$(this);
        JdbcQuery.$init$(this);
        JdbcUpdate.$init$(this);
        JdbcDelete.$init$(this);
        this.logger = Logger$.MODULE$.apply(ManifestFactory$.MODULE$.singleType((Object)this));
        Option<String> option = persistenceConfig.modelVersion();
        if (option instanceof Some) {
            Some some = (Some)option;
            String v = (String)some.value();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.raw$1(), v}));
        } else if (None$.MODULE$.equals(option)) {
            string = this.raw$1();
        } else {
            throw new MatchError(option);
        }
        this.tableName = string;
        this.actualizedComponents = (Set)this.indexedComponents().$plus$plus(this.primaryKeyComponents());
        this.emblematicToJsonTranslator = new EmblematicToJsonTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$jdbc$JdbcPRepo$$super$modelType().emblematic();
            }
        };
        this.jsonToEmblematicTranslator = new JsonToEmblematicTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$jdbc$JdbcPRepo$$super$modelType().emblematic();
            }
        };
    }
}

