/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import java.io.Serializable;
import longevity.config.CassandraConfig;
import longevity.config.PersistenceConfig;
import longevity.effect.Effect;
import longevity.exceptions.persistence.ConnectionClosedException;
import longevity.exceptions.persistence.ConnectionOpenException;
import longevity.exceptions.persistence.cassandra.KeyspaceDoesNotExistException;
import longevity.model.ModelType;
import longevity.model.PType;
import longevity.persistence.Repo;
import longevity.persistence.cassandra.CassandraPRepo;
import longevity.persistence.cassandra.CassandraPRepo$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\u0001\u0003\u0001\u0011A!!D\"bgN\fg\u000e\u001a:b%\u0016\u0004xN\u0003\u0002\u0004\t\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u000b\u0019\t1\u0002]3sg&\u001cH/\u001a8dK*\tq!A\u0005m_:<WM^5usV\u0019\u0011\u0002E\u0011\u0014\u0005\u0001Q\u0001\u0003B\u0006\r\u001d\u0001j\u0011\u0001B\u0005\u0003\u001b\u0011\u0011AAU3q_B\u0011q\u0002\u0005\u0007\u0001\t\u0015\t\u0002A1\u0001\u0014\u0005\u000515\u0001A\u000b\u0003)y\t\"!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\u000f9{G\u000f[5oOB\u0011a\u0003H\u0005\u0003;]\u00111!\u00118z\t\u0015y\u0002C1\u0001\u0015\u0005\u0005y\u0006CA\b\"\t\u0015\u0011\u0003A1\u0001\u0015\u0005\u0005i\u0005\"\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013+\u0003\u0019)gMZ3diB\u0019a\u0005\u000b\b\u000e\u0003\u001dR!\u0001\n\u0004\n\u0005%:#AB#gM\u0016\u001cG/\u0003\u0002%\u0019!IA\u0006\u0001B\u0001B\u0003%QfM\u0001\n[>$W\r\u001c+za\u0016\u00042AL\u0019!\u001b\u0005y#B\u0001\u0019\u0007\u0003\u0015iw\u000eZ3m\u0013\t\u0011tFA\u0005N_\u0012,G\u000eV=qK&\u0011A\u0006\u0004\u0005\nk\u0001\u0011\t\u0011)A\u0005mq\n\u0011\u0003]3sg&\u001cH/\u001a8dK\u000e{gNZ5h!\t9$(D\u00019\u0015\tId!\u0001\u0004d_:4\u0017nZ\u0005\u0003wa\u0012\u0011\u0003U3sg&\u001cH/\u001a8dK\u000e{gNZ5h\u0013\t)D\u0002\u0003\u0005?\u0001\t\u0015\r\u0011\"\u0003@\u0003=\u0019\u0017m]:b]\u0012\u0014\u0018mQ8oM&<W#\u0001!\u0011\u0005]\n\u0015B\u0001\"9\u0005=\u0019\u0015m]:b]\u0012\u0014\u0018mQ8oM&<\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\u0002!\r\f7o]1oIJ\f7i\u001c8gS\u001e\u0004\u0003B\u0002$\u0001\t\u0003!q)\u0001\u0004=S:LGO\u0010\u000b\u0006\u0011*[E*\u0014\t\u0005\u0013\u0002q\u0001%D\u0001\u0003\u0011\u0015!S\t1\u0001&\u0011\u0015aS\t1\u0001.\u0011\u0015)T\t1\u00017\u0011\u0015qT\t1\u0001A\u000b\u0011y\u0005\u0001\u0001)\u0003\u0003I+\"!U+\u0011\u000b%\u0013f\u0002\t+\n\u0005M\u0013!AD\"bgN\fg\u000e\u001a:b!J+\u0007o\u001c\t\u0003\u001fU#QA\u0016(C\u0002Q\u0011\u0011\u0001\u0015\u0005\b1\u0002\u0001\r\u0011\"\u0003Z\u0003)\u0019Xm]:j_:|\u0005\u000f^\u000b\u00025B\u0019acW/\n\u0005q;\"AB(qi&|g\u000e\u0005\u0002_O6\tqL\u0003\u0002aC\u0006!1m\u001c:f\u0015\t\u00117-\u0001\u0004ee&4XM\u001d\u0006\u0003I\u0016\f\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002M\u0006\u00191m\\7\n\u0005!|&aB*fgNLwN\u001c\u0005\bU\u0002\u0001\r\u0011\"\u0003l\u00039\u0019Xm]:j_:|\u0005\u000f^0%KF$\"\u0001\\8\u0011\u0005Yi\u0017B\u00018\u0018\u0005\u0011)f.\u001b;\t\u000fAL\u0017\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\t\rI\u0004\u0001\u0015)\u0003[\u0003-\u0019Xm]:j_:|\u0005\u000f\u001e\u0011\t\u0011Q\u0004\u0001R1A\u0005\nU\fqa]3tg&|g.F\u0001w!\r1r/X\u0005\u0003q^\u0011\u0011BR;oGRLwN\u001c\u0019\t\u000bi\u0004A\u0011C>\u0002\u0015\t,\u0018\u000e\u001c3Q%\u0016\u0004x.F\u0002}\u0003\u0003!R!`A\u0002\u0003\u001b\u00012A (\u0000\u001b\u0005\u0001\u0001cA\b\u0002\u0002\u0011)a+\u001fb\u0001)!9\u0011QA=A\u0002\u0005\u001d\u0011!\u00029UsB,\u0007#\u0002\u0018\u0002\n\u0001z\u0018bAA\u0006_\t)\u0001\u000bV=qK\"I\u0011qB=\u0011\u0002\u0003\u0007\u0011\u0011C\u0001\fa>d\u0017PU3q_>\u0003H\u000f\u0005\u0003\u00177\u0006M\u0001\u0007BA\u000b\u00033\u0001BA (\u0002\u0018A\u0019q\"!\u0007\u0005\u0019\u0005m\u0011QDA\u0001\u0002\u0003\u0015\t!!\f\u0003\u0007}#\u0013\u0007C\u0005\u0002\u0010e\u0004\n\u00111\u0001\u0002 A!acWA\u0011a\u0011\t\u0019#a\n\u0011\tyt\u0015Q\u0005\t\u0004\u001f\u0005\u001dB\u0001DA\u000e\u0003;\t\t\u0011!A\u0003\u0002\u0005%\u0012cAA\u00167A\u0019q\"!\u0001\u0012\u0005}\\\u0002bBA\u0019\u0001\u0011E\u00111G\u0001\u001b_B,gNQ1tK\u000e{gN\\3di&|gN\u00117pG.Lgn\u001a\u000b\u0002Y\"9\u0011q\u0007\u0001\u0005\u0012\u0005M\u0012\u0001G2sK\u0006$XMQ1tKN\u001b\u0007.Z7b\u00052|7m[5oO\"9\u00111\b\u0001\u0005\u0012\u0005M\u0012aF2m_N,7i\u001c8oK\u000e$\u0018n\u001c8CY>\u001c7.\u001b8h\u0011%\ty\u0004AI\u0001\n#\n\t%\u0001\u000bck&dG\r\u0015*fa>$C-\u001a4bk2$HEM\u000b\u0005\u0003\u0007\ny&\u0006\u0002\u0002F)\"\u0011qIA'\u001d\r1\u0012\u0011J\u0005\u0004\u0003\u0017:\u0012\u0001\u0002(p]\u0016\\#!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033:\u0012AC1o]>$\u0018\r^5p]&!\u0011QLA*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0007-\u0006u\"\u0019\u0001\u000b")
public class CassandraRepo<F, M>
extends Repo<F, M> {
    private Function0<Session> session;
    private final CassandraConfig cassandraConfig;
    private Option<Session> sessionOpt;
    private volatile boolean bitmap$0;

    private CassandraConfig cassandraConfig() {
        return this.cassandraConfig;
    }

    private Option<Session> sessionOpt() {
        return this.sessionOpt;
    }

    private void sessionOpt_$eq(Option<Session> x$1) {
        this.sessionOpt = x$1;
    }

    private Function0<Session> session$lzycompute() {
        CassandraRepo cassandraRepo = this;
        synchronized (cassandraRepo) {
            if (!this.bitmap$0) {
                this.session = (Function0 & Serializable & scala.Serializable)() -> {
                    Session s;
                    Option<Session> option = this.sessionOpt();
                    if (!(option instanceof Some)) {
                        if (None$.MODULE$.equals(option)) {
                            throw new ConnectionClosedException();
                        }
                        throw new MatchError(option);
                    }
                    Some some = (Some)option;
                    Session session = s = (Session)some.value();
                    return session;
                };
                this.bitmap$0 = true;
            }
        }
        return this.session;
    }

    private Function0<Session> session() {
        return !this.bitmap$0 ? this.session$lzycompute() : this.session;
    }

    public <P> CassandraPRepo<F, M, P> buildPRepo(PType<M, P> pType, Option<CassandraPRepo<F, M, ? super P>> polyRepoOpt) {
        return CassandraPRepo$.MODULE$.apply(super.effect(), super.modelType(), pType, super.persistenceConfig(), polyRepoOpt, this.session());
    }

    @Override
    public <P> None$ buildPRepo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public synchronized void openBaseConnectionBlocking() {
        if (this.sessionOpt().nonEmpty()) {
            throw new ConnectionOpenException();
        }
        Cluster.Builder builder = Cluster.builder().addContactPoint(this.cassandraConfig().address());
        this.cassandraConfig().credentials().foreach((Function1 & Serializable & scala.Serializable)creds -> builder.withCredentials(creds.username(), creds.password()));
        Cluster cluster = builder.build();
        Session session = cluster.connect();
        Object object = this.cassandraConfig().autoCreateKeyspace() ? session.execute(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n            |CREATE KEYSPACE IF NOT EXISTS ", "\n            |WITH replication = {\n            |  'class': 'SimpleStrategy',\n            |  'replication_factor': ", "\n            |};\n            |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cassandraConfig().keyspace(), BoxesRunTime.boxToInteger((int)this.cassandraConfig().replicationFactor())})))).stripMargin()) : BoxedUnit.UNIT;
        try {
            session.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"use ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cassandraConfig().keyspace()})));
        }
        catch (Throwable throwable) {
            InvalidQueryException invalidQueryException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidQueryException && (invalidQueryException = (InvalidQueryException)throwable2).getMessage().startsWith("Keyspace '") && invalidQueryException.getMessage().endsWith("' does not exist")) {
                throw new KeyspaceDoesNotExistException(this.cassandraConfig(), invalidQueryException);
            }
            throw throwable;
        }
        this.sessionOpt_$eq((Option<Session>)new Some((Object)session));
    }

    @Override
    public void createBaseSchemaBlocking() {
    }

    @Override
    public synchronized void closeConnectionBlocking() {
        if (this.sessionOpt().isEmpty()) {
            throw new ConnectionClosedException();
        }
        ((Session)this.sessionOpt().get()).close();
        ((Session)this.sessionOpt().get()).getCluster().close();
        this.pRepoMap().values().foreach((Function1 & Serializable & scala.Serializable)pr -> {
            pr.preparedStatements_$eq((Map<String, PreparedStatement>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            return BoxedUnit.UNIT;
        });
        this.sessionOpt_$eq((Option<Session>)None$.MODULE$);
    }

    public CassandraRepo(Effect<F> effect, ModelType<M> modelType, PersistenceConfig persistenceConfig, CassandraConfig cassandraConfig) {
        this.cassandraConfig = cassandraConfig;
        super(effect, modelType, persistenceConfig);
        this.sessionOpt = None$.MODULE$;
    }
}

