/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence;

import longevity.config.BackEnd;
import longevity.config.Cassandra$;
import longevity.config.CassandraConfig;
import longevity.config.InMem$;
import longevity.config.JDBC$;
import longevity.config.JdbcConfig;
import longevity.config.LongevityConfig;
import longevity.config.MongoDB$;
import longevity.config.MongoDBConfig;
import longevity.config.SQLite$;
import longevity.effect.Effect;
import longevity.model.ModelType;
import longevity.persistence.Repo;
import longevity.persistence.cassandra.CassandraRepo;
import longevity.persistence.inmem.InMemRepo;
import longevity.persistence.jdbc.JdbcRepo;
import longevity.persistence.mongo.MongoRepo;
import longevity.persistence.sqlite.SQLiteRepo;
import scala.MatchError;

public final class Repo$ {
    public static Repo$ MODULE$;

    static {
        new Repo$();
    }

    public <F, M> Repo<F, M> apply(Effect<F> effect, ModelType<M> modelType, BackEnd backEnd, LongevityConfig config, boolean test) {
        Repo repo;
        block10: {
            Repo repo2;
            BackEnd backEnd2 = backEnd;
            if (Cassandra$.MODULE$.equals(backEnd2)) {
                CassandraConfig cassandraConfig = test ? config.test().cassandra() : config.cassandra();
                repo2 = new CassandraRepo<F, M>(effect, modelType, config, cassandraConfig);
            } else if (InMem$.MODULE$.equals(backEnd2)) {
                repo2 = new InMemRepo<F, M>(effect, modelType, config);
            } else if (MongoDB$.MODULE$.equals(backEnd2)) {
                MongoDBConfig mongoConfig = test ? config.test().mongodb() : config.mongodb();
                repo2 = new MongoRepo<F, M>(effect, modelType, config, mongoConfig);
            } else if (SQLite$.MODULE$.equals(backEnd2)) {
                JdbcConfig jdbcConfig = test ? config.test().jdbc() : config.jdbc();
                repo2 = new SQLiteRepo<F, M>(effect, modelType, config, jdbcConfig);
            } else if (JDBC$.MODULE$.equals(backEnd2)) {
                JdbcConfig jdbcConfig = test ? config.test().jdbc() : config.jdbc();
                repo2 = new JdbcRepo<F, M>(effect, modelType, config, jdbcConfig);
            } else {
                throw new MatchError((Object)backEnd2);
            }
            repo = repo2;
            if (!config.autoOpenConnection()) break block10;
            repo.longevity$persistence$Repo$$openConnectionBlocking();
        }
        return repo;
    }

    private Repo$() {
        MODULE$ = this;
    }
}

